/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces;

import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InterfaceConfiguration {
    private static final Log log = LogFactory.getLog(InterfaceConfiguration.class);
    private static ConfigurationClient configuration = new ConfigurationClient();
    private Properties properties;

    protected InterfaceConfiguration() {
        this.init();
    }

    public String getString(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return value;
        }
        log.warn((Object)("parameter " + key + " could not be found"));
        return "";
    }

    public int getInt(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.warn((Object)(key + " has an invalid number format: " + value));
            }
        } else {
            log.warn((Object)("parameter " + key + " could not be found"));
        }
        return 0;
    }

    public double getDouble(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.warn((Object)(key + " has an invalid number format: " + value));
            }
        } else {
            log.warn((Object)("parameter " + key + " could not be found"));
        }
        return 0.0;
    }

    public String[] getStringArray(String key, String delimiter) {
        String value = this.getProperty(key);
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
            String[] elementArray = new String[tokenizer.countTokens()];
            for (int index = 0; index < elementArray.length; ++index) {
                elementArray[index] = tokenizer.nextToken();
            }
            return elementArray;
        }
        log.warn((Object)("parameter " + key + " could not be found"));
        return new String[0];
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, ",");
    }

    public long[] getLongArray(String key) {
        String value = this.getProperty(key);
        StringTokenizer tokenizer = new StringTokenizer(value);
        long[] elementArray = new long[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = Long.parseLong(tokenizer.nextToken());
        }
        return elementArray;
    }

    public boolean getBoolean(String key) {
        String value = this.getProperty(key);
        return Boolean.parseBoolean(value);
    }

    public boolean isConfigured(String key) {
        if (this.properties == null) {
            this.properties = this.getAllProperties();
        }
        return this.properties.containsKey(this.getPrefix() + key);
    }

    public boolean containsKey(String key) {
        return this.isConfigured(key);
    }

    public void updateProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = this.getAllProperties();
        }
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            this.properties = this.getAllProperties();
        }
        return this.properties.getProperty(this.getPrefix() + key);
    }

    private Properties getAllProperties() {
        Properties dbProperties = configuration.getProperties();
        Properties allProperties = configuration.getDefaultProperties();
        allProperties.putAll((Map<?, ?>)dbProperties);
        return allProperties;
    }

    protected abstract String getPrefix();

    public abstract boolean isInterfaceActive();

    protected abstract void init();
}

