/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.geo;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.CurrentGdataCacheDAO;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeRemote;
import de.proveo.wwt.logic.ejb.geo.GdataHistoryDAO;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="GdataFacade")
@Remote(value={GdataFacadeRemote.class})
@Local(value={GdataFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/GdataFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/GdataFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class GdataFacadeBean
implements GdataFacadeLocal,
GdataFacadeRemote {
    private static final Log log = LogFactory.getLog(GdataFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private CurrentGdataCacheDAO gdataCacheDAO = null;
    private GdataHistoryDAO gdataHistoryDAO = null;
    @EJB
    private EventPersisterFacadeLocal eventPersisterFacade;

    @PostConstruct
    public void ejbCreate() {
        this.gdataCacheDAO = CurrentGdataCacheDAO.newInstance(this.entityManager);
        this.gdataHistoryDAO = GdataHistoryDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public String getCurrentArea(long unitId) {
        Area area;
        GdataCache gdataCache = this.gdataCacheDAO.findByUnitId(unitId);
        String areaName = "";
        if (gdataCache != null && (area = gdataCache.getArea()) != null) {
            areaName = area.getName();
        }
        return areaName;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public GeoStruct findGeoStructByUnitIdAndBeginTime(long unitId, long beginTime) {
        List<GdataHistory> listHistory = this.gdataHistoryDAO.findByUnitIdBegintime(unitId, beginTime);
        if (listHistory.size() > 0) {
            return listHistory.get(0).getStruct();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public GdataHistory findGdataHistoryByUnitIdAndBeginTime(long unitId, long beginTime) {
        List<GdataHistory> listHistory = this.gdataHistoryDAO.findByUnitIdBegintime(unitId, beginTime);
        if (listHistory.size() > 0) {
            return listHistory.get(0);
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(UnitModel unitModel) {
        GdataCache gdataCache = this.gdataCacheDAO.findByUnitId(unitModel.getUnitId());
        if (gdataCache != null) {
            long endTime = System.currentTimeMillis();
            GdataHistory history = gdataCache.getHistory();
            history.setEndTime(endTime);
            history.setEndReceiveTime(endTime);
            this.eventPersisterFacade.writeHistoryHelperEntries(history);
            history.setCache(null);
            this.gdataCacheDAO.removeEntity(gdataCache);
        }
    }

    @Override
    @Business(viewType="both")
    public List<GdataCache> findCacheAll() {
        return this.gdataCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<GdataCache> findCacheByUnitGroupId(long unitGroupId) {
        return this.gdataCacheDAO.findByUnitGroupId(unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public GdataCache findCacheByUnitId(long unitId) {
        return this.gdataCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public void removeCurrentGdataCache(GdataCache entity) {
        this.gdataCacheDAO.removeEntity(entity);
    }

    @Override
    @Business(viewType="both")
    public List<GdataCache> findCacheAllByCreateTime(long endTime) {
        return this.gdataCacheDAO.findAllByCreateTime(endTime);
    }

    @Override
    @Business(viewType="both")
    public List<GdataHistory> findByUnitBeginEnd(long unitId, long since, long until) {
        return this.gdataHistoryDAO.findByUnit(since, until, unitId);
    }

    @Override
    @Business(viewType="both")
    public long getMaxId() {
        return this.gdataHistoryDAO.findMaxId();
    }

    @Override
    @Business(viewType="both")
    public List<GdataCache> findCacheByUnitGroupIdCreateTime(long unitGroupId, long endTime) {
        return this.gdataCacheDAO.findByUnitGroupIdCreateTime(unitGroupId, endTime);
    }

    @Override
    @Business(viewType="both")
    public List<GdataCache> findCacheByUnitIdCreatedTime(long unitId, long endTime) {
        return this.gdataCacheDAO.findByUnitIdCreatedTime(unitId, endTime);
    }
}

