/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.zeroconf;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.zeroconf.Zeroconf;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.general.zeroconf.ZeroconfDAO;
import de.proveo.wwt.logic.ejb.general.zeroconf.ZeroconfFacadeLocal;
import de.proveo.wwt.logic.ejb.general.zeroconf.ZeroconfFacadeRemote;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="ZeroconfFacade")
@Remote(value={ZeroconfFacadeRemote.class})
@Local(value={ZeroconfFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ZeroconfFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ZeroconfFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class ZeroconfFacadeBean
implements ZeroconfFacadeLocal,
ZeroconfFacadeRemote {
    private static final Log log = LogFactory.getLog(ZeroconfFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager em;
    private ZeroconfDAO zeroconfDAO;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.zeroconfDAO = ZeroconfDAO.newInstance(this.em);
    }

    @Override
    @Business(viewType="both")
    public void update(Properties event, EventInfo eventInfo) {
        Zeroconf zeroconf;
        List<Zeroconf> zeroconfs = this.zeroconfDAO.findBySerialNumberAndType(eventInfo.serialNumber, eventInfo.deviceType);
        if (zeroconfs.isEmpty()) {
            zeroconf = new Zeroconf();
            zeroconf.setHardwareSerialNumber(eventInfo.serialNumber);
            zeroconf.setDeviceType(eventInfo.deviceType);
            zeroconf.setFirstMessageTimestamp(Long.parseLong(event.getProperty("t")));
            zeroconf.setFirstMessageReceiveTimestamp(eventInfo.receiveTime);
        } else {
            zeroconf = zeroconfs.get(0);
        }
        zeroconf.setLastMessageReceiveTimestamp(eventInfo.receiveTime);
        zeroconf.setLastMessageTimestamp(Long.parseLong(event.getProperty("t")));
        if (zeroconfs.isEmpty()) {
            this.zeroconfDAO.createEntity(zeroconf);
            this.em.flush();
        } else {
            this.zeroconfDAO.updateEntity(zeroconf);
        }
    }

    @Override
    @Business(viewType="both")
    public void handleBootEvent(Properties event, EventInfo eventInfo) {
        if (eventInfo.serialNumber == null || eventInfo.deviceType == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("handleBootEvent() serialNumber or deviceType cannot be null " + event));
            }
            return;
        }
        List<Zeroconf> zeroconfs = this.zeroconfDAO.findBySerialNumberAndType(eventInfo.serialNumber, eventInfo.deviceType);
        for (Zeroconf zerconf : zeroconfs) {
            this.zeroconfDAO.removeEntity(zerconf);
        }
    }

    @Override
    @Business(viewType="both")
    public List<Zeroconf> getZeroConfUnits() {
        return this.zeroconfDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public void assignZeroConfDeviceToUnit(String unitType, String serialNumber, long unitId) throws ObjectNotFoundException {
        List<Zeroconf> zeroconfs = this.zeroconfDAO.findBySerialNumberAndType(serialNumber, unitType);
        if (zeroconfs.isEmpty()) {
            throw new ObjectNotFoundException();
        }
        Zeroconf device = zeroconfs.get(0);
        device.setUnitId(unitId);
    }
}

