/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.version;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.VersionUtil;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionLocal;
import de.proveo.wwt.logic.ejb.general.version.WwtVersionRemote;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="WwtVersion")
@Remote(value={WwtVersionRemote.class})
@Local(value={WwtVersionLocal.class})
@JndiLocalBinding(localJndiBinding="rts/WwtVersion")
@JndiRemoteBinding(remoteJndiBinding="rts/WwtVersion")
public class WwtVersionBean
implements WwtVersionLocal,
WwtVersionRemote {
    private static final Log log = LogFactory.getLog(WwtVersionBean.class);
    private final VersionUtil versionUtil = new VersionUtil();

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            this.versionUtil.load(this.getClass());
        }
        catch (IOException ex) {
            log.error((Object)"cannot load version properties file", (Throwable)ex);
            throw new CreateException("cannot load version properties file");
        }
    }

    @Override
    @Business(viewType="both")
    public String getVersionInfo(String name) {
        String value = this.versionUtil.getProperty(name).trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getVersionInfo() name: '" + name + "' value: '" + value + "'"));
        }
        return value;
    }

    @Override
    @Business(viewType="both")
    public String getRepositoryInfo(String key) {
        return this.versionUtil.getRepositoryInfo(key);
    }
}

