/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.tree;

import de.proveo.wwt.logic.ejb.general.tree.NodeMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;

public class TreeNode<T extends TreeNode, D>
implements Serializable {
    private static final long serialVersionUID = -7927404857816041113L;
    private T parent = null;
    protected List<T> children = null;
    private D data = null;

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public void addChild(T child) {
        if (child != null) {
            child.setParent((TreeNode)this);
            this.getChildren().add(child);
        }
    }

    public void addChildren(T[] children) {
        for (int i = 0; i != children.length; ++i) {
            if (children[i] == null) continue;
            this.addChild(children[i]);
        }
    }

    public void addChildren(List<T> children) {
        for (int i = 0; i != children.size(); ++i) {
            this.addChild((TreeNode)children.get(i));
        }
    }

    public void addChildren(Iterator<T> children) {
        while (children.hasNext()) {
            this.addChild((TreeNode)children.next());
        }
    }

    public void remove() {
        TreeNode parent = this.getParent();
        if (parent != null) {
            parent.removeChild((TreeNode)this);
        }
    }

    public void removeChild(T child) {
        this.getChildren().remove(child);
    }

    public void removeChildren(T[] children) {
        List<T> list = this.getChildren();
        for (int i = 0; i != children.length; ++i) {
            list.remove(children[i]);
        }
    }

    public void removeChildren(List<T> children) {
        this.getChildren().removeAll(children);
    }

    public void removeChildren(Iterator<T> children) {
        List<T> list = this.getChildren();
        while (children.hasNext()) {
            list.remove(children.next());
        }
    }

    public void removeChild(int index) {
        List<T> list = this.getChildren();
        if (list.size() == 0 || index < 0 || index < list.size()) {
            // empty if block
        }
        list.remove(index);
    }

    public void removeAllChildren() {
        this.getChildren().clear();
    }

    public List<T> getNodes(boolean childrenOnly) {
        return this.getNodes(childrenOnly, null);
    }

    private List<T> getNodes(boolean childrenOnly, NodeMatcher matcher, boolean firstNodeOnly) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        UnboundedFifoBuffer nodeQueue = new UnboundedFifoBuffer();
        nodeQueue.add((Object)this);
        while (!nodeQueue.isEmpty()) {
            TreeNode currentNode = (TreeNode)nodeQueue.remove();
            List<T> children = currentNode.getChildren();
            for (int i = 0; i != children.size(); ++i) {
                nodeQueue.add(children.get(i));
            }
            if (matcher != null) {
                if (!matcher.match(currentNode)) continue;
                nodes.add(currentNode);
                if (!firstNodeOnly) continue;
                break;
            }
            nodes.add(currentNode);
            if (!firstNodeOnly) continue;
            break;
        }
        if (childrenOnly && nodes.size() != 0 && nodes.get(0) == this) {
            nodes.remove(0);
        }
        return nodes;
    }

    public List<T> getNodes(boolean childrenOnly, NodeMatcher matcher) {
        return this.getNodes(childrenOnly, matcher, false);
    }

    public T getNode(boolean childrenOnly, NodeMatcher matcher) {
        List<T> nodes = this.getNodes(childrenOnly, matcher, true);
        return (T)(nodes.size() == 0 ? null : (TreeNode)nodes.get(0));
    }

    public List<T> getAllNodes(boolean includeRoot) {
        return ((TreeNode)this.getRoot()).getNodes(!includeRoot);
    }

    public List<T> getAllNodes(boolean includeRoot, NodeMatcher matcher) {
        return ((TreeNode)this.getRoot()).getNodes(!includeRoot, matcher);
    }

    public T getRoot() {
        TreeNode<T, D> currentNode = this;
        while (currentNode.getParent() != null) {
            currentNode = currentNode.getParent();
        }
        return (T)currentNode;
    }

    public T getParent() {
        return this.parent;
    }

    public void setParent(T parent) {
        this.parent = parent;
    }

    public List<T> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<T>();
        }
        return this.children;
    }

    public D getData() {
        return this.data;
    }

    public void setData(D data) {
        this.data = data;
    }
}

