/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.status;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.status.StatusLocal;
import de.proveo.wwt.logic.ejb.general.status.StatusRemote;
import java.util.Date;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="Status")
@Remote(value={StatusRemote.class})
@Local(value={StatusLocal.class})
@JndiLocalBinding(localJndiBinding="rts/Status")
@JndiRemoteBinding(remoteJndiBinding="rts/Status")
public class StatusBean
implements StatusLocal,
StatusRemote {
    private static final Log log = LogFactory.getLog(StatusBean.class);
    @EJB
    private ConfigurationLocal configuration = null;
    private static final String TEST_KEY = "status.testkey";
    private static final String TX1_TEST_KEY = "status.testkey.tx1";
    private static final String TX2_TEST_KEY = "status.testkey.tx2";

    @Override
    @Business(viewType="both")
    public void ping() {
    }

    @Override
    @Business(viewType="both")
    public void ejbReadTest() {
        try {
            this.configuration.getParameter(TEST_KEY);
        }
        catch (ConfigurationParameterNotFoundException ex) {
            this.configuration.setParameter(TEST_KEY, new Date().toString());
        }
    }

    @Override
    @Business(viewType="both")
    public void ejbWriteTest() {
        this.configuration.setParameter(TEST_KEY, new Date().toString());
    }

    @Override
    @Business(viewType="both")
    public void ejbTransactionTest(boolean rollback) {
        String str = new Date().toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTransactionTest() " + str));
        }
        this.configuration.setParameter(TX1_TEST_KEY, str);
        this.configuration.setParameter(TX2_TEST_KEY, str);
        if (rollback) {
            throw new EJBException("TestTXrollback");
        }
    }
}

