/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.performanceCounter;

import de.proveo.wwt.logic.ejb.general.tableMappings.PerformanceCounterReceiveTimeTableMapping;
import de.proveo.wwt.logic.ejb.general.tableMappings.PerformanceCounterTableMappings;
import de.proveo.wwt.logic.web.data.performanceCounter.PerformanceCounterStatisticsBase;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class PerformanceCounterScheduler {
    private static final Log log = LogFactory.getLog(PerformanceCounterScheduler.class);
    private static Scheduler scheduler = null;
    private static Object schedulerSync = new Object();
    private static final String QUARTZ_JOB_ID = "PERFORMANCE_COUNTER_UPDATE_JOB";
    private static final String QUARTZ_RUNNABLE = "PERFORMANCE_COUNTER_RUNNABLE";
    private static final String QUARTZ_TRIGGER_NAME = "PERFORMANCE_COUNTER_TRIGGER";
    private static final String QUARTZ_TRIGGER_GROUP = "PERFORMANCE_COUNTER_GROUP";
    private static final String QUARTZ_JOB_INTERVAL = "0 5 * * * ?";
    private static final String NOT_FULLY_COMPATIBLE_DBMS = "Performance counter scheduler cannot be started because used DBMS is not fully compatible. Using direct queries instead.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        PerformanceCounterStatisticsBase<PerformanceCounterReceiveTimeTableMapping> pcflb = PerformanceCounterStatisticsBase.getInstance(PerformanceCounterReceiveTimeTableMapping.class);
        if (!pcflb.fullyCompatible()) {
            log.warn((Object)NOT_FULLY_COMPATIBLE_DBMS);
            return;
        }
        Object object = schedulerSync;
        synchronized (object) {
            if (scheduler != null) {
                log.error((Object)"Performance counter timer already started!");
                return;
            }
            try {
                log.info((Object)"Starting performance counter update scheduler...");
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
                scheduler = schedulerFactory.getScheduler();
                scheduler.start();
                JobDetail jobDetail = new JobDetail(QUARTZ_JOB_ID, "DEFAULT", JobHandler.class);
                PerformanceCounterTableMappings[] mappings = PerformanceCounterTableMappings.values();
                ArrayList<Runnable> runnables = new ArrayList<Runnable>();
                for (int i = 0; i != mappings.length; ++i) {
                    PerformanceCounterStatisticsBase<? extends Enum<?>> instance = PerformanceCounterStatisticsBase.getInstance(mappings[i].getEnumClass());
                    if (!(instance instanceof Runnable)) continue;
                    Runnable runnable = (Runnable)((Object)instance);
                    runnables.add(runnable);
                    runnable.run();
                }
                jobDetail.getJobDataMap().put((Object)QUARTZ_RUNNABLE, (Object)runnables.toArray(new Runnable[runnables.size()]));
                CronTrigger cronTrigger = new CronTrigger(QUARTZ_TRIGGER_NAME, QUARTZ_TRIGGER_GROUP, QUARTZ_JOB_ID, null, new Date(System.currentTimeMillis()), null, QUARTZ_JOB_INTERVAL);
                scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            }
            catch (SchedulerException e) {
                log.error((Object)("Cannot start performance counter scheduler: " + e.getMessage()));
                scheduler = null;
                return;
            }
            catch (ParseException e) {
                log.error((Object)"Error parsing CronTrigger data!");
                scheduler = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        PerformanceCounterStatisticsBase<PerformanceCounterReceiveTimeTableMapping> pcflb = PerformanceCounterStatisticsBase.getInstance(PerformanceCounterReceiveTimeTableMapping.class);
        if (!pcflb.fullyCompatible()) {
            log.warn((Object)NOT_FULLY_COMPATIBLE_DBMS);
            return;
        }
        Object object = schedulerSync;
        synchronized (object) {
            if (scheduler == null) {
                log.error((Object)"Performance counter timer already stopped!");
                return;
            }
            log.debug((Object)"Stopping performance counter update scheduler...");
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                log.error((Object)("Cannot shutdown scheduler: " + e.getMessage()));
            }
            scheduler = null;
        }
    }

    public static class JobHandler
    implements Job {
        public void execute(JobExecutionContext jec) throws JobExecutionException {
            Runnable[] runnables = (Runnable[])jec.getJobDetail().getJobDataMap().get((Object)PerformanceCounterScheduler.QUARTZ_RUNNABLE);
            for (int i = 0; i != runnables.length; ++i) {
                runnables[i].run();
            }
        }
    }
}

