/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.measurement;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementInterval;
import de.proveo.wwt.datamodel.measurement.MeasurementIntervalDefn;
import de.proveo.wwt.datamodel.measurement.MeasurementType;
import de.proveo.wwt.datamodel.measurement.MeasurementUnit;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementCacheDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementDefinitionDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeRemote;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementHistoryDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementIntervalDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementIntervalDefnDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementTypeDAO;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementUnitDAO;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBaseComparator;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.fastlanereader.report.MeasurementFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.MeasurementIntervalFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementDTO;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementDiffDTO;
import de.proveo.wwt.logic.web.historyData.dto.MeasurementIntervalDTO;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="MeasurementFacade")
@Remote(value={MeasurementFacadeRemote.class})
@Local(value={MeasurementFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MeasurementFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/MeasurementFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class MeasurementFacadeBean
implements MeasurementFacadeLocal,
MeasurementFacadeRemote {
    private static final Log log = LogFactory.getLog(MeasurementFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private PermissionCheckerLocal permissionCheckerLocal = null;
    private MeasurementCacheDAO measurementCacheDAO;
    private MeasurementHistoryDAO measurementHistoryDAO;
    private MeasurementDefinitionDAO measurementDefinitionDAO;
    private MeasurementTypeDAO measurementTypeDAO;
    private MeasurementUnitDAO measurementUnitDAO;
    private MeasurementIntervalDefnDAO measurementIntervalDefnDAO;
    private MeasurementIntervalDAO measurementIntervalDAO;

    @PostConstruct
    public void initialize() {
        this.measurementCacheDAO = MeasurementCacheDAO.newInstance(this.entityManager);
        this.measurementHistoryDAO = MeasurementHistoryDAO.newInstance(this.entityManager);
        this.measurementDefinitionDAO = MeasurementDefinitionDAO.newInstance(this.entityManager);
        this.measurementTypeDAO = MeasurementTypeDAO.newInstance(this.entityManager);
        this.measurementUnitDAO = MeasurementUnitDAO.newInstance(this.entityManager);
        this.measurementIntervalDefnDAO = MeasurementIntervalDefnDAO.newInstance(this.entityManager);
        this.measurementIntervalDAO = MeasurementIntervalDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementCache> getMeasurementCache() {
        return this.measurementCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public MeasurementCache getMeasurementCacheByUnitAndType(long unitId, int measurementDefnId) {
        return this.measurementCacheDAO.findbyUnitIdAndMeasurementDefinition(unitId, measurementDefnId);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementDefinition> getMeasurementDefinitions() {
        return this.measurementDefinitionDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public MeasurementDefinition getMeasurementDefinition(int id) {
        return (MeasurementDefinition)this.measurementDefinitionDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementDefinition> getMeasurementDefinitionByMeasurementType(int measurementTypeId) {
        return this.measurementDefinitionDAO.findbyMeasurementType(measurementTypeId);
    }

    @Override
    @Business(viewType="both")
    public MeasurementInterval createMeasurementInterval(MeasurementInterval interval) {
        this.measurementIntervalDAO.createEntity(interval);
        return interval;
    }

    @Override
    @Business(viewType="both")
    public MeasurementDefinition createMeasurementDefinition(MeasurementDefinition measurementDefinition) throws CreateException {
        this.measurementDefinitionDAO.createEntity(measurementDefinition);
        return measurementDefinition;
    }

    @Override
    @Business(viewType="both")
    public MeasurementDefinition createMeasurementDefinitionFlush(MeasurementDefinition measurementDefinition) throws CreateException {
        measurementDefinition = this.createMeasurementDefinition(measurementDefinition);
        this.entityManager.flush();
        return measurementDefinition;
    }

    @Override
    @Business(viewType="both")
    public void updateMeasurementDefinition(MeasurementDefinition measurementDefinition) throws ObjectNotFoundException {
        MeasurementDefinition oldMeasurementDefinition = (MeasurementDefinition)this.measurementDefinitionDAO.findByPrimaryKey(measurementDefinition.getId());
        if (((Object)((Object)oldMeasurementDefinition)).equals((Object)measurementDefinition)) {
            return;
        }
        this.measurementDefinitionDAO.updateEntity(measurementDefinition);
    }

    @Override
    @Business(viewType="both")
    public void deleteMeasurementDefinition(int measurementDefinitionId) throws RemoveException, ObjectNotFoundException {
        MeasurementDefinition measurementDefinition = (MeasurementDefinition)this.measurementDefinitionDAO.findByPrimaryKey(measurementDefinitionId);
        this.measurementDefinitionDAO.removeEntity(measurementDefinition);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementType> getMeasurementTypes() {
        return this.measurementTypeDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public MeasurementType getMeasurementType(int id) {
        return (MeasurementType)this.measurementTypeDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementType> getMeasurementTypesEnabled() {
        return this.measurementTypeDAO.findAllEnabled();
    }

    @Override
    @Business(viewType="both")
    public MeasurementType createMeasurementType(MeasurementType measurementType) throws CreateException {
        this.measurementTypeDAO.createEntity(measurementType);
        return measurementType;
    }

    @Override
    @Business(viewType="both")
    public MeasurementType createMeasurementTypeFlush(MeasurementType measurementType) throws CreateException {
        measurementType = this.createMeasurementType(measurementType);
        this.entityManager.flush();
        return measurementType;
    }

    @Override
    @Business(viewType="both")
    public void updateMeasurementType(MeasurementType measurementType) throws ObjectNotFoundException {
        MeasurementType oldMeasurementType = (MeasurementType)this.measurementTypeDAO.findByPrimaryKey(measurementType.getId());
        if (oldMeasurementType.equals((Object)measurementType)) {
            return;
        }
        this.measurementTypeDAO.updateEntity(measurementType);
    }

    @Override
    @Business(viewType="both")
    public void deleteMeasurementType(int id) throws RemoveException, ObjectNotFoundException {
        MeasurementType measurementType = (MeasurementType)this.measurementTypeDAO.findByPrimaryKey(id);
        this.measurementTypeDAO.removeEntity(measurementType);
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementUnit> getMeasurementUnits() {
        return this.measurementUnitDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public MeasurementUnit getMeasurementUnit(int id) {
        return (MeasurementUnit)this.measurementUnitDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public MeasurementUnit createMeasurementUnit(MeasurementUnit measurementUnit) throws CreateException {
        this.measurementUnitDAO.createEntity(measurementUnit);
        return measurementUnit;
    }

    @Override
    @Business(viewType="both")
    public void updateMeasurementUnit(MeasurementUnit measurementUnit) throws ObjectNotFoundException {
        MeasurementUnit oldMeasurementUnit = (MeasurementUnit)this.measurementUnitDAO.findByPrimaryKey(measurementUnit.getId());
        if (oldMeasurementUnit.equals((Object)measurementUnit)) {
            return;
        }
        this.measurementUnitDAO.updateEntity(measurementUnit);
    }

    @Override
    @Business(viewType="both")
    public void deleteMeasurementUnit(int id) throws RemoveException, ObjectNotFoundException {
        MeasurementUnit measurementUnit = (MeasurementUnit)this.measurementUnitDAO.findByPrimaryKey(id);
        this.measurementUnitDAO.removeEntity(measurementUnit);
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<MeasurementDTO> getMeasurementCache(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<MeasurementDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new MeasurementFastLaneReader().getCache(list, null, selectionDTO, extData);
        this.permissionCheckerLocal.checkDTOList(list);
        log.debug((Object)("returning list with size -> " + list.size()));
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<MeasurementDTO> getMeasurementHistory(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<MeasurementDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new MeasurementFastLaneReader().getHistory(list, null, selectionDTO, extData);
        this.permissionCheckerLocal.checkDTOList(list);
        log.debug((Object)("returning list with size -> " + list.size()));
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<MeasurementDiffDTO> getMeasurementDiff(int measurementId, ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<MeasurementDTO> measurementEvents = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new MeasurementFastLaneReader().getHistory(measurementEvents, measurementId, selectionDTO, extData);
        Collections.sort(measurementEvents, new ReportDTOBaseComparator(ReportDTOBaseComparator.CompareType.UNIT_ID, ReportDTOBaseComparator.CompareType.BEGIN_TIME));
        ReportDTOListBase<MeasurementDiffDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        HashMap<Long, MeasurementDTO> unitToStartMeasurementMap = new HashMap<Long, MeasurementDTO>();
        for (MeasurementDTO end : measurementEvents) {
            Long unitId = end.getUnitId();
            MeasurementDTO start = (MeasurementDTO)unitToStartMeasurementMap.get(unitId);
            if (start == null) {
                unitToStartMeasurementMap.put(unitId, end);
                continue;
            }
            MeasurementDiffDTO dto = new MeasurementDiffDTO(start, end);
            unitToStartMeasurementMap.put(unitId, end);
            list.add(dto);
        }
        block1: for (MeasurementDTO start : unitToStartMeasurementMap.values()) {
            for (MeasurementDiffDTO dto : list) {
                if (dto.getUnitId().intValue() != start.getUnitId().intValue()) continue;
                continue block1;
            }
            MeasurementDiffDTO dto = new MeasurementDiffDTO(start, null);
            list.add(dto);
        }
        this.permissionCheckerLocal.checkDTOList(list);
        log.debug((Object)("returning list with size -> " + measurementEvents.size()));
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<MeasurementIntervalDTO> getMeasurementInterval(Integer measurementIntervalId, ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<MeasurementIntervalDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new MeasurementIntervalFastLaneReader().getHistory(list, measurementIntervalId, selectionDTO, extData);
        this.permissionCheckerLocal.checkDTOList(list);
        log.debug((Object)("returning list with size -> " + list.size()));
        return list;
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementIntervalDefn> getAllMeasurementIntervalDefn() {
        return this.measurementIntervalDefnDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public List<MeasurementIntervalDefn> getMeasurementIntervalDefn(int measurementId) {
        return this.measurementIntervalDefnDAO.findByMeasurementDefnId(measurementId);
    }

    @Override
    @Business(viewType="both")
    public MeasurementIntervalDefn getMeasurementIntervalDefnById(int measurementId) {
        return (MeasurementIntervalDefn)this.measurementIntervalDefnDAO.findByPrimaryKey(measurementId);
    }

    @Override
    @Business(viewType="both")
    public void createMeasurementIntervalDefn(MeasurementIntervalDefn measurementIntervalDefn) {
        this.measurementIntervalDefnDAO.createEntity(measurementIntervalDefn);
    }

    @Override
    @Business(viewType="both")
    public void updateMeasurementIntervalDefn(MeasurementIntervalDefn measurementIntervalDefn) {
        this.measurementIntervalDefnDAO.updateEntity(measurementIntervalDefn);
    }

    @Override
    @Business(viewType="both")
    public void removeMeasurementIntervalDefn(MeasurementIntervalDefn measurementIntervalDefn) {
        measurementIntervalDefn = (MeasurementIntervalDefn)this.measurementIntervalDefnDAO.updateEntity(measurementIntervalDefn);
        measurementIntervalDefn.getMeasurementDefn().getMeasurementIntervalDefns().remove((Object)measurementIntervalDefn);
        this.measurementIntervalDefnDAO.removeEntity(measurementIntervalDefn);
    }
}

