/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.unit;

import de.micromata.opengis.kml.v_2_2_0.Data;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.ExtendedData;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.NotificationDataInfo;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.notification.Notification;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationDataExport {
    private static final Log log = LogFactory.getLog(NotificationDataExport.class);
    private static final String DOCUMENT_NAME = "NotificationData";
    private List<Notification> notifications = new ArrayList<Notification>();
    private ReportDTOListBase<NotificationDTO> dataList;
    private HistoryDataFacadeLocal historyDataFacade;
    private NotificationAdministrationFacadeLocal notificationFacade;
    private AreaInFacadeLocal areaInFacade;

    public NotificationDataExport() {
        try {
            InitialContext context = new InitialContext();
            this.historyDataFacade = (HistoryDataFacadeLocal)context.lookup("rts/HistoryDataFacade/local");
            this.notificationFacade = (NotificationAdministrationFacadeLocal)context.lookup("rts/NotificationAdministrationFacade/local");
            this.areaInFacade = (AreaInFacadeLocal)context.lookup("rts/AreaInFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public byte[] export(ReportSelectionDTO selectionDTO, Long messageId) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(DOCUMENT_NAME);
        this.notifications = this.notificationFacade.getAllNotifications();
        for (NotificationDataInfo info : this.getInfo(selectionDTO, messageId)) {
            doc.addToFeature((Feature)NotificationDataExport.generatePlacemark(info));
        }
        for (Notification notification : this.notifications) {
            Style style = new Style();
            PolyStyle ps = new PolyStyle();
            String[] colorValues = notification.getRgbColor().split(",");
            Color color = new Color(Integer.parseInt(colorValues[0]), Integer.parseInt(colorValues[1]), Integer.parseInt(colorValues[2]));
            ps.setColor(KmlUtil.kmlColor((Color)color));
            style.setPolyStyle(ps);
            style.setId(String.valueOf(notification.getId()));
            doc.addToStyleSelector((StyleSelector)style);
        }
        return KmlUtil.serialize((Kml)kml);
    }

    private static Placemark generatePlacemark(NotificationDataInfo info) {
        Point point = KmlUtil.createPoint((GeoPoint)info.point);
        Placemark placemark = new Placemark();
        placemark.setId(String.valueOf(info.id));
        placemark.setName(info.name);
        placemark.setDescription(info.description);
        placemark.setGeometry((Geometry)point);
        ExtendedData extData = new ExtendedData();
        Data data = new Data("");
        data.setName("messageId");
        data.setValue(String.valueOf(info.messageId));
        extData.addToData(data);
        placemark.setExtendedData(extData);
        return placemark;
    }

    private long[] calculateCenter(Area a) {
        long[] result = new long[]{a.getMaxLatMsec() - (a.getMaxLatMsec() - a.getMinLatMsec()) / 2, a.getMaxLongMsec() - (a.getMaxLongMsec() - a.getMinLongMsec()) / 2};
        return result;
    }

    private NotificationDataInfo[] getInfo(ReportSelectionDTO selectionDTO, Long messageId) {
        ArrayList<NotificationDataInfo> infoList = new ArrayList<NotificationDataInfo>();
        this.dataList = this.historyDataFacade.getNotificationData(selectionDTO, messageId, ExtendedDTOData.getFULLDATA());
        HashMap<Integer, Area> areas = new HashMap<Integer, Area>();
        for (Area area : this.areaInFacade.findAllWithPoints()) {
            areas.put(area.getAreaId(), area);
        }
        for (NotificationDTO dto : this.dataList) {
            long latitude = 0L;
            long longitude = 0L;
            if (dto.getArea() != null) {
                Area area = (Area)areas.get(dto.getArea().getAreaId());
                long[] a = this.calculateCenter(area);
                latitude = a[0];
                longitude = a[1];
            }
            if (dto.getPosition() != null) {
                latitude = dto.getPosition().getLatMSEC();
                longitude = dto.getPosition().getLongMSEC();
            }
            if (latitude == 0L && longitude == 0L || !dto.getUnitModel().getAirportmapVisible()) continue;
            GeoPoint point = new GeoPoint(latitude, longitude);
            NotificationDataInfo info = new NotificationDataInfo();
            info.id = dto.getUnitId();
            info.name = dto.getUnitName();
            info.description = null;
            info.styleUrl = dto.getUnit().getUnitTypeIdentity().getImageType().getName();
            info.point = point;
            info.messageId = dto.getMessageId();
            infoList.add(info);
        }
        Collections.sort(infoList, new Comparator<NotificationDataInfo>(){

            @Override
            public int compare(NotificationDataInfo o1, NotificationDataInfo o2) {
                if (o1 == null || o2 == null || o1.name == null || o2.name == null) {
                    return 0;
                }
                return o1.name.compareTo(o2.name);
            }
        });
        return infoList.toArray(new NotificationDataInfo[infoList.size()]);
    }

    public ReportDTOListBase<NotificationDTO> getDataList() {
        return this.dataList;
    }
}

