/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.unit;

import de.micromata.opengis.kml.v_2_2_0.Data;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.ExtendedData;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.CurrentDataInfo;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.UnitInfo;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.logic.ejb.general.kml.KmlSvgOptions;
import de.proveo.wwt.logic.ejb.general.kml.unit.UnitExport;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CurrentDataExport {
    private static final Log log = LogFactory.getLog(CurrentDataExport.class);
    private static final String DOCUMENT_NAME = "CurrentData";
    private List<StateModel> stateModels;
    private UnitContainerListBase<CurrentAllDTO> dataList;
    private HashMap<String, Style> styles = new HashMap();
    private StateModelFacadeLocal stateModelFacade;
    private CurrentDataFacadeLocal currentDataFacade;

    public CurrentDataExport() {
        try {
            InitialContext context = new InitialContext();
            this.stateModelFacade = (StateModelFacadeLocal)context.lookup("rts/StateModelFacade/local");
            this.currentDataFacade = (CurrentDataFacadeLocal)context.lookup("rts/CurrentDataFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    private void addStyle(Style style) {
        if (this.styles.get(style.getId()) == null) {
            this.styles.put(style.getId(), style);
        }
    }

    protected static Style generateStyle(UnitInfo info, KmlSvgOptions options, String contextPath) {
        IconStyle iconStyle = new IconStyle();
        iconStyle.createAndSetIcon().withHref(String.format(contextPath + "/servlet/symbols?uid=%1$d&l=%2$s&d=%3$s", info.id, options.getZoomLevel(), options.getDirected()));
        iconStyle.setScale(options.getScale());
        Style style = new Style();
        style.setIconStyle(iconStyle);
        style.setId(info.styleUrl);
        return style;
    }

    public byte[] export(ReportSelectionDTO selectionDTO, KmlSvgOptions options, String contextPath) {
        Kml kml = new Kml();
        Document doc = kml.createAndSetDocument();
        doc.setName(DOCUMENT_NAME);
        this.stateModels = this.stateModelFacade.getStateModels();
        this.styles.clear();
        for (CurrentDataInfo info : this.getInfo(selectionDTO, options)) {
            if (options != null) {
                doc.addToFeature((Feature)CurrentDataExport.generatePlacemark(info, options.getKmlStyle()));
                switch (options.getKmlStyle()) {
                    case UNIT: {
                        this.addStyle(CurrentDataExport.generateStyle((UnitInfo)info, options, contextPath));
                        break;
                    }
                    case TYPE: 
                    case STATE: {
                        this.addStyle(UnitExport.generateStyle((UnitInfo)info));
                    }
                }
                continue;
            }
            doc.addToFeature((Feature)CurrentDataExport.generatePlacemark(info, KmlSvgOptions.KmlStyle.STATE));
            this.addStyle(UnitExport.generateStyle((UnitInfo)info));
        }
        for (Style style : this.styles.values()) {
            doc.addToStyleSelector((StyleSelector)style);
        }
        if (options == null || options.getKmlStyle() == KmlSvgOptions.KmlStyle.STATE) {
            for (StateModel stateModel : this.stateModels) {
                Style style2 = new Style();
                PolyStyle ps2 = new PolyStyle();
                ps2.setColor(KmlUtil.kmlColor((Color)Color.BLACK));
                style2.setPolyStyle(ps2);
                style2.setId(String.valueOf(stateModel.getId()));
                doc.addToStyleSelector((StyleSelector)style2);
                for (State state : stateModel.getStates()) {
                    Style style = new Style();
                    PolyStyle ps = new PolyStyle();
                    String[] colorValues = state.getColor().split(",");
                    Color color = new Color(Integer.parseInt(colorValues[0]), Integer.parseInt(colorValues[1]), Integer.parseInt(colorValues[2]));
                    ps.setColor(KmlUtil.kmlColor((Color)color));
                    style.setPolyStyle(ps);
                    style.setId(String.valueOf(state.getId()));
                    doc.addToStyleSelector((StyleSelector)style);
                }
            }
        }
        return KmlUtil.serialize((Kml)kml);
    }

    private static Placemark generatePlacemark(CurrentDataInfo info, KmlSvgOptions.KmlStyle style) {
        Point point = KmlUtil.createPoint((GeoPoint)info.point);
        Placemark placemark = new Placemark();
        placemark.setId(String.valueOf(info.id));
        placemark.setName(info.name);
        placemark.setDescription(info.description);
        placemark.setGeometry((Geometry)point);
        placemark.setStyleUrl("#" + info.styleUrl);
        if (style == KmlSvgOptions.KmlStyle.STATE) {
            ExtendedData extData = new ExtendedData();
            for (Map.Entry e : info.states.entrySet()) {
                Data data = new Data("");
                data.setName(String.valueOf(e.getKey()));
                data.setValue(String.valueOf(e.getValue()));
                extData.addToData(data);
            }
            placemark.setExtendedData(extData);
        }
        return placemark;
    }

    private CurrentDataInfo[] getInfo(ReportSelectionDTO selectionDTO, KmlSvgOptions options) {
        ArrayList<CurrentDataInfo> infoList = new ArrayList<CurrentDataInfo>();
        this.dataList = this.currentDataFacade.getAllCurrentData(selectionDTO);
        for (CurrentAllDTO dto : this.dataList) {
            if (dto.getPosition() == null || dto.getStates() == null || !dto.getUnitModel().getAirportmapVisible()) continue;
            long latitude = dto.getPosition().getLatMsec();
            long longitude = dto.getPosition().getLongMsec();
            if (latitude == 0L && longitude == 0L) continue;
            GeoPoint point = new GeoPoint(latitude, longitude);
            HashMap<Integer, Integer> states = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, StateCache> e : dto.getStates().entrySet()) {
                states.put(e.getKey(), e.getValue().getStateId());
            }
            CurrentDataInfo info = new CurrentDataInfo();
            info.id = dto.getUnitId();
            info.name = dto.getUnitName();
            info.description = null;
            if (options != null) {
                info.styleUrl = options.getKmlStyle() == KmlSvgOptions.KmlStyle.UNIT ? String.valueOf(info.id) : (options.getKmlStyle() == KmlSvgOptions.KmlStyle.TYPE ? dto.getUnitTypeIdentity().getImageType().getName() : "");
            }
            info.point = point;
            info.states = states;
            infoList.add(info);
        }
        Collections.sort(infoList, new Comparator<CurrentDataInfo>(){

            @Override
            public int compare(CurrentDataInfo o1, CurrentDataInfo o2) {
                if (o1 == null || o2 == null || o1.name == null || o2.name == null) {
                    return 0;
                }
                return o1.name.compareTo(o2.name);
            }
        });
        return infoList.toArray(new CurrentDataInfo[infoList.size()]);
    }

    public UnitContainerListBase<CurrentAllDTO> getDataList() {
        return this.dataList;
    }
}

