/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.transmissionDelay;

import de.proveo.util.kml.structs.GeoArea;

public class TransmissionDelaySqlBuilder {
    private static final String TRANSMISSION_DELAY_STMT = "SELECT FLOOR((lat_msec - %d) / %d) AS lat_idx, FLOOR((long_msec - %d) / %d) AS lon_idx, COUNT(*) AS cnt, AVG(begin_receive_time - begin_time) AS delay FROM gdata_history WHERE trusted = 1 AND lat_msec >= %d AND lat_msec <= %d AND long_msec >= %d AND long_msec <= %d AND begin_time >= %d AND begin_time < %d AND begin_receive_time - begin_time >= 0 AND begin_receive_time - begin_time < %d GROUP BY FLOOR((lat_msec - %d) / %d), FLOOR((long_msec - %d) / %d) ";

    public static String buildSql(long beginTime, long endTime, long resolution, long maxDelay) {
        GeoArea geoArea = new GeoArea();
        geoArea.setWholeWorld();
        return TransmissionDelaySqlBuilder.buildSql(beginTime, endTime, resolution, maxDelay, geoArea);
    }

    public static String buildSql(long beginTime, long endTime, long resolution, long maxDelay, GeoArea geoArea) {
        String sql = String.format(TRANSMISSION_DELAY_STMT, geoArea.minLat, resolution, geoArea.minLon, resolution, geoArea.minLat, geoArea.maxLat, geoArea.minLon, geoArea.maxLon, beginTime, endTime, maxDelay, geoArea.minLat, resolution, geoArea.minLon, resolution);
        return sql;
    }
}

