/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.kml.area;

import de.proveo.util.kml.structs.GeoArea;
import de.proveo.util.kml.structs.ValueGrid;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AreaExportFastLane
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(AreaExportFastLane.class);
    private static final String AREA_RESTRICTION_STMT = "SELECT MIN(min_lat_msec), MAX(max_lat_msec), MIN(min_long_msec), MAX(max_long_msec) FROM area %s";
    private static final String AREA_ID_STMT = "SELECT MIN(min_lat_msec), MAX(max_lat_msec), MIN(min_long_msec), MAX(max_long_msec) FROM area WHERE area_id = %d";

    public static String buildAreaSql() {
        return AreaExportFastLane.buildAreaSql("");
    }

    public static String buildAreaSql(String areaRestriction) {
        return String.format(AREA_RESTRICTION_STMT, areaRestriction);
    }

    public static String buildAreaSql(int areaId) {
        return String.format(AREA_ID_STMT, areaId);
    }

    public GeoArea getCoveredArea() {
        return this.getCoveredArea("");
    }

    public GeoArea getCoveredArea(String areaRestriction) {
        GeoArea geoArea = new GeoArea();
        try {
            Connection connection = this.getConnection();
            Statement statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sql = AreaExportFastLane.buildAreaSql(areaRestriction);
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                geoArea.minLat = resultSet.getLong(1);
                geoArea.maxLat = resultSet.getLong(2);
                geoArea.minLon = resultSet.getLong(3);
                geoArea.maxLon = resultSet.getLong(4);
            }
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return geoArea;
    }

    public GeoArea getCoveredArea(int areaId) {
        GeoArea geoArea = new GeoArea();
        try {
            Connection connection = this.getConnection();
            Statement statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sql = AreaExportFastLane.buildAreaSql(areaId);
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                geoArea.minLat = resultSet.getLong(1);
                geoArea.maxLat = resultSet.getLong(2);
                geoArea.minLon = resultSet.getLong(3);
                geoArea.maxLon = resultSet.getLong(4);
            }
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return geoArea;
    }

    public static ValueGrid narrowBoundaries(ValueGrid valueGrid, long newGridSize) {
        int numLatRects = valueGrid.getNumLatRects();
        int numLonRects = valueGrid.getNumLonRects();
        long minLat = Long.MAX_VALUE;
        long maxLat = -1L;
        long minLon = Long.MAX_VALUE;
        long maxLon = -1L;
        for (int latIdx = 0; latIdx != numLatRects; ++latIdx) {
            for (int lonIdx = 0; lonIdx != numLonRects; ++lonIdx) {
                long value = valueGrid.getValue(latIdx, lonIdx);
                if (value == -1L || value == 0L) continue;
                long localMinLon = valueGrid.getMinLonForRect(lonIdx);
                long localMaxLon = valueGrid.getMaxLonForRect(lonIdx);
                long localMinLat = valueGrid.getMinLatForRect(latIdx);
                long localMaxLat = valueGrid.getMaxLatForRect(latIdx);
                if (localMinLon < minLon) {
                    minLon = localMinLon;
                }
                if (localMaxLon > maxLon) {
                    maxLon = localMaxLon;
                }
                if (localMinLat < minLat) {
                    minLat = localMinLat;
                }
                if (localMaxLat <= maxLat) continue;
                maxLat = localMaxLat;
            }
        }
        return new ValueGrid(new GeoArea(minLon, maxLon, minLat, maxLat), newGridSize);
    }
}

