/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventPayload;
import de.proveo.util.ByteUtil;
import de.proveo.util.properties.PropertiesUtil;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetupHistory;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.infoman.software.InfomanSoftware;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.infoman.CurrentInfomanSetupDAO;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeRemote;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupHistoryDAO;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSoftwareDAO;
import de.proveo.wwt.logic.ejb.general.infoman.ScheduledInfomanUpdateDAO;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="InfomanSetupFacade")
@Remote(value={InfomanSetupFacadeRemote.class})
@Local(value={InfomanSetupFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/InfomanSetupFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/InfomanSetupFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class InfomanSetupFacadeBean
implements InfomanSetupFacadeLocal,
InfomanSetupFacadeRemote {
    private static final Log log = LogFactory.getLog(InfomanSetupFacadeBean.class);
    protected static final String SERIAL_NUMBER_KEY = "sn";
    protected static final String SOFTWARE_VERSION_KEY = "sw";
    protected static final String SOFTWARE_BUILD_DATE_KEY = "swBuild";
    protected static final String SOFTWARE_REVISION_KEY = "svn";
    protected static final String HARDWARE_PLATFORM_KEY = "arch";
    protected static final String CONFIGURATION_HASHCODE_KEY = "config";
    protected static final String ACL_HASHCODE_KEY = "aclhash2";
    protected static final String CONFIGURATION_FILENAME_KEY = "configFile";
    protected static final String KERNEL_KEY = "k";
    protected static final String HARDWARE_SN_KEY = "hwSN";
    protected static final String POWERMANAGEMENT_VERSION_KEY = "pm";
    protected static final String ROOTFS_VERSION_KEY = "rootfs";
    protected static final String JAVA_VERSION_KEY = "java";
    protected static final String MODEM_FIRMWARE_VERSION = "modemFW";
    protected static final String SIMCARD_NUMBER = "simcNo";
    protected static final String IMSI = "imsi";
    protected static final String IMEI = "imei";
    protected static final String GPS_FIMRWARE = "gpsFW";
    protected static final String MODEM_TYPE = "modemT";
    protected static final String WIFI_FIRMWARE = "wifiFirm";
    protected static final String WIFI_MAC = "wifiMAC";
    protected static final String VEHICLE_ID = "vehicleId";
    @EJB
    private UnitUserLocal userUser = null;
    @EJB
    private ConfigurationLocal configuration = null;
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private Mapper mapper;
    private CurrentInfomanSetupDAO currentInfomanSetupDAO = null;
    private InfomanSetupHistoryDAO infomanSetupHistoryDAO = null;
    private InfomanSoftwareDAO infomanSoftwareDAO = null;
    private ScheduledInfomanUpdateDAO infomanUpdateDAO = null;
    protected static final String CHECKSUM_TYPE_KEY = "checksumType";
    protected static final String CHECKSUM_KEY = "checksum";
    protected static final String CONFIGURATION_KEY = "configurationName";
    protected static final String CONFIGURATION_CONTENT_TYPE = "configurationContentType";
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout = 600000L;

    @PostConstruct
    public void ejbCreate() {
        this.currentInfomanSetupDAO = CurrentInfomanSetupDAO.newInstance(this.em);
        this.infomanSetupHistoryDAO = InfomanSetupHistoryDAO.newInstance(this.em);
        this.infomanSoftwareDAO = InfomanSoftwareDAO.newInstance(this.em);
        this.infomanUpdateDAO = ScheduledInfomanUpdateDAO.newInstance(this.em);
        this.mapper = DozerBeanMapperSingletonWrapper.getInstance();
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.update.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    protected boolean addIfAvailable(StringBuilder builder, Map<String, String> infos, String key) {
        if (infos.containsKey(key)) {
            builder.append(infos.get(key));
            builder.append(";");
            return true;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public String getOldStyleBootMessage(String msg) {
        ScanmanMsgHistory msgH = new ScanmanMsgHistory();
        msgH.setMessage(msg);
        Map<String, String> infos = this.extractInfosFromBootMessage(msgH);
        if (!infos.isEmpty()) {
            StringBuilder oldMsg = new StringBuilder();
            this.addIfAvailable(oldMsg, infos, SERIAL_NUMBER_KEY);
            this.addIfAvailable(oldMsg, infos, SOFTWARE_VERSION_KEY);
            this.addIfAvailable(oldMsg, infos, SOFTWARE_BUILD_DATE_KEY);
            this.addIfAvailable(oldMsg, infos, SOFTWARE_REVISION_KEY);
            this.addIfAvailable(oldMsg, infos, HARDWARE_PLATFORM_KEY);
            this.addIfAvailable(oldMsg, infos, "msg");
            if (oldMsg.length() != 0) {
                return oldMsg.toString();
            }
        }
        return msg;
    }

    protected boolean isFieldUpdateNecessary(String field, String infomanField) {
        if (field == null) {
            return infomanField != null;
        }
        return !field.equals(infomanField);
    }

    protected String calculateChecksum(String checksumType, Set keySet) throws Exception {
        Object[] keys = keySet.toArray();
        Arrays.sort(keys);
        byte[] password = new byte[]{0};
        MessageDigest md = MessageDigest.getInstance(checksumType);
        for (int i = 0; i < keys.length; ++i) {
            md.update(((String)keys[i]).getBytes());
        }
        password = md.digest();
        return ByteUtil.toHexString((byte[])password);
    }

    @Override
    @Business(viewType="local")
    public boolean updateCache(InfomanSetup currentInfomanSetup, ScanmanMsgHistory event) {
        int index;
        currentInfomanSetup.setSyncTime(event.getCreateTime());
        Map<String, String> infos = this.extractInfosFromBootMessage(event);
        InfomanSetup value = currentInfomanSetup;
        boolean changed = false;
        if (this.isFieldUpdateNecessary(value.getKernelVersion(), infos.get(KERNEL_KEY))) {
            value.setKernelVersion(infos.get(KERNEL_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getPowerManagementVersion(), infos.get(POWERMANAGEMENT_VERSION_KEY))) {
            value.setPowerManagementVersion(infos.get(POWERMANAGEMENT_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getSoftwareVersion(), infos.get(SOFTWARE_VERSION_KEY))) {
            value.setSoftwareVersion(infos.get(SOFTWARE_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getSoftwareRevision(), infos.get(SOFTWARE_REVISION_KEY))) {
            value.setSoftwareRevision(infos.get(SOFTWARE_REVISION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getRootfsVersion(), infos.get(ROOTFS_VERSION_KEY))) {
            value.setRootfsVersion(infos.get(ROOTFS_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getJavaVmVersion(), infos.get(JAVA_VERSION_KEY))) {
            value.setJavaVmVersion(infos.get(JAVA_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getInfomanSn(), infos.get(SERIAL_NUMBER_KEY))) {
            value.setInfomanSn(infos.get(SERIAL_NUMBER_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getDeviceType(), infos.get("deviceType"))) {
            value.setDeviceType(infos.get("deviceType"));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getHardware(), infos.get(HARDWARE_PLATFORM_KEY))) {
            value.setHardware(infos.get(HARDWARE_PLATFORM_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getHardwareSn(), infos.get(HARDWARE_SN_KEY))) {
            value.setHardwareSn(infos.get(HARDWARE_SN_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getConfigurationName(), infos.get(CONFIGURATION_FILENAME_KEY))) {
            value.setConfigurationName(infos.get(CONFIGURATION_FILENAME_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getModemFirmwareVersion(), infos.get(MODEM_FIRMWARE_VERSION))) {
            value.setModemFirmwareVersion(infos.get(MODEM_FIRMWARE_VERSION));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getSimCardNo(), infos.get(SIMCARD_NUMBER))) {
            value.setSimCardNo(infos.get(SIMCARD_NUMBER));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getImsi(), infos.get(IMSI))) {
            value.setImsi(infos.get(IMSI));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getImei(), infos.get(IMEI))) {
            value.setImei(infos.get(IMEI));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getGpsFirmware(), infos.get(GPS_FIMRWARE))) {
            value.setGpsFimrware(infos.get(GPS_FIMRWARE));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getModemType(), infos.get(MODEM_TYPE))) {
            value.setModemType(infos.get(MODEM_TYPE));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getWifiFirmware(), infos.get(WIFI_FIRMWARE))) {
            value.setWifiFirmware(infos.get(WIFI_FIRMWARE));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getWifiMac(), infos.get(WIFI_MAC))) {
            value.setWifiMac(infos.get(WIFI_MAC));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getSoftwareRevision(), infos.get(SOFTWARE_REVISION_KEY))) {
            value.setSoftwareRevision(infos.get(SOFTWARE_REVISION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getVehicleId(), infos.get(VEHICLE_ID))) {
            value.setVehicleId(infos.get(VEHICLE_ID));
            changed = true;
        }
        boolean bootEventACLChecksumHandling = Boolean.parseBoolean(this.configuration.getParameter("infoman.boot.aclContenChecksumHandling", Boolean.TRUE.toString()));
        String eventACLChecksumKey = infos.get(ACL_HASHCODE_KEY);
        if (bootEventACLChecksumHandling && eventACLChecksumKey != null) {
            String eventACLChecksumType = "SHA-1";
            String serverACLChecksumKey = null;
            index = eventACLChecksumKey.indexOf(":");
            if (index < 0) {
                if (log.isErrorEnabled()) {
                    log.warn((Object)("updateCache() wrong ACL checksum format. " + ((Object)event).toString()));
                }
            } else {
                eventACLChecksumType = eventACLChecksumKey.substring(0, index);
                eventACLChecksumKey = eventACLChecksumKey.substring(index + 1);
                Set<Object> keys = new HashSet();
                try {
                    keys = this.userUser.getUserKeys(event.getUnitId(), false);
                }
                catch (UnitNotFoundException ex) {
                    log.error((Object)(" no unit found for unitId = " + event.getUnitId()));
                }
                if ("SHA1".equalsIgnoreCase(eventACLChecksumType)) {
                    eventACLChecksumType = "SHA-1";
                } else if ("MD5".equalsIgnoreCase(eventACLChecksumType)) {
                    eventACLChecksumType = "MD5";
                }
                try {
                    serverACLChecksumKey = this.calculateChecksum(eventACLChecksumType, keys);
                }
                catch (Exception ex) {
                    log.error((Object)"updateCache() runs into", (Throwable)ex);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("check ACL update is necessary for UnitId " + event.getUnitId() + " ChecksumType: " + eventACLChecksumType + " ACLServerHash:" + serverACLChecksumKey + " Infoman ACL Hash:" + eventACLChecksumKey));
                }
                if (serverACLChecksumKey != null && this.isFieldUpdateNecessary(eventACLChecksumKey, serverACLChecksumKey)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ACL update for UnitId " + event.getUnitId() + " is necessary - " + "Server ACL " + eventACLChecksumType + " Hash:" + serverACLChecksumKey + " differs to " + "Infoman ACL Hash:" + eventACLChecksumKey));
                    }
                    try {
                        this.userUser.updateUnitModel(event.getUnitId(), true);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("ACL update Flag for UnitId " + event.getUnitId() + " is set"));
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"updateCache() runs into", (Throwable)ex);
                    }
                }
            }
        }
        String oldConfigurationChecksum = currentInfomanSetup.getConfigurationChecksum();
        String newConfigurationChecksum = infos.get(CONFIGURATION_HASHCODE_KEY);
        if (newConfigurationChecksum == null) {
            log.debug((Object)"updateCache() missing configuration checksum");
        } else {
            index = newConfigurationChecksum.indexOf(":");
            if (index < 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("updateCache() wrong checksum format. " + ((Object)event).toString()));
                }
            } else {
                String newConfigurationChecksumType = newConfigurationChecksum.substring(0, index);
                newConfigurationChecksum = newConfigurationChecksum.substring(index + 1);
                if (value.getConfigurationUpToDate() && (this.isFieldUpdateNecessary(newConfigurationChecksum, oldConfigurationChecksum) || this.isFieldUpdateNecessary(currentInfomanSetup.getConfigurationChecksumType(), newConfigurationChecksumType))) {
                    value.setConfigurationChecksumType(newConfigurationChecksumType);
                    value.setConfigurationChecksum(newConfigurationChecksum);
                    value.setConfigurationUpToDate(true);
                    List<InfomanUpdate> updates = this.infomanUpdateDAO.findUpdateByConfigurationChecksum(value.getUnitId(), newConfigurationChecksumType, newConfigurationChecksum);
                    if (updates.size() == 0) {
                        value.setConfigurationUpToDate(false);
                    } else {
                        value.setConfiguration(updates.get(0).getConfiguration());
                    }
                    changed = true;
                }
            }
        }
        if (changed) {
            this.currentInfomanSetupDAO.updateEntity(currentInfomanSetup);
        }
        return changed;
    }

    @Override
    @Business(viewType="local")
    public void writeHistory(InfomanSetup currentInfomanSetup) {
        InfomanSetup value = currentInfomanSetup;
        InfomanSetupHistory historyValue = new InfomanSetupHistory();
        historyValue.setUnitId(value.getUnitId());
        historyValue.setCreateTime(value.getSyncTime());
        historyValue.setConfigurationChecksumType(value.getConfigurationChecksumType());
        historyValue.setConfigurationChecksum(value.getConfigurationChecksum());
        historyValue.setConfigurationName(value.getConfigurationName());
        historyValue.setConfiguration(value.getConfiguration());
        historyValue.setConfigurationContentType(value.getConfigurationContentType());
        historyValue.setSoftwareVersion(value.getSoftwareVersion());
        historyValue.setSoftwareRevision(value.getSoftwareRevision());
        historyValue.setKernelVersion(value.getKernelVersion());
        historyValue.setPowerManagementVersion(value.getPowerManagementVersion());
        historyValue.setRootfsVersion(value.getRootfsVersion());
        historyValue.setJavaVmVersion(value.getJavaVmVersion());
        historyValue.setInfomanSn(value.getInfomanSn());
        historyValue.setHardware(value.getHardware());
        historyValue.setHardwareSn(value.getHardwareSn());
        historyValue.setModemFirmwareVersion(value.getModemFirmwareVersion());
        historyValue.setSimCardNo(value.getSimCardNo());
        historyValue.setImsi(value.getImsi());
        historyValue.setImei(value.getImei());
        historyValue.setGpsFirmware(value.getGpsFirmware());
        historyValue.setModemType(value.getModemType());
        historyValue.setWifiFirmware(value.getWifiFirmware());
        historyValue.setWifiMac(value.getWifiMac());
        historyValue.setVehicleId(value.getVehicleId());
        this.infomanSetupHistoryDAO.createEntity(historyValue);
        currentInfomanSetup.setHistoryPk(historyValue.getId());
    }

    @Override
    @Business(viewType="both")
    public void infomanBoot(ScanmanMsgHistory event) {
        boolean changed;
        if (event.getType() != 25) {
            log.warn((Object)"we extract our information only out of boot events");
            return;
        }
        if (!event.getMessage().contains("=")) {
            log.warn((Object)"incompatible infoman boot message");
            return;
        }
        InfomanSetup currentInfomanSetup = (InfomanSetup)this.currentInfomanSetupDAO.findByPrimaryKey(event.getUnitId());
        if (currentInfomanSetup == null) {
            currentInfomanSetup = new InfomanSetup();
            currentInfomanSetup.setUnitId(event.getUnitId());
            currentInfomanSetup.setUnitModel(new UnitModel(event.getUnitId()));
            this.currentInfomanSetupDAO.createEntity(currentInfomanSetup);
        }
        if (changed = this.updateCache(currentInfomanSetup, event)) {
            this.writeHistory(currentInfomanSetup);
        }
    }

    @Override
    @Business(viewType="both")
    public void updateConfiguration(ScanmanMsgHistory event) {
        if (event.isBinaryPayloadEmpty()) {
            throw new EJBException("binary payload is empty");
        }
        InfomanSetup infomanSetup = (InfomanSetup)this.currentInfomanSetupDAO.findByPrimaryKey(event.getUnitId());
        if (infomanSetup == null) {
            infomanSetup = new InfomanSetup();
            infomanSetup.setUnitId(event.getUnitId());
            infomanSetup.setUnitModel(new UnitModel(event.getUnitId()));
            this.currentInfomanSetupDAO.createEntity(infomanSetup);
        }
        Map<String, String> messagesInfos = this.extractInfosConfigurationMessage(event.getMessage());
        try {
            MessageDigest md = MessageDigest.getInstance(messagesInfos.get(CHECKSUM_TYPE_KEY));
            String calculatedChecksum = ByteUtil.toHexString((byte[])md.digest(event.getBinaryPayload()));
            if (!calculatedChecksum.equals(messagesInfos.get(CHECKSUM_KEY))) {
                throw new EJBException("checksum of received event is invalid. calculatedChecksum: " + calculatedChecksum);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EJBException("unkown checksum algorithm in event", (Exception)ex);
        }
        infomanSetup.setConfigurationChecksumType(messagesInfos.get(CHECKSUM_TYPE_KEY));
        infomanSetup.setConfigurationChecksum(messagesInfos.get(CHECKSUM_KEY));
        infomanSetup.setConfiguration(event.getBinaryPayload());
        infomanSetup.setConfigurationName(messagesInfos.get(CONFIGURATION_KEY));
        infomanSetup.setConfigurationContentType(messagesInfos.get(CONFIGURATION_CONTENT_TYPE));
        infomanSetup.setConfigurationUpToDate(true);
    }

    public Map<String, String> extractInfosConfigurationMessage(String msg) {
        HashMap<String, String> infos = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(msg, ";");
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (index == 0) {
                int separatorIndex = token.indexOf(":");
                if (separatorIndex > -1) {
                    String type = token.substring(0, separatorIndex);
                    String value = token.substring(separatorIndex + 1);
                    infos.put(CHECKSUM_TYPE_KEY, type);
                    infos.put(CHECKSUM_KEY, value);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("unexpected configuration message format: " + msg));
                }
            } else if (index == 1) {
                infos.put(CONFIGURATION_KEY, token);
            } else if (index == 2) {
                infos.put(CONFIGURATION_CONTENT_TYPE, token);
            }
            ++index;
        }
        return infos;
    }

    @Override
    @Business(viewType="local")
    public Map<String, String> extractInfosFromBootMessage(ScanmanMsgHistory event) {
        HashMap<String, String> infos = new HashMap<String, String>();
        String msg = event.getMessage();
        StringTokenizer tokenizer = new StringTokenizer(msg, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf("=");
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            infos.put(key, value);
        }
        if (event.getBinaryPayload() != null) {
            byte[] payload = event.getBinaryPayload();
            Properties probs = new Properties();
            ByteArrayInputStream bis = new ByteArrayInputStream(payload);
            try {
                probs.load(bis);
            }
            catch (IOException ex) {
                log.error((Object)"runs into", (Throwable)ex);
            }
            for (Map.Entry<Object, Object> ent : probs.entrySet()) {
                infos.put((String)ent.getKey(), (String)ent.getValue());
            }
        }
        return infos;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Business(viewType="both")
    public void updateReport(long eventTime, String updateReport) {
        errorMessage = null;
        if (updateReport.startsWith("error")) {
            succesful = false;
            tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            try {
                updateId = Long.parseLong(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) ** GOTO lbl23
                errorMessage = tokenizer.nextToken();
            }
            catch (Exception ex) {
                InfomanSetupFacadeBean.log.error((Object)"runs during parse update report into", (Throwable)ex);
                throw new EJBException(ex);
            }
        } else {
            index = updateReport.indexOf(";");
            try {
                updateId = index < 0 ? Long.parseLong(updateReport) : Long.parseLong(updateReport.substring(0, index));
                succesful = true;
            }
            catch (NumberFormatException ex) {
                InfomanSetupFacadeBean.log.error((Object)"runs during parse update report into", (Throwable)ex);
                throw new EJBException((Exception)ex);
            }
        }
lbl23:
        // 3 sources

        infomanUpdate = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(updateId);
        if (infomanUpdate == null) {
            InfomanSetupFacadeBean.log.error((Object)("reported update not found. " + updateReport));
            return;
        }
        infomanUpdate.setDone(true);
        infomanUpdate.setSuccessfully(succesful);
        if (!succesful) {
            infomanUpdate.setErrorMessage(errorMessage);
        }
        infomanUpdate.setFinishedTime(eventTime);
        this.em.flush();
    }

    @Override
    @Business(viewType="both")
    public EventPayload getUpdatePayload(long unitId) {
        List<InfomanUpdate> updates = this.infomanUpdateDAO.findActiveUpdates(unitId, System.currentTimeMillis());
        if (updates.size() == 0) {
            return null;
        }
        return this.buildUpdatePayload((InfomanUpdate)((Object)updates.iterator().next()));
    }

    @Override
    @Business(viewType="local")
    public EventPayload getRequestConfigurationPayload(UnitModel unitModel) {
        boolean requestConfiguration = Boolean.parseBoolean(this.configuration.getParameter("infoman.update.requestConfiguration", Boolean.TRUE.toString()));
        if (!requestConfiguration) {
            log.trace((Object)"getRequestConfigurationPayload() Payload deactivated by default-application.properties");
            return null;
        }
        if (unitModel != null && unitModel.getInfomanSetup() != null && !unitModel.getInfomanSetup().getConfigurationUpToDate()) {
            InfomanSetup infomanSetup = unitModel.getInfomanSetup();
            long delta = System.currentTimeMillis() - infomanSetup.getRequestConfigTime();
            if (delta < this.infomanRequestTimeout) {
                log.trace((Object)"getRequestConfigurationPayload() still active request");
                return null;
            }
            EventPayload payload = new EventPayload();
            payload.setName("InfomanSetup");
            Properties properties = new Properties();
            properties.setProperty("action", "send configuration");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                PropertiesUtil.storeWithoutComments((Properties)properties, (OutputStream)out);
                payload.setPayload(out.toByteArray());
                infomanSetup.setRequestConfigTime(System.currentTimeMillis());
            }
            catch (IOException ex) {
                log.error((Object)"cannot write infomanSet payload", (Throwable)ex);
                return null;
            }
            return payload;
        }
        if (unitModel != null && unitModel.getInfomanSetup() == null) {
            log.trace((Object)"getRequestConfigurationPayload() no setup record found");
        } else if (unitModel != null && unitModel.getInfomanSetup() != null && unitModel.getInfomanSetup().getConfigurationUpToDate()) {
            log.trace((Object)"getRequestConfigurationPayload() setup is up to date");
        } else {
            log.trace((Object)"getRequestConfigurationPayload() other reason");
        }
        return null;
    }

    @Override
    @Business(viewType="local")
    public EventPayload buildUpdatePayload(InfomanUpdate update) {
        long delta = System.currentTimeMillis() - update.getStartTime();
        if (delta < this.infomanRequestTimeout) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("action", "update");
        properties.setProperty("id", Long.toString(update.getUpdateId()));
        if (update.getConfigurationName() != null && !update.getConfigurationName().equals("")) {
            properties.setProperty("configurationChecksumType", update.getConfigurationChecksumType());
            properties.setProperty("configurationChecksum", update.getConfigurationChecksum());
            properties.setProperty(CONFIGURATION_KEY, update.getConfigurationName());
            properties.setProperty(CONFIGURATION_CONTENT_TYPE, update.getConfigurationContentType());
        }
        if (update.getInfomanSoftware() != null) {
            properties.setProperty("softwareChecksumType", update.getInfomanSoftware().getChecksumType());
            properties.setProperty("softwareChecksum", update.getInfomanSoftware().getChecksum());
            properties.setProperty("softwareName", update.getInfomanSoftware().getVersionName());
            properties.setProperty("softwareContentType", update.getInfomanSoftware().getSoftwareContentType());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PropertiesUtil.storeWithoutComments((Properties)properties, (OutputStream)out);
        }
        catch (IOException ex) {
            log.error((Object)"runs during build update properties into", (Throwable)ex);
            return null;
        }
        EventPayload payload = new EventPayload();
        payload.setName("InfomanSetup");
        payload.setPayload(out.toByteArray());
        update.setStartTime(System.currentTimeMillis());
        return payload;
    }

    protected void resetInfomanUpdate(InfomanUpdate update) {
        update.setDone(false);
        update.setStartTime(0L);
    }

    @Override
    @Business(viewType="both")
    public void resetInfomanUpdate(long infomanUpdateId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(infomanUpdateId);
        this.resetInfomanUpdate(update);
    }

    @Override
    @Business(viewType="both")
    public byte[] getUpdateResource(Properties event) throws ObjectNotFoundException {
        InfomanUpdate scheduledUpdate = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(Long.parseLong(event.getProperty("id")));
        if (scheduledUpdate == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("requested update not found: " + event));
            }
            throw new ObjectNotFoundException("requested update not found:");
        }
        if (scheduledUpdate.getDone()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("requested update is canceled: " + event));
            }
            return null;
        }
        byte[] resource = null;
        String resourceType = event.getProperty("type", "none");
        if (resourceType.equals(CONFIGURATION_HASHCODE_KEY)) {
            resource = scheduledUpdate.getConfiguration();
        } else if (resourceType.equals("software") && scheduledUpdate.getInfomanSoftware() != null) {
            resource = scheduledUpdate.getInfomanSoftware().getSoftware();
        } else if (log.isErrorEnabled()) {
            log.error((Object)("unkown update resource type: " + event));
        }
        return resource;
    }

    @Override
    @Business(viewType="both")
    public List<InfomanSetup> getAllCurrentInfomanSetups() {
        return this.currentInfomanSetupDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public InfomanSetup getCurrentInfomanSetup(long unitId) throws ObjectNotFoundException {
        return unitId == -1L ? null : (InfomanSetup)this.currentInfomanSetupDAO.findByPrimaryKey(unitId);
    }

    @Override
    @Business(viewType="both")
    public void resetUpToDateFlag(long id) {
        InfomanSetup infomanSetup = (InfomanSetup)this.currentInfomanSetupDAO.findByPrimaryKey(id);
        infomanSetup.setConfigurationUpToDate(false);
        this.em.merge((Object)infomanSetup);
    }

    @Override
    @Business(viewType="both")
    public List<InfomanSoftwareDescriptionValue> getAvailableInfomanSoftwareValues() {
        ArrayList<InfomanSoftwareDescriptionValue> softwareDescriptions = new ArrayList<InfomanSoftwareDescriptionValue>();
        List<Object[]> list = this.infomanSoftwareDAO.findAllWithoutDataBlob();
        for (Object[] obj : list) {
            InfomanSoftwareDescriptionValue description = new InfomanSoftwareDescriptionValue((Long)obj[0], (String)obj[1], (String)obj[2], (String)obj[3], (String)obj[4], (String)obj[5], (String)obj[6]);
            softwareDescriptions.add(description);
        }
        return softwareDescriptions;
    }

    @Override
    @Business(viewType="both")
    public void deleteInfomanSoftware(long softwareId) throws ObjectNotFoundException, RemoveException {
        InfomanSoftware infomanSoftware = (InfomanSoftware)this.infomanSoftwareDAO.findByPrimaryKey(softwareId);
        if (!infomanSoftware.getInfomanUpdates().isEmpty()) {
            throw new RemoveException("still updates there");
        }
        this.infomanSoftwareDAO.removeEntity(infomanSoftware);
    }

    @Override
    @Business(viewType="both")
    public List<InfomanSetupHistory> getConfigurationHistory(long unitId, long since, long until) throws FinderException {
        ArrayList<InfomanSetupHistory> versions = new ArrayList<InfomanSetupHistory>();
        for (InfomanSetupHistory history : this.infomanSetupHistoryDAO.findByUnit(unitId, since, until)) {
            versions.add(history);
        }
        return versions;
    }

    @Override
    @Business(viewType="both")
    public void removeInfomanSetupHistoryEntity(InfomanSetupHistory entity) {
        this.infomanSetupHistoryDAO.removeEntity(entity);
    }

    @Override
    @Business(viewType="both")
    public void removeCurrentInfomanSetupEntity(InfomanSetup entity) {
        this.currentInfomanSetupDAO.removeEntity(entity);
    }

    @Override
    @Business(viewType="both")
    public List<InfomanSetupHistory> findInfomanHistoryByUnitId(long unitId) {
        return this.infomanSetupHistoryDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public void removeInfomanSetupHistoryEntities(long unitId) {
        List<InfomanSetupHistory> coll = this.findInfomanHistoryByUnitId(unitId);
        for (InfomanSetupHistory entity : coll) {
            if (entity == null) continue;
            this.removeInfomanSetupHistoryEntity(entity);
        }
    }
}

