/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.infoman.software.InfomanSoftware;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeRemote;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSoftwareDAO;
import de.proveo.wwt.logic.ejb.general.infoman.ScheduledInfomanUpdateDAO;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.DozerBeanMapperSingletonWrapper;
import org.dozer.Mapper;

@Stateless(name="InfomanConfigurationClientFacade")
@Remote(value={InfomanConfigurationClientFacadeRemote.class})
@Local(value={InfomanConfigurationClientFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/InfomanConfigurationClientFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/InfomanConfigurationClientFacade")
public class InfomanConfigurationClientFacadeBean
implements InfomanConfigurationClientFacadeLocal,
InfomanConfigurationClientFacadeRemote {
    private static final Log log = LogFactory.getLog(InfomanConfigurationClientFacadeBean.class);
    @EJB
    private InfomanSetupFacadeLocal infomanSetupFacade = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @PersistenceContext(unitName="rts")
    EntityManager entityManager = null;
    private ScheduledInfomanUpdateDAO infomanUpdateDAO = null;
    private InfomanSoftwareDAO infomanSoftwareDAO = null;
    private Mapper mapper;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private UserAdminFacadeLocal userAdminFacadeLocal;

    @PostConstruct
    public void ejbCreate() {
        this.infomanUpdateDAO = ScheduledInfomanUpdateDAO.newInstance(this.entityManager);
        this.infomanSoftwareDAO = InfomanSoftwareDAO.newInstance(this.entityManager);
        this.mapper = DozerBeanMapperSingletonWrapper.getInstance();
    }

    @Override
    @Business(viewType="both")
    public InfomanSetup getCurrentInfomanSetup(long unitId) throws ObjectNotFoundException, SecurityException {
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        InfomanSetup setupValue = null;
        setupValue = this.infomanSetupFacade.getCurrentInfomanSetup(unitId);
        return setupValue;
    }

    @Override
    @Business(viewType="both")
    public CurrentInfomanSetupValue getCurrentInfomanSetupValue(long unitId) throws ObjectNotFoundException, SecurityException {
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        InfomanSetup setup = null;
        setup = this.infomanSetupFacade.getCurrentInfomanSetup(unitId);
        if (setup == null) {
            throw new ObjectNotFoundException();
        }
        CurrentInfomanSetupValue setupValue = (CurrentInfomanSetupValue)this.mapper.map((Object)setup, CurrentInfomanSetupValue.class);
        return setupValue;
    }

    @Override
    @Business(viewType="both")
    public void setInfomanSoftwareForPlanedUpdate(long planedUpdateId, long infomanSoftwareId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(planedUpdateId);
        update.setInfomanSoftwareId(infomanSoftwareId);
        this.updateAccount(update);
    }

    @Override
    @Business(viewType="both")
    public InfomanSoftware getInfomanSoftwareForPlanedUpdate(long planedUpdateId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(planedUpdateId);
        InfomanSoftware software = update.getInfomanSoftware();
        if (software != null) {
            return software;
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public InfomanSoftwareDescriptionValue getInfomanSoftwareForPlanedUpdateValue(long planedUpdateId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(planedUpdateId);
        InfomanSoftware software = update.getInfomanSoftware();
        InfomanSoftwareDescriptionValue softwareDescriptionValue = null;
        if (software != null) {
            softwareDescriptionValue = (InfomanSoftwareDescriptionValue)this.mapper.map((Object)software, InfomanSoftwareDescriptionValue.class);
        }
        return softwareDescriptionValue;
    }

    @Override
    @Business(viewType="both")
    public void removeInfomanSoftwareFromPlanedUpdate(long planedUpdateId) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(planedUpdateId);
        update.setInfomanSoftwareId(null);
        this.updateAccount(update);
    }

    @Override
    @Business(viewType="both")
    public InfomanUpdate createPlanedInfomanUpdate(long unitId, InfomanUpdate updateValue) throws CreateException, ObjectNotFoundException, SecurityException {
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        this.infomanUpdateDAO.createEntity(updateValue);
        updateValue.setUnitId(unitId);
        return updateValue;
    }

    protected void updateAccount(InfomanUpdate update) {
        String accountName = this.sessionContext.getCallerPrincipal().getName();
        Account account = this.userAdminFacadeLocal.getAccountByUsername(accountName);
        update.setAccountId(account != null ? Long.valueOf(account.getId()) : null);
    }

    @Override
    @Business(viewType="both")
    public ScheduledInfomanUpdateValue createPlanedInfomanUpdateValue(long unitId, ScheduledInfomanUpdateValue updateValue) throws CreateException, ObjectNotFoundException, SecurityException {
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        if (updateValue != null) {
            InfomanUpdate update = (InfomanUpdate)((Object)this.mapper.map((Object)updateValue, InfomanUpdate.class));
            update.setUnitId(unitId);
            this.updateAccount(update);
            this.infomanUpdateDAO.createEntity(update);
            if (update == null) {
                throw new ObjectNotFoundException();
            }
            updateValue = (ScheduledInfomanUpdateValue)this.mapper.map((Object)update, ScheduledInfomanUpdateValue.class);
        }
        return updateValue;
    }

    @Override
    @Business(viewType="both")
    public Collection<InfomanUpdate> getPlannedInfomanRemoteUpdates(long unitId) throws ObjectNotFoundException, SecurityException {
        this.unitFacade.getUnitDTO(unitId);
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        List<InfomanUpdate> coll = null;
        coll = this.infomanUpdateDAO.findPlanedUpdates(unitId);
        ArrayList<InfomanUpdate> ret = new ArrayList<InfomanUpdate>();
        for (InfomanUpdate siuv : coll) {
            ret.add(siuv);
        }
        return ret;
    }

    @Override
    @Business(viewType="both")
    public Collection<ScheduledInfomanUpdateValue> getPlannedInfomanRemoteUpdateValues(long unitId) throws ObjectNotFoundException, SecurityException {
        this.unitFacade.getUnitDTO(unitId);
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        List<InfomanUpdate> coll = null;
        coll = this.infomanUpdateDAO.findPlanedUpdates(unitId);
        ArrayList<ScheduledInfomanUpdateValue> ret = new ArrayList<ScheduledInfomanUpdateValue>();
        for (InfomanUpdate siuv : coll) {
            if (siuv == null) continue;
            ScheduledInfomanUpdateValue updateValue = (ScheduledInfomanUpdateValue)this.mapper.map((Object)siuv, ScheduledInfomanUpdateValue.class);
            ret.add(updateValue);
        }
        return ret;
    }

    @Override
    @Business(viewType="both")
    public void addConfigurationToInfomanRemoteUpdate(long updateId, long unitId, byte[] oldConfiguration, byte[] newConfiguration) throws ObjectNotFoundException, SecurityException {
        this.unitFacade.getUnitDTO(unitId);
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        log.debug((Object)("addConfigurationToInfomanRemoteUpdate(" + updateId + "," + unitId + "," + oldConfiguration + "," + newConfiguration + ") called. Not yet implemented. Do nothing!"));
    }

    @Override
    @Business(viewType="both")
    public long beginInfomanUpdate(long unitId, byte[] oldConfiguration, byte[] newConfiguration) throws ObjectNotFoundException, SecurityException {
        this.unitFacade.getUnitDTO(unitId);
        if (!this.unitFacade.hasUserAccessForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        log.debug((Object)("beginInfomanUpdate(" + unitId + "," + oldConfiguration + "," + newConfiguration + ") called. Not yet implemented. Returning 0!"));
        return 0L;
    }

    @Override
    @Business(viewType="both")
    public void infomanUpdateDone(boolean successful, long updateId) throws ObjectNotFoundException {
        log.debug((Object)("infomanUpdateDone(" + successful + "," + updateId + ") called. Not yet implemented. Do nothing!"));
    }

    @Override
    @Business(viewType="both")
    public void updateScheduledInfomanUpdate(InfomanUpdate value) throws ObjectNotFoundException {
        InfomanUpdate update = (InfomanUpdate)this.infomanUpdateDAO.findByPrimaryKey(value.getUpdateId());
        this.infomanUpdateDAO.updateEntity(update);
    }

    @Override
    @Business(viewType="both")
    public void createInfomanSoftware(InfomanSoftware infomanSoftware) {
        this.infomanSoftwareDAO.createEntity(infomanSoftware);
    }

    @Override
    @Business(viewType="both")
    public void removeInfomanSoftware(InfomanSoftware software) {
        this.infomanSoftwareDAO.removeEntity(software);
    }

    @Override
    @Business(viewType="both")
    public InfomanSoftware getInfomanSoftwareById(long softwareId) {
        return (InfomanSoftware)this.infomanSoftwareDAO.findByPrimaryKey(softwareId);
    }
}

