/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.image;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.image.ImageType;
import de.proveo.wwt.logic.ejb.general.image.ImageTypeDAO;
import de.proveo.wwt.logic.ejb.general.image.ImageTypeFacadeLocal;
import de.proveo.wwt.logic.ejb.general.image.ImageTypeFacadeRemote;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

@Stateless(name="ImageTypeFacade")
@Remote(value={ImageTypeFacadeRemote.class})
@Local(value={ImageTypeFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ImageTypeFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ImageTypeFacade")
public class ImageTypeFacadeBean {
    private static final Log log = LogFactory.getLog(ImageTypeFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private ImageTypeDAO imageTypeDAO;

    @PostConstruct
    private void initialize() {
        this.imageTypeDAO = ImageTypeDAO.newInstance(this.entityManager);
    }

    @Business(viewType="both")
    public List<ImageType> getImageTypes() {
        return this.imageTypeDAO.findAll();
    }

    @Business(viewType="both")
    public List<ImageType> getImageTypesByName() {
        return this.imageTypeDAO.findByName();
    }

    @Business(viewType="both")
    public List<ImageType> getImageTypesIncludingMappings() {
        List<ImageType> imageTypes = this.getImageTypes();
        for (ImageType imageType : imageTypes) {
            Hibernate.initialize(imageType.getImageLayerMappings());
        }
        return imageTypes;
    }
}

