/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.fileStorage;

import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.file.FileBase;
import de.proveo.wwt.datamodel.file.FileDirectory;
import de.proveo.wwt.datamodel.file.FileStorage;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileDirectoryDAO;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageDAO;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageFacadeLocal;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageFacadeRemote;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileTreeNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="FileStorageFacade")
@Remote(value={FileStorageFacadeRemote.class})
@Local(value={FileStorageFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/FileStorageFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/FileStorageFacade")
public class FileStorageFacadeBean
implements FileStorageFacadeLocal,
FileStorageFacadeRemote {
    private static final Log log = LogFactory.getLog(FileStorageFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private FileStorageDAO fileStorageDAO = null;
    private FileDirectoryDAO fileDirectoryDAO = null;
    @Resource
    SessionContext sessionContext;
    @EJB
    private UserAdminFacadeLocal userAdminFacadeLocal;

    @PostConstruct
    private void initialize() {
        this.fileStorageDAO = FileStorageDAO.newInstance(this.entityManager);
        this.fileDirectoryDAO = FileDirectoryDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<FileStorage> getFiles(int moduleId) {
        List<Object[]> list = this.fileStorageDAO.findModuleIdWithoutDataBlob(moduleId);
        ArrayList<FileStorage> fsList = new ArrayList<FileStorage>();
        for (Object[] obj : list) {
            FileStorage fs = new FileStorage();
            fs.setId((Integer)obj[0]);
            fs.setFilename((String)obj[1]);
            fs.setName((String)obj[2]);
            fs.setDescription((String)obj[3]);
            fs.setContentType((String)obj[4]);
            fs.setSize((Integer)obj[5]);
            fs.setCreateTime((Long)obj[6]);
            fsList.add(fs);
        }
        return fsList;
    }

    @Override
    @Business(viewType="both")
    public void createFile(FileStorage fileStorage, GZIPRemoteInputStream remoteInputStream) {
        try {
            this.createFile(fileStorage, RemoteInputStreamClient.wrap((RemoteInputStream)remoteInputStream));
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    @Override
    @Business(viewType="local")
    public void createFile(FileStorage fileStorage, InputStream inputStream) {
        fileStorage.setStream(inputStream);
        fileStorage.setUserId(this.getUserId());
        this.fileStorageDAO.createEntity(fileStorage);
    }

    @Override
    @Business(viewType="both")
    public FileStorage updateFile(FileStorage fileStorage) {
        if (!this.entityManager.contains((Object)fileStorage)) {
            fileStorage = (FileStorage)this.fileStorageDAO.updateEntity(fileStorage);
        }
        return fileStorage;
    }

    @Override
    @Business(viewType="both")
    public void deleteFile(int fileStorageId) {
        this.fileStorageDAO.removeEntity(this.fileStorageDAO.findByPrimaryKey(fileStorageId));
    }

    @Override
    @Business(viewType="both")
    public byte[] getFileContent(int fileId) {
        FileStorage file = (FileStorage)this.fileStorageDAO.findByPrimaryKey(fileId);
        return file.getData();
    }

    @Override
    @Business(viewType="local")
    public InputStream getFileContentLocal(int fileId) {
        FileStorage file = (FileStorage)this.fileStorageDAO.findByPrimaryKey(fileId);
        return file.getStream();
    }

    @Override
    @Business(viewType="both")
    public void createDirectory(FileDirectory directory) {
        directory.setUserId(this.getUserId());
        this.fileDirectoryDAO.createEntity(directory);
    }

    @Override
    @Business(viewType="both")
    public FileDirectory updateDirectory(FileDirectory directory) {
        if (!this.entityManager.contains((Object)directory)) {
            directory = (FileDirectory)this.fileDirectoryDAO.updateEntity(directory);
        }
        return directory;
    }

    @Override
    @Business(viewType="both")
    public void removeDirectory(int directoryId) {
        this.fileDirectoryDAO.removeEntity(this.fileDirectoryDAO.findByPrimaryKey(directoryId));
    }

    @Override
    @Business(viewType="both")
    public List<FileDirectory> getDirectoriesInDirectory(Integer directoryId) {
        return this.fileDirectoryDAO.findByParentId(directoryId);
    }

    @Override
    @Business(viewType="both")
    public List<FileStorage> getFilesInDirectory(Integer directoryId) {
        return this.fileStorageDAO.findByParentId(directoryId);
    }

    @Override
    @Business(viewType="both")
    public List<FileBase> getDirectoryContent(Integer directoryId) {
        List<FileDirectory> directories = this.getDirectoriesInDirectory(directoryId);
        List<FileStorage> files = this.getFilesInDirectory(directoryId);
        ArrayList<FileBase> content = new ArrayList<FileBase>(directories.size() + files.size());
        content.addAll(directories);
        content.addAll(files);
        return content;
    }

    @Override
    @Business(viewType="both")
    public FileTreeNode getDirectoryTree(boolean includeFiles, int moduleId) {
        List<FileDirectory> directories = this.fileDirectoryDAO.findByModuleId(moduleId);
        HashMap<Integer, FileTreeNode> directoryMap = new HashMap<Integer, FileTreeNode>();
        FileTreeNode rootNode = new FileTreeNode();
        for (FileDirectory directory : directories) {
            FileTreeNode currentNode = new FileTreeNode(directory);
            directoryMap.put(directory.getId(), currentNode);
            Integer parentId = directory.getParentId();
            FileTreeNode targetNode = parentId == null ? rootNode : (FileTreeNode)directoryMap.get(parentId);
            targetNode.addChild(currentNode);
        }
        if (includeFiles) {
            List<FileStorage> files = this.fileStorageDAO.findByModuleId(moduleId);
            for (FileStorage file : files) {
                FileTreeNode currentNode = new FileTreeNode(file);
                Integer parentId = file.getParentId();
                FileTreeNode targetNode = parentId == null ? rootNode : (FileTreeNode)directoryMap.get(parentId);
                targetNode.addChild(currentNode);
            }
        }
        return rootNode;
    }

    @Override
    @Business(viewType="both")
    public FileTreeNode getDirectorySubtree(int directoryId, boolean includeFiles) {
        FileDirectory directory = (FileDirectory)this.fileDirectoryDAO.findByPrimaryKey(directoryId);
        FileTreeNode directoryNode = new FileTreeNode(directory);
        List<FileDirectory> subdirectories = this.getDirectoriesInDirectory(directoryId);
        for (FileDirectory subdirectory : subdirectories) {
            FileTreeNode subNode = this.getDirectorySubtree(subdirectory.getId(), includeFiles);
            directoryNode.addChild(subNode);
        }
        if (includeFiles) {
            List<FileStorage> files = this.getFilesInDirectory(directoryId);
            for (FileStorage file : files) {
                directoryNode.addChild(new FileTreeNode(file));
            }
        }
        return directoryNode;
    }

    private Long getUserId() {
        String username = this.sessionContext.getCallerPrincipal().getName();
        Account account = null;
        if (username.equals("superadmin")) {
            account = this.userAdminFacadeLocal.getAccountByUsername(username);
        }
        return account == null ? null : Long.valueOf(account.getId());
    }

    @Override
    @Business(viewType="both")
    public void test() {
    }
}

