/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.domain;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.domain.Domain;
import de.proveo.wwt.logic.ejb.general.domain.DomainDAO;
import de.proveo.wwt.logic.ejb.general.domain.DomainFacadeLocal;
import de.proveo.wwt.logic.ejb.general.domain.DomainFacadeRemote;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Stateless(name="DomainFacade")
@Remote(value={DomainFacadeRemote.class})
@Local(value={DomainFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/DomainFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/DomainFacade")
public class DomainFacadeBean
implements DomainFacadeLocal,
DomainFacadeRemote {
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private DomainDAO domainDAO;

    @PostConstruct
    public void ejbCreate() {
        this.domainDAO = DomainDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<Domain> getDomains() {
        return this.domainDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public int createDomain(Domain domain) {
        this.domainDAO.createEntity(domain);
        return domain.getId();
    }

    @Override
    @Business(viewType="both")
    public Domain createOrFindDomain(String name) {
        Domain domain = this.find(name);
        if (domain == null) {
            domain = new Domain(name);
            this.createDomain(domain);
        }
        return domain;
    }

    @Override
    @Business(viewType="both")
    public void updateDomain(Domain domain) {
        this.domainDAO.updateEntity(domain);
    }

    @Override
    @Business(viewType="both")
    public void removeDomain(int id) {
        this.domainDAO.delete(id);
    }

    @Override
    @Business(viewType="both")
    public void removeDomain(Domain domain) {
        this.domainDAO.removeEntity(domain);
    }

    @Override
    @Business(viewType="both")
    public Domain find(String name) {
        return this.domainDAO.find(name);
    }
}

