/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.configuration;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.container.ContainerUtil;
import de.proveo.util.reflection.ReflectionUtil;
import de.proveo.util.xml.XmlUtil;
import de.proveo.wwt.datamodel.configuration.ConfigurationGroup;
import de.proveo.wwt.datamodel.configuration.ConfigurationProperty;
import de.proveo.wwt.datamodel.domain.Domain;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationEntry;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationFacadeRemote;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationGroupDAO;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationPropertyDAO;
import de.proveo.wwt.logic.ejb.general.configuration.ConfigurationToken;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.Configuration;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.ConfigurationRoot;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.DefaultConfiguration;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.PostRead;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.PostWrite;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.PreRead;
import de.proveo.wwt.logic.ejb.general.configuration.annotation.PreWrite;
import de.proveo.wwt.logic.ejb.general.domain.DomainFacadeLocal;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="ConfigurationFacade")
@Remote(value={ConfigurationFacadeRemote.class})
@Local(value={ConfigurationFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/ConfigurationFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/ConfigurationFacade")
public class ConfigurationFacadeBean
implements ConfigurationFacadeLocal,
ConfigurationFacadeRemote {
    private static final Log log = LogFactory.getLog(ConfigurationFacadeBean.class);
    private static final char CONFIGURATION_SEPARATOR = '.';
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager;
    private ConfigurationGroupDAO configurationGroupDAO;
    private ConfigurationPropertyDAO configurationPropertyDAO;
    @EJB
    private DomainFacadeLocal domainFacade;

    @PostConstruct
    public void ejbCreate() {
        this.configurationGroupDAO = ConfigurationGroupDAO.newInstance(this.entityManager);
        this.configurationPropertyDAO = ConfigurationPropertyDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public byte[] exportConfiguration(Integer groupId, boolean defaultDomainOnly) {
        List<ConfigurationProperty> properties = defaultDomainOnly ? (groupId == null ? this.configurationPropertyDAO.findByDefaultDomain() : this.configurationPropertyDAO.findByDefaultDomain(groupId)) : (groupId == null ? this.configurationPropertyDAO.findAll() : this.configurationPropertyDAO.find(groupId));
        ArrayList<ConfigurationEntry> entries = new ArrayList<ConfigurationEntry>(properties.size());
        for (ConfigurationProperty p : properties) {
            String domainName = p.getDomainId() != null ? p.getDomain().getName() : null;
            entries.add(new ConfigurationEntry(domainName, p.getGroup().getName(), p.getName(), p.getValue()));
        }
        return XmlUtil.serialize(entries).getBytes();
    }

    @Override
    @Business(viewType="both")
    public void importConfiguration(byte[] data) throws IllegalArgumentException {
        List entries = (List)XmlUtil.deserialize((String)new String(data));
        for (ConfigurationEntry entry : entries) {
            int groupId;
            String domainName = entry.domainName;
            Integer domainId = domainName == null || domainName.isEmpty() ? null : Integer.valueOf(this.domainFacade.createOrFindDomain(domainName).getId());
            ConfigurationProperty property = this.findProperty(domainId, groupId = this.createOrFindGroup(entry.groupName).getId(), entry.name);
            if (property == null) {
                property = new ConfigurationProperty();
                property.setDomainId(domainId);
                property.setGroupId(groupId);
                property.setName(entry.name);
                property.setValue(entry.value);
                this.configurationPropertyDAO.createEntity(property);
                continue;
            }
            property.setValue(entry.value);
        }
    }

    @Override
    @Business(viewType="both")
    public void writeConfiguration(Object configuration) {
        ConfigurationRoot root = configuration.getClass().getAnnotation(ConfigurationRoot.class);
        if (root == null) {
            throw new IllegalArgumentException("No @ConfigurationRoot defined for " + configuration.getClass().getName());
        }
        String name = root.group();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("No group name defined in @ConfigurationRoot for " + configuration.getClass().getName());
        }
        ConfigurationGroup group = this.createOrFindGroup(name);
        this.writeConfiguration(configuration, group.getId());
    }

    @Override
    @Business(viewType="both")
    public void writeConfiguration(Object configuration, int groupId) {
        this.writeConfiguration(configuration, null, groupId);
    }

    @Override
    @Business(viewType="both")
    public void writeConfiguration(Object configurationInstance, Integer domainId, int groupId) {
        Map<String, FieldInfo> fieldMap = this.enumerateConfigurationFields(configurationInstance.getClass());
        Object defaultConfiguration = this.createDefaultInstance(configurationInstance.getClass(), fieldMap.values());
        Collection<FieldInfo> fields = fieldMap.values();
        this.invokeMethods(configurationInstance, fields, PreWrite.class);
        for (FieldInfo fieldInfo : fieldMap.values()) {
            Object defaultValue = this.getNestedFieldContent(fieldInfo, defaultConfiguration);
            Object assignedValue = this.getNestedFieldContent(fieldInfo, configurationInstance);
            ConfigurationProperty property = this.findProperty(domainId, groupId, fieldInfo.name);
            Object defaultDomainValue = null;
            if (domainId != null) {
                ConfigurationProperty defaultProperty = this.findProperty(null, groupId, fieldInfo.name);
                if (defaultProperty != null) {
                    defaultDomainValue = XmlUtil.deserialize((String)defaultProperty.getValue());
                }
                if (defaultDomainValue == null) {
                    defaultDomainValue = defaultValue;
                }
            }
            if (defaultValue != null && defaultValue.getClass().isArray()) {
                defaultValue = ContainerUtil.asArrayList((Object)defaultValue);
            }
            if (assignedValue != null && assignedValue.getClass().isArray()) {
                assignedValue = ContainerUtil.asArrayList((Object)assignedValue);
            }
            if (defaultDomainValue != null && defaultDomainValue.getClass().isArray()) {
                defaultDomainValue = ContainerUtil.asArrayList((Object)defaultDomainValue);
            }
            if (domainId == null && defaultValue == null && assignedValue == null || domainId != null && defaultDomainValue == null && assignedValue == null || domainId == null && defaultValue != null && defaultValue.equals(assignedValue) || domainId != null && defaultDomainValue != null && defaultDomainValue.equals(assignedValue)) {
                if (property == null) continue;
                this.configurationPropertyDAO.removeEntity(property);
                continue;
            }
            String xmlValue = XmlUtil.serialize((Object)assignedValue);
            if (property != null) {
                property.setValue(xmlValue);
                continue;
            }
            ConfigurationProperty newProperty = new ConfigurationProperty();
            newProperty.setDomainId(domainId);
            newProperty.setGroupId(groupId);
            newProperty.setName(fieldInfo.name);
            newProperty.setValue(xmlValue);
            this.configurationPropertyDAO.createEntity(newProperty);
        }
        this.invokeMethods(configurationInstance, fields, PostWrite.class);
    }

    private Object getNestedFieldContent(FieldInfo fieldInfo, Object declaringClassInstance) {
        Object parent = this.getDeclaringClassInstance(declaringClassInstance, fieldInfo);
        return ReflectionUtil.getFieldContent((Field)fieldInfo.field, (Object)parent);
    }

    private void setNestedFieldContent(FieldInfo fieldInfo, Object declaringClassInstance, Object value) {
        Object parent = this.getDeclaringClassInstance(declaringClassInstance, fieldInfo);
        ReflectionUtil.setFieldContent((Field)fieldInfo.field, (Object)parent, (Object)value);
    }

    @Override
    @Business(viewType="both")
    public <T> T readConfiguration(Class<T> type) {
        String name = this.getGroupname(type);
        ConfigurationGroup group = this.createOrFindGroup(name);
        return this.readConfiguration(type, group.getId());
    }

    @Override
    @Business(viewType="both")
    public <T> T readConfiguration(Class<T> type, int groupId) {
        return this.readConfiguration(type, null, groupId);
    }

    @Override
    @Business(viewType="both")
    public <T> T readConfiguration(Class<T> type, Integer domainId, int groupId) {
        Map<String, FieldInfo> fieldMap = this.enumerateConfigurationFields(type);
        T configurationInstance = this.createDefaultInstance(type, fieldMap.values());
        Collection<FieldInfo> fields = fieldMap.values();
        this.invokeMethods(configurationInstance, fields, PreRead.class);
        if (domainId != null) {
            ArrayList<ConfigurationProperty> domainProperties = new ArrayList<ConfigurationProperty>(this.configurationPropertyDAO.find((int)domainId, groupId));
            this.deserializeValues(fieldMap, configurationInstance, domainProperties);
        }
        List<ConfigurationProperty> defaultProperties = this.configurationPropertyDAO.findByDefaultDomain(groupId);
        this.deserializeValues(fieldMap, configurationInstance, defaultProperties);
        this.invokeMethods(configurationInstance, fields, PostRead.class);
        return configurationInstance;
    }

    private void deserializeValues(Map<String, FieldInfo> fieldMap, Object configurationInstance, List<ConfigurationProperty> properties) {
        for (int i = properties.size() - 1; i >= 0; --i) {
            ConfigurationProperty currentProperty = properties.get(i);
            String name = currentProperty.getName();
            FieldInfo fieldInfo = fieldMap.get(name);
            if (fieldInfo == null) continue;
            boolean result = this.deserializeValue(configurationInstance, fieldInfo, currentProperty.getValue());
            if (result) {
                fieldMap.remove(name);
            }
            if (fieldMap.size() == 0) break;
        }
    }

    private boolean deserializeValue(Object configurationInstance, FieldInfo fieldInfo, String xmlValue) {
        Object value = null;
        boolean result = true;
        if (xmlValue != null) {
            try {
                value = XmlUtil.deserialize((String)xmlValue);
            }
            catch (Exception e) {
                log.info((Object)"Cannot deserialize configuration value from database. Using default.");
            }
            if (value == null) {
                result = false;
            }
        }
        if (value != null) {
            this.setNestedFieldContent(fieldInfo, configurationInstance, value);
        }
        return result;
    }

    private <T> T createDefaultInstance(Class<T> type, Collection<FieldInfo> fields) {
        T configuration = null;
        try {
            configuration = type.newInstance();
            for (FieldInfo fieldInfo : fields) {
                this.getDeclaringClassInstance(configuration, fieldInfo);
            }
            this.invokeMethods(configuration, fields, DefaultConfiguration.class);
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return configuration;
    }

    private void invokeMethods(Object configurationInstance, Collection<FieldInfo> fields, Class<? extends Annotation> annotation) {
        Set<Object> classInstances = this.getClassInstances(configurationInstance, fields);
        for (Object e : classInstances) {
            Method[] methods;
            for (Method method : methods = ReflectionUtil.getAnnotatedMethods(e.getClass(), annotation)) {
                ReflectionUtil.invokeMethod(e, (Method)method, null);
            }
        }
    }

    private Set<Object> getClassInstances(Object configurationInstance, Collection<FieldInfo> fields) {
        HashSet<Object> classInstances = new HashSet<Object>();
        classInstances.add(configurationInstance);
        for (FieldInfo fieldInfo : fields) {
            Field currentField = fieldInfo.parents[0];
            Object currentParent = ReflectionUtil.getFieldContent((Field)currentField, (Object)configurationInstance);
            if (currentParent != null) {
                classInstances.add(currentParent);
            }
            for (int i = 1; i != fieldInfo.parents.length; ++i) {
                currentField = fieldInfo.parents[i];
                Object oldParent = currentParent;
                if ((currentParent = ReflectionUtil.getFieldContent((Field)currentField, (Object)oldParent)) == null) continue;
                classInstances.add(currentParent);
            }
        }
        return classInstances;
    }

    private Object getDeclaringClassInstance(Object configurationInstance, FieldInfo fieldInfo) {
        Field currentField = fieldInfo.parents[0];
        Object currentParent = ReflectionUtil.getFieldContent((Field)currentField, (Object)configurationInstance);
        try {
            if (currentParent == null) {
                currentParent = currentField.getType().newInstance();
                ReflectionUtil.setFieldContent((Field)currentField, (Object)configurationInstance, (Object)currentParent);
            }
            for (int i = 1; i != fieldInfo.parents.length; ++i) {
                currentField = fieldInfo.parents[i];
                Object oldParent = currentParent;
                if ((currentParent = ReflectionUtil.getFieldContent((Field)currentField, (Object)oldParent)) != null) continue;
                currentParent = currentField.getType().newInstance();
                ReflectionUtil.setFieldContent((Field)currentField, (Object)oldParent, (Object)currentParent);
            }
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
            currentParent = null;
        }
        return currentParent;
    }

    @Override
    @Business(viewType="both")
    public void synchronizeConfiguration(Class<?> type) {
        String name = this.getGroupname(type);
        ConfigurationGroup group = this.createOrFindGroup(name);
        this.synchronizeConfiguration(type, group.getId());
    }

    private String getGroupname(Class<?> type) {
        ConfigurationRoot root = this.getConfigurationRoot(type);
        if (root == null) {
            throw new IllegalArgumentException("No @ConfigurationRoot defined for " + type.getName());
        }
        String name = root.group();
        if (name.isEmpty()) {
            throw new IllegalArgumentException("No group name defined in @ConfigurationRoot for " + type.getName());
        }
        return name;
    }

    @Override
    @Business(viewType="both")
    public void synchronizeConfiguration(Class<?> type, int groupId) {
        List<ConfigurationProperty> existingProperties = this.configurationPropertyDAO.find(groupId);
        Map<String, FieldInfo> fieldMap = this.enumerateConfigurationFields(type);
        for (ConfigurationProperty property : existingProperties) {
            FieldInfo fieldInfo = fieldMap.get(property.getName());
            if (fieldInfo != null) continue;
            this.configurationPropertyDAO.removeEntity(property);
        }
    }

    private Map<String, FieldInfo> enumerateConfigurationFields(Class<?> type) {
        HashMap<String, FieldInfo> fieldMap = new HashMap<String, FieldInfo>();
        Stack<Field> fieldStack = new Stack<Field>();
        this.processSubfields(fieldMap, fieldStack, type);
        return fieldMap;
    }

    private void findFields(Map<String, FieldInfo> fieldMap, Stack<Field> fieldStack, Field field) {
        Class<?> type = field.getType();
        fieldStack.push(field);
        this.processSubfields(fieldMap, fieldStack, type);
        fieldStack.pop();
    }

    private void processSubfields(Map<String, FieldInfo> fields, Stack<Field> fieldStack, Class<?> type) {
        Field[] declaredFields;
        for (Field currentField : declaredFields = ReflectionUtil.getFields(type)) {
            Configuration annotation = currentField.getAnnotation(Configuration.class);
            if (annotation != null) {
                String name = this.buildConfigurationName(fieldStack, currentField);
                fields.put(name, new FieldInfo(currentField, annotation, name, fieldStack.toArray(new Field[fieldStack.size()])));
                continue;
            }
            int size = fieldStack.size();
            if (size != 0 && (size == 0 || fieldStack.peek().getType() == currentField.getType())) continue;
            this.findFields(fields, fieldStack, currentField);
        }
    }

    private String buildConfigurationName(Stack<Field> fieldStack, Field field) {
        int size = fieldStack.size();
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 0; i != size; ++i) {
            nameBuilder.append(((Field)fieldStack.get(i)).getName());
            nameBuilder.append('.');
        }
        nameBuilder.append(field.getName());
        return nameBuilder.toString();
    }

    private ConfigurationRoot getConfigurationRoot(Class<?> type) {
        ConfigurationRoot root = type.getAnnotation(ConfigurationRoot.class);
        if (root == null) {
            throw new IllegalArgumentException("No @ConfigurationRoot found in passed type");
        }
        return root;
    }

    @Override
    @Business(viewType="both")
    public void setProperty(String groupName, String key, Object value) {
        ConfigurationToken configurationToken = this.getConfigurationToken(groupName);
        this.setProperty(configurationToken, key, value);
    }

    @Override
    @Business(viewType="both")
    public <T> T getProperty(Class<T> type, String groupName, String key) {
        ConfigurationToken configurationToken = this.getConfigurationToken(groupName);
        return this.getProperty(type, configurationToken, key);
    }

    @Override
    @Business(viewType="both")
    public void setProperty(ConfigurationToken token, String key, Object value) {
        ConfigurationProperty cp = this.findProperty(token.domainId, token.groupId, key);
        String newValue = XmlUtil.serialize((Object)value);
        if (cp == null) {
            cp = token.createConfigurationProperty();
            cp.setName(key);
            cp.setValue(newValue);
            this.configurationPropertyDAO.createEntity(cp);
        } else {
            cp.setValue(newValue);
        }
    }

    @Override
    @Business(viewType="both")
    public <T> T getProperty(Class<T> type, ConfigurationToken token, String key) {
        Object value = null;
        ConfigurationProperty cp = this.findProperty(token.domainId, token.groupId, key);
        if (cp == null && token.domainId != null && (cp = this.findProperty(null, token.groupId, key)) == null) {
            log.warn((Object)("Property with name '" + key + "' not found for passed or default domain."));
        }
        if (cp != null) {
            try {
                value = XmlUtil.deserialize((String)cp.getValue());
            }
            catch (ClassCastException e) {
                log.error((Object)("Error casting '" + key + "' to " + type.getSimpleName() + ". Returning null."));
                value = null;
            }
        }
        return (T)value;
    }

    private ConfigurationProperty findProperty(Integer domainId, int groupId, String key) {
        return domainId == null ? this.configurationPropertyDAO.find(groupId, key) : this.configurationPropertyDAO.find(domainId, groupId, key);
    }

    @Override
    @Business(viewType="both")
    public ConfigurationToken getConfigurationToken(String groupName) {
        return this.getConfigurationToken((Integer)null, groupName);
    }

    @Override
    @Business(viewType="both")
    public ConfigurationToken getConfigurationToken(String domainName, String groupName) {
        Integer domainId = null;
        if (domainName != null) {
            Domain domain = this.domainFacade.find(domainName);
            if (domain != null) {
                domainId = domain.getId();
            } else {
                log.warn((Object)("Domain '" + domainName + "' not found. Using default domain."));
            }
        }
        return this.getConfigurationToken(domainId, groupName);
    }

    @Override
    @Business(viewType="both")
    public ConfigurationToken getConfigurationToken(Integer domainId, String groupName) {
        ConfigurationToken configurationToken = null;
        if (groupName != null) {
            ConfigurationGroup configurationGroup = this.configurationGroupDAO.find(groupName);
            if (configurationGroup != null) {
                configurationToken = new ConfigurationToken(domainId, configurationGroup.getId());
            } else {
                log.error((Object)("Group '" + groupName + "' not found."));
            }
        } else {
            log.error((Object)"Group name must not be null");
        }
        return configurationToken;
    }

    @Override
    @Business(viewType="both")
    public List<ConfigurationGroup> getGroups() {
        return this.configurationGroupDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public int createGroup(ConfigurationGroup group) {
        this.configurationGroupDAO.createEntity(group);
        return group.getId();
    }

    @Override
    @Business(viewType="both")
    public ConfigurationGroup createOrFindGroup(String name) {
        ConfigurationGroup group = this.findGroup(name);
        if (group == null) {
            group = new ConfigurationGroup(name);
            this.createGroup(group);
        }
        return group;
    }

    @Override
    @Business(viewType="both")
    public void updateGroup(ConfigurationGroup group) {
        this.configurationGroupDAO.updateEntity(group);
    }

    @Override
    @Business(viewType="both")
    public void removeGroup(int id) {
        this.configurationGroupDAO.delete(id);
    }

    @Override
    @Business(viewType="both")
    public void removeGroup(ConfigurationGroup group) {
        this.configurationGroupDAO.removeEntity(group);
    }

    @Override
    @Business(viewType="both")
    public ConfigurationGroup findGroup(String name) {
        return this.configurationGroupDAO.find(name);
    }

    @Override
    @Business(viewType="both")
    public List<ConfigurationProperty> getProperties() {
        return this.configurationPropertyDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public int createProperty(ConfigurationProperty property) {
        this.configurationPropertyDAO.createEntity(property);
        return property.getId();
    }

    @Override
    @Business(viewType="both")
    public void updateProperty(ConfigurationProperty property) {
        this.configurationPropertyDAO.updateEntity(property);
    }

    @Override
    @Business(viewType="both")
    public void removeProperty(int id) {
        this.configurationPropertyDAO.delete(id);
    }

    @Override
    @Business(viewType="both")
    public void removeProperty(ConfigurationProperty property) {
        this.configurationPropertyDAO.removeEntity(property);
    }

    private class FieldInfo {
        public Field field;
        public Configuration configuration;
        public String name;
        public Field[] parents;

        public FieldInfo() {
        }

        public FieldInfo(Field field, Configuration configuration, String name, Field[] parents) {
            this.field = field;
            this.configuration = configuration;
            this.name = name;
            this.parents = parents;
        }
    }
}

