/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.c2dm;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.c2dm.C2DMUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthenticationException;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@MessageDriven(name="UserUserLoginC2DM", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="topic/proveoDataProviderTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="TypeOfInterest='UseEvent'"), @ActivationConfigProperty(propertyName="maxSession", propertyValue="1")})
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class UseUserLoginC2DMBean
implements MessageListener {
    private static final Log log = LogFactory.getLog(UseUserLoginC2DMBean.class);
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade;
    @EJB
    private ConfigurationLocal configurationLocal;
    private String googleSenderEmailAddress;
    private String googleSenderPassword;
    private String googleApplicationSource;
    private boolean c2dmActive = false;
    private volatile String authtoken;

    @PostConstruct
    public void ejbCreate() {
        try {
            this.c2dmActive = this.configurationLocal.getBoolean("google.c2dm");
            if (this.c2dmActive) {
                this.googleSenderEmailAddress = this.configurationLocal.getParameter("google.c2dm.email");
                this.googleSenderPassword = this.configurationLocal.getParameter("google.c2dm.password");
                this.googleApplicationSource = this.configurationLocal.getParameter("google.c2dm.source");
            }
        }
        catch (ConfigurationParameterNotFoundException ex) {
            Logger.getLogger(UseUserLoginC2DMBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onMessage(Message msg) {
        if (this.c2dmActive) {
            try {
                UseUser user;
                String registrationId;
                Serializable obj = ((ObjectMessage)msg).getObject();
                SerializableEventWrapper wrapper = (SerializableEventWrapper)obj;
                IHistoryEntity history = (IHistoryEntity)wrapper.get_historyValue();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("onMessage() " + history.getClass().getName() + " unitId:" + history.getUnitId() + " beginTime:" + history.getBeginTime() + " historyId:" + history.getHistoryId()));
                }
                UseHistory useHistoryEvent = (UseHistory)wrapper.get_historyValue();
                UseEvent useEvent = (UseEvent)wrapper.get_cacheValue();
                if (useEvent.isLogin() && useHistoryEvent.getUseUserId() != null && (registrationId = (user = this.useUserAdminFacade.getUseUserById(useHistoryEvent.getUseUserId())).getPersonalNumber()) != null && !registrationId.isEmpty()) {
                    this.notifyClient(registrationId, "newTripp:" + user.getKeyId());
                }
            }
            catch (Exception ex) {
                this.authtoken = null;
                log.error((Object)"runs into", (Throwable)ex);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"C2DM forwarding not active.");
        }
    }

    private void notifyClient(String registrationId, String payload) throws IOException, AuthenticationException {
        if (this.authtoken == null) {
            this.googleApplicationLogin();
        }
        try {
            C2DMUtil.send(registrationId, Long.toString(System.currentTimeMillis()), payload, this.authtoken);
        }
        catch (AuthenticationException ex) {
            log.warn((Object)"renew authtoken");
            this.googleApplicationLogin();
            C2DMUtil.send(registrationId, Long.toString(System.currentTimeMillis()), payload, this.authtoken);
        }
    }

    protected void googleApplicationLogin() throws IOException {
        this.authtoken = C2DMUtil.login(this.googleSenderEmailAddress, this.googleSenderPassword, this.googleApplicationSource).getProperty("Auth");
    }
}

