/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.c2dm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public final class C2DMUtil {
    public static Properties login(String email, String password, String source) throws IOException {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("Email", email));
        formparams.add(new BasicNameValuePair("Passwd", password));
        formparams.add(new BasicNameValuePair("accountType", "GOOGLE"));
        formparams.add(new BasicNameValuePair("source", source));
        formparams.add(new BasicNameValuePair("service", "ac2dm"));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
        HttpPost post = new HttpPost("https://www.google.com/accounts/ClientLogin");
        post.setEntity((HttpEntity)entity);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse resp = httpclient.execute((HttpUriRequest)post);
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new IOException(resp.getStatusLine().toString());
        }
        return C2DMUtil.parseLoginResponse(resp.getEntity().getContent());
    }

    public static void send(String registrationId, String collapseKey, String payload, String authtoken) throws IOException, AuthenticationException {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("registration_id", registrationId));
        formparams.add(new BasicNameValuePair("collapse_key", collapseKey));
        formparams.add(new BasicNameValuePair("data.payload", payload));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
        HttpPost post = new HttpPost("http://android.clients.google.com/c2dm/send");
        post.addHeader("Authorization", "GoogleLogin auth=" + authtoken);
        post.setEntity((HttpEntity)entity);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse resp = httpclient.execute((HttpUriRequest)post);
        switch (resp.getStatusLine().getStatusCode()) {
            case 200: {
                break;
            }
            case 401: {
                throw new AuthenticationException(resp.getStatusLine().getReasonPhrase());
            }
            default: {
                throw new IOException(resp.getStatusLine().toString());
            }
        }
    }

    protected static Properties parseLoginResponse(InputStream response) throws IOException {
        Properties properties = new Properties();
        properties.load(response);
        return properties;
    }
}

