/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.container.ContainerUtil;
import de.proveo.util.jpa.JpaUtil;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="UseUserAdminFacade")
@Remote(value={UseUserAdminFacadeRemote.class})
@Local(value={UseUserAdminFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UseUserAdminFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UseUserAdminFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class UseUserAdminFacadeBean
implements UseUserAdminFacadeLocal,
UseUserAdminFacadeRemote {
    private static final Log logger = LogFactory.getLog(UseUserAdminFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private UnitFacadeLocal unitFacadeLocal = null;
    private UseUserGroupAdminFacadeLocal useUserGroupAdministrationFacade = null;
    @Resource
    private SessionContext sessionContext = null;
    private UseUserDAO useUserDAO = null;

    @PostConstruct
    private void initImpl() {
        this.useUserDAO = UseUserDAO.newInstance(this.entityManager);
    }

    private UnitFacadeLocal getUnitFacade() {
        if (this.unitFacadeLocal == null) {
            try {
                InitialContext context = new InitialContext();
                this.unitFacadeLocal = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            }
            catch (NamingException e) {
                logger.error((Object)"runs into ", (Throwable)e);
            }
        }
        return this.unitFacadeLocal;
    }

    private UseUserGroupAdminFacadeLocal getGroupFacade() {
        if (this.useUserGroupAdministrationFacade == null) {
            try {
                InitialContext context = new InitialContext();
                this.useUserGroupAdministrationFacade = (UseUserGroupAdminFacadeLocal)context.lookup("rts/UseUserGroupAdminFacade/local");
            }
            catch (NamingException e) {
                logger.error((Object)"runs into ", (Throwable)e);
            }
        }
        return this.useUserGroupAdministrationFacade;
    }

    @Override
    @Business(viewType="both")
    public String duplicatedUseUserKeyAndName(String key, String name, long id) {
        List<UseUser> collection = this.getAllDeletedUseUsers();
        for (UseUser value : collection) {
            if (value.getId() == id) continue;
            String valueKey = value.getKeyId();
            String valueKeyName = value.getKeyId() + "#" + value.getName();
            if (!value.getDeleted() || valueKey == null || key.equals("") || !valueKeyName.equals(key + "#" + name)) continue;
            if (value.getDeleted()) {
                return "keyNameDeleted";
            }
            return "keyName";
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public String duplicatedUseUserKey(String key, long id) {
        if (key != null && !key.equals("")) {
            List<UseUser> collection = this.getAllUseUsers();
            for (UseUser value : collection) {
                String valueKey;
                if (value.getId() == id || (valueKey = value.getKeyId()) == null || !valueKey.equals(key)) continue;
                if (value.getDeleted()) {
                    return "keyDeleted";
                }
                return "key";
            }
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public String duplicatedUseUserPersonalNumber(String personalNumber, long id) {
        if (personalNumber != null && !personalNumber.equals("")) {
            List<UseUser> collection = this.getAllUseUsersIncludeDeleted();
            for (UseUser value : collection) {
                String valuePersonalNumber;
                if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || !valuePersonalNumber.equals(personalNumber)) continue;
                if (value.getDeleted()) {
                    return "personalNumberDeleted";
                }
                return "personalNumber";
            }
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public String validateUseUser(UseUser value, long id) {
        String validation = "";
        validation = this.duplicatedUseUserPersonalNumber(value.getPersonalNumber(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKey(value.getKeyId(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKeyAndName(value.getKeyId(), value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public Long insertUseUser(UseUser useUser) throws DuplicateKeyException, CreateException {
        String validation;
        if (useUser.getId() != 0L) {
            logger.warn((Object)"id of useUser to be inserted is not 0");
        }
        if ((validation = this.validateUseUser(useUser, -1L)) != null) {
            throw new DuplicateKeyException(validation);
        }
        this.useUserDAO.createEntity(useUser);
        for (UseGroup g : useUser.getUseGroups()) {
            this.getUnitFacade().updateUnitUserRefreshForUseGroup(g.getId());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + g.getId()));
        }
        return useUser.getId();
    }

    @Override
    @Business(viewType="both")
    public Long insertUseUserFlush(UseUser useUser) throws DuplicateKeyException, CreateException {
        Long ret = this.insertUseUser(useUser);
        this.entityManager.flush();
        return ret;
    }

    @Override
    @Business(viewType="both")
    public void addGroupToUser(long useUserId, long useGroupId) {
        UseUser useUser = (UseUser)this.useUserDAO.findByPrimaryKey(useUserId);
        UseGroup useGroup = this.getGroupFacade().getUseGroupById(useGroupId);
        useUser.addUseGroup(useGroup);
    }

    @Override
    @Business(viewType="both")
    public boolean updateUseUser(UseUser useUser) throws DuplicateKeyException {
        String newKey;
        boolean success = false;
        String validation = this.validateUseUser(useUser, useUser.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        EntityManager auditEntityManager = JpaUtil.createAuditEntityManager();
        UseUser oldUseUser = (UseUser)auditEntityManager.find(UseUser.class, useUser.getPrimaryKey());
        if (((Object)oldUseUser).equals(useUser) && ((Object)oldUseUser.getLicenses()).equals(useUser.getLicenses())) {
            return true;
        }
        useUser = (UseUser)this.useUserDAO.updateEntity(useUser);
        UnitFacadeLocal unitFacade = this.getUnitFacade();
        List changedGroups = ContainerUtil.disjunctList(useUser.getUseGroups(), oldUseUser.getUseGroups());
        for (UseGroup g : changedGroups) {
            unitFacade.updateUnitUserRefreshForUseGroup(g.getId());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + g.getId()));
        }
        String oldKey = oldUseUser.getKeyId() == null ? "" : oldUseUser.getKeyId();
        String string = newKey = useUser.getKeyId() == null ? "" : useUser.getKeyId();
        if (!oldKey.equals(newKey) || oldUseUser.getMechanic() != useUser.getMechanic()) {
            unitFacade.updateUnitUserRefreshForUseUser(useUser.getId());
            for (UseGroup g : useUser.getUseGroups()) {
                unitFacade.updateUnitUserRefreshForUseGroup(g.getId());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" ---- unituserrefresh for key change : " + useUser.getKeyId()));
            }
        }
        success = true;
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean deleteUseUser(long id, ModuleType module) {
        boolean success = false;
        try {
            UseUser useUser = (UseUser)this.useUserDAO.findByPrimaryKey(id);
            useUser.setModule(module);
            useUser.setDeleted(true);
            useUser = (UseUser)this.useUserDAO.updateEntity(useUser);
            this.getUnitFacade().updateUnitUserRefreshForUseUser(useUser.getId());
            for (UseGroup g : useUser.getUseGroups()) {
                this.getUnitFacade().updateUnitUserRefreshForUseGroup(g.getId());
            }
            useUser.clearRelations(UnitPermission.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" ---- unituserrefresh for : " + useUser.getKeyId()));
            }
            success = true;
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean deleteUseUser(long id) {
        return this.deleteUseUser(id, ModuleType.WEB);
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getAllUseUsers() {
        ArrayList<UseUser> list = null;
        List<UseUser> collection = this.useUserDAO.findAll();
        list = new ArrayList<UseUser>();
        for (UseUser useUserLocal : collection) {
            UseUser value = useUserLocal;
            if (this.filterOutUnknown(value)) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getAllDeletedUseUsers() {
        ArrayList<UseUser> list = null;
        List<UseUser> collection = this.useUserDAO.findAllDeleted();
        list = new ArrayList<UseUser>();
        for (UseUser useUserLocal : collection) {
            UseUser value = useUserLocal;
            if (this.filterOutUnknown(value)) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getAllUseUsersIncludeDeleted() {
        ArrayList<UseUser> list = null;
        List<UseUser> collection = this.useUserDAO.findAllIncludeDeleted();
        list = new ArrayList<UseUser>();
        Iterator i$ = collection.iterator();
        while (i$.hasNext()) {
            UseUser account;
            UseUser value = account = (UseUser)i$.next();
            list.add(value);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getUseUsersByUseGroupId(long groupId) {
        ArrayList<UseUser> list = new ArrayList<UseUser>();
        List<Object> collection = new ArrayList();
        UseGroup group = this.getGroupFacade().getUseGroupById(groupId);
        if (group != null) {
            collection = group.getUseUsers();
        }
        for (UseUser useUser : collection) {
            if (this.filterOutUnknown(useUser) || useUser.getDeleted()) continue;
            list.add(useUser);
        }
        return list;
    }

    private boolean filterOutUnknown(UseUser value) {
        try {
            if (!this.sessionContext.isCallerInRole("superadmin") && (value.getName().equals("unknown") || value.getKeyId().equals("0000000000000000"))) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public UseUser getUseUserByDiscription(String useUserDescription) {
        return this.useUserDAO.findUseUserByDescription(useUserDescription).get(0);
    }

    @Override
    @Business(viewType="both")
    public UseUser getUseUserById(long useUserId) {
        return (UseUser)this.useUserDAO.findByPrimaryKey(useUserId);
    }

    @Override
    @Business(viewType="both")
    public UseUser getUseUserByKey(String keyId) {
        List<UseUser> users = this.useUserDAO.findByKey(keyId = StringUtil.escapeNonLatin1Characters((String)keyId));
        Iterator<UseUser> iterator = users.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public UseUser getDeletedByKey(String keyId) {
        List<UseUser> users = this.useUserDAO.findDeletedByKey(keyId);
        Iterator<UseUser> iterator = users.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public void removeUseUser(UseUser useUser) {
        this.useUserDAO.removeEntity(useUser);
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> findUseUserByKey(String key) {
        return this.useUserDAO.findByKey(key);
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> findUseUserByPersonalNumber(String personalNumber) {
        return this.useUserDAO.findByPersonalNumber(personalNumber);
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> findUseUserLikeKey(String key) {
        return this.useUserDAO.findLikeKey(key);
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> findDeletedByKey(String name) {
        return this.useUserDAO.findDeletedByKey(name);
    }
}

