/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.use.license.License;
import de.proveo.wwt.datamodel.use.license.LicenseType;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.LicenseDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.LicenseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.LicenseFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.LicenseTypeDAO;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="LicenseFacade")
@Remote(value={LicenseFacadeRemote.class})
@Local(value={LicenseFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/LicenseFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/LicenseFacade")
public class LicenseFacadeBean
implements LicenseFacadeLocal,
LicenseFacadeRemote {
    private static final Log logger = LogFactory.getLog(LicenseFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @Resource
    private SessionContext sessionContext = null;
    private LicenseTypeDAO licenseTypeDAO = null;
    private LicenseDAO licenseDAO = null;

    @PostConstruct
    private void initImpl() {
        this.licenseTypeDAO = LicenseTypeDAO.newInstance(this.entityManager);
        this.licenseDAO = LicenseDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<LicenseType> getAllLicenseTypes() {
        return this.licenseTypeDAO.findAllLicenseTypes();
    }

    @Override
    @Business(viewType="both")
    public List<LicenseType> getAllAvailableLicenseTypes() {
        return this.licenseTypeDAO.findAllAvailableLicenseTypes();
    }

    @Override
    @Business(viewType="both")
    public LicenseType getTypeById(int id) {
        return (LicenseType)this.licenseTypeDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public void createLicenseType(LicenseType license) {
        this.licenseTypeDAO.createEntity(license);
    }

    @Override
    @Business(viewType="both")
    public void updateLicenseType(LicenseType license) {
        this.licenseTypeDAO.updateEntity(license);
    }

    @Override
    @Business(viewType="both")
    public void deleteLicenseType(LicenseType license) {
        license = (LicenseType)this.licenseTypeDAO.updateEntity(license);
        this.licenseTypeDAO.removeEntity(license);
    }

    @Override
    @Business(viewType="both")
    public List<License> getAllLicensesWithUseUser() {
        return this.licenseDAO.findAllLicensesWithUseUser();
    }

    @Override
    @Business(viewType="both")
    public void createLicense(License license) {
        this.licenseDAO.createEntity(license);
    }

    @Override
    @Business(viewType="both")
    public void updateLicense(License license) {
        this.licenseDAO.updateEntity(license);
    }

    @Override
    @Business(viewType="both")
    public void deleteLicense(License license) {
        license = (License)this.licenseDAO.updateEntity(license);
        this.licenseDAO.removeEntity(license);
    }
}

