/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.jpa.JpaUtil;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.AccountDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.RoleDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="UserAdminFacade")
@Remote(value={UserAdminFacadeRemote.class})
@Local(value={UserAdminFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UserAdminFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UserAdminFacade")
public class UserAdminFacadeBean
implements UserAdminFacadeLocal,
UserAdminFacadeRemote {
    private static final Log log = LogFactory.getLog(UserAdminFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private AccountDAO accountDAO = null;
    private RoleDAO roleDAO = null;
    @EJB
    private ConfigurationLocal configuration = null;
    @EJB
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal = null;
    @EJB
    private UserGroupAdminFacadeLocal userGroupAdminFacadeBean;
    @Resource
    private SessionContext sessionContext;

    @PostConstruct
    private void initImpl() {
        this.accountDAO = AccountDAO.newInstance(this.entityManager);
        this.roleDAO = RoleDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAllUsers() {
        return this.accountDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Account getAccount(long accountId) {
        return (Account)this.accountDAO.findByPrimaryKey(accountId);
    }

    @Override
    @Business(viewType="both")
    public boolean deleteUser(long accountId) {
        return this.deleteUser(accountId, false);
    }

    private boolean deleteUser(long accountId, boolean markAsDeleted) {
        boolean success = false;
        try {
            Account account = (Account)this.accountDAO.findByPrimaryKey(accountId);
            ArrayList<Account> accounts = new ArrayList<Account>();
            accounts.add(account);
            this.permissionUpdateNotifyLocal.sendUserDeletedJMSMessage(accounts);
            if (markAsDeleted) {
                account.setDeleted(true);
            } else {
                this.accountDAO.removeEntity(account);
            }
            success = true;
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean markAsDeleted(long accountId) {
        return this.deleteUser(accountId, true);
    }

    @Override
    @Business(viewType="both")
    public Long insertUser(Account account) throws DuplicateKeyException {
        Long id = null;
        String validation = this.validateUser(account, -1L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            boolean changePWDAfterFirstLogin = this.configuration.getBoolean("login.passwordChangeAfterFirstLogin");
            if (changePWDAfterFirstLogin) {
                account.setPasswordReset(true);
            } else {
                account.setPasswordReset(false);
            }
            this.accountDAO.createEntity(account);
            id = account.getId();
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"ConfigurationParameter not found: ", (Throwable)e);
        }
        return id;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateUser(Account account) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUser(account, account.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        EntityManager entityManager = JpaUtil.createAuditEntityManager();
        Account oldAccount = (Account)entityManager.find(Account.class, (Object)account.getId());
        if (oldAccount == null) {
            return false;
        }
        String userName = account.getUsername();
        if (this.sessionContext.getCallerPrincipal().getName().equals(userName)) {
            account.setPasswordReset(false);
        }
        if (((Object)oldAccount).equals(account)) {
            return true;
        }
        if (!account.getPassword().equals(oldAccount.getPassword())) {
            account.setLastPwdChange(System.currentTimeMillis());
        }
        if (!account.getBlockOut() && oldAccount.getBlockOut()) {
            account.setFailedLogins(0);
        }
        account = (Account)this.accountDAO.updateEntity(account);
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.add(account);
        if (account.getBlockOut() && !oldAccount.getBlockOut()) {
            this.permissionUpdateNotifyLocal.sendUserBlockOutJMSMessage(accounts);
        } else if (!ObjectUtils.equals((Object)account.getPassword(), (Object)oldAccount.getPassword())) {
            this.permissionUpdateNotifyLocal.sendUserPwChangedJMSMessage(accounts);
        } else if (!ObjectUtils.equals((Object)account.isSuperadmin(), (Object)oldAccount.isSuperadmin())) {
            this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
        }
        success = true;
        return success;
    }

    @Override
    @Business(viewType="both")
    public boolean duplicatedUsername(String userName, long accountId) {
        boolean duplicated = false;
        List<Account> collection = this.accountDAO.findAll();
        for (Account account : collection) {
            if (account.getId() == accountId || !account.getUsername().equals(userName)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    @Override
    @Business(viewType="both")
    public boolean duplicatedUserPersonalNumber(String personalNumber, long id) {
        boolean duplicated = false;
        if (personalNumber == null) {
            return duplicated;
        }
        List<Account> collection = this.accountDAO.findAll();
        for (Account value : collection) {
            String valuePersonalNumber;
            if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || personalNumber.equals("") || !valuePersonalNumber.equals(personalNumber)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    @Override
    @Business(viewType="both")
    public String validateUser(Account value, long id) {
        if (this.duplicatedUserPersonalNumber(value.getPersonalNumber(), id)) {
            return "personalNumber";
        }
        if (this.duplicatedUsername(value.getUsername(), id)) {
            return "username";
        }
        if (this.internalUsername(value.getUsername())) {
            return "internalUsername";
        }
        return null;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsByUsername(long groupId) {
        return this.getAccountsByGroupId(groupId);
    }

    @Override
    @Business(viewType="both")
    public List<Account> getAccountsByGroupId(long groupId) {
        GroupIdent groupIdent = this.userGroupAdminFacadeBean.getGroupIdent(groupId);
        return new ArrayList<Account>(groupIdent.getAccounts());
    }

    @Override
    @Business(viewType="both")
    public boolean internalUsername(String userName) {
        boolean internal = false;
        if (userName.equals("superadmin") || userName.equals("nobody")) {
            internal = true;
        }
        return internal;
    }

    @Override
    @Business(viewType="both")
    public List<Account> getUsernamesByRoleId(long roleId) {
        Role role = (Role)this.roleDAO.findByPrimaryKey(roleId);
        return new ArrayList<Account>(role.getAccounts());
    }

    @Override
    @Business(viewType="both")
    public int incrementFailedLogins(String username) {
        int failedLogins = 0;
        long overallFailedLogins = 0L;
        try {
            Account account = this.accountDAO.findByUsername(username);
            if (account != null) {
                failedLogins = account.getFailedLogins();
                overallFailedLogins = account.getOverallFailedLogins();
                account.setOverallFailedLogins(++overallFailedLogins);
                account.setFailedLogins(++failedLogins);
                account.setLastFailedLogin(System.currentTimeMillis());
                int failedLoginLimit = Integer.parseInt(this.configuration.getParameter("login.failedLoginLimit"));
                if (failedLoginLimit != 0 && failedLogins >= failedLoginLimit) {
                    account.setBlockOut(true);
                }
                account.setLoggingEnabled(false);
                this.accountDAO.updateEntity(account);
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return failedLogins;
    }

    @Override
    @Business(viewType="both")
    public void setLoginSuccessful(String username) {
        Account account = this.accountDAO.findByUsername(username);
        if (account != null) {
            int logins = account.getLogins();
            account.setLogins(logins + 1);
            account.setFailedLogins(0);
            this.entityManager.merge((Object)account);
        }
    }

    @Override
    @Business(viewType="both")
    public boolean isPasswordChangeRequired(String username) {
        try {
            Long lastPwdChange;
            Account account = this.getAccountByUsername(username);
            if (account != null && account.isPasswordReset()) {
                return true;
            }
            long days = this.configuration.getInteger("login.passwordChangeDays");
            if (account != null && days > 0L && (lastPwdChange = account.getLastPwdChange()) != null) {
                long millis = days * 86400000L;
                millis = lastPwdChange + millis;
                long current = System.currentTimeMillis();
                if (current > millis) {
                    return true;
                }
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    @Override
    @Business(viewType="both")
    public int getAccountNumber() {
        return this.accountDAO.getUserCount().intValue();
    }

    @Override
    @Business(viewType="both")
    public List<Account> findAllAccounts() {
        return this.accountDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Account getAccountByUsername(String username) {
        return this.accountDAO.findByUsername(username);
    }

    @Override
    @Business(viewType="both")
    public void removeAccount(Account account) {
        this.accountDAO.removeEntity(account);
    }

    @Override
    @Business(viewType="both")
    public void createAccount(Account account) {
        this.accountDAO.createEntity(account);
    }

    @Override
    @Business(viewType="both")
    public void resetFailedLogins(String username) {
        Account account = this.getAccountByUsername(username);
        account.setFailedLogins(0);
        this.accountDAO.updateEntity(account);
    }

    @Override
    @Business(viewType="both")
    public List<Role> getAllRoles() {
        return this.roleDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public Role getRoleById(long id) {
        return (Role)this.roleDAO.findByPrimaryKey(id);
    }

    @Override
    @Business(viewType="both")
    public Role getRoleByName(String rolename) {
        return this.roleDAO.findByRolename(rolename);
    }

    @Override
    @Business(viewType="both")
    public List<Role> getRolesWhichStartsWith(String rolename) {
        return this.roleDAO.findByStartsWith(rolename);
    }

    @Override
    @Business(viewType="both")
    public void createNewRole(Role role) {
        this.roleDAO.createEntity(role);
    }

    @Override
    @Business(viewType="both")
    public void removeRole(Role role) {
        this.roleDAO.removeEntity(role);
    }

    @Override
    @Business(viewType="both")
    public void updateRole(Role role) {
        Role currentRole = (Role)this.roleDAO.findByPrimaryKey(role.getId());
        if (currentRole != null) {
            this.roleDAO.updateEntity(role);
        }
    }
}

