/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.mapclient;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.notification.Notification;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgBase;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.mapclient.MapClientFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISFlightValue;
import de.proveo.wwt.logic.ejb.interfaces.fis.FISMapFacadeLocal;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheValue;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.PermissionFastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="MapClientFacade")
@Remote(value={MapClientFacadeRemote.class})
@Local(value={MapClientFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/MapClientFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/MapClientFacade")
public class MapClientFacadeBean
implements MapClientFacadeLocal,
MapClientFacadeRemote {
    private static final Log log = LogFactory.getLog(MapClientFacadeBean.class);
    private static final long NOTIFICATION_OFFSET_TIME = 86400000L;
    private final PermissionFastLaneReader permissionFastLaneReader = new PermissionFastLaneReader();
    @EJB
    private NotifyFacadeLocal notifyFacadeLocal = null;
    @EJB
    private NotificationAdministrationFacadeLocal notificationAdminFacade = null;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveOutFacadeLocal = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private ScanmanMsgFacadeLocal scanmanMsgFacade = null;
    private long infomanKeepaliveTimeout = 0L;
    @EJB
    private UserAdminFacadeLocal userFacade;
    @EJB
    private UseFacadeLocal useFacade = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    @EJB
    private UnitTreeFacadeLocal unitTreeFacade = null;
    @EJB
    private InfomanSetupFacadeLocal infomanSetupFacade = null;
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @EJB
    private StateOutFacadeLocal stateOutFacadeLocal = null;
    @EJB
    private GdataFacadeLocal gdataFacadeLocal = null;
    @EJB
    private MeasurementFacadeLocal measurementFacadeLocal = null;
    @EJB
    private FISMapFacadeLocal fisMapFacade = null;
    private int maxOfNotifyEvents = 500;
    private NotifyComparator comparator;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        long DEFAULT = 300L;
        long value = 300L;
        String para = this.configurationLocal.getParameter("infoman.keepalive.timeout", Long.toString(300L));
        try {
            value = Long.parseLong(para);
        }
        catch (Throwable ex) {
            log.error((Object)("Could not parse value for configuration key 'infoman.keepalive.timeout' into long. Value: '" + value + "'. Use default: " + 300L));
        }
        this.infomanKeepaliveTimeout = value * 60L * 1000L;
        this.comparator = new NotifyComparator();
    }

    @Override
    @Business(viewType="both")
    public HashSet<Long> getUnitPermissions(String username, boolean superAdmin, long unitGroupId) {
        String method = "getUnitPermissions(" + username + "): ";
        HashSet<Long> unitPermissions = null;
        if (superAdmin) {
            log.debug((Object)(method + "User is superadmin, fetching all permissions ..."));
            unitPermissions = this.permissionFastLaneReader.getAllUnitPermissions();
        } else {
            log.debug((Object)(method + "Fetching permissions ..."));
            Account account = this.userFacade.getAccountByUsername(username);
            if (account != null) {
                unitPermissions = this.permissionFastLaneReader.getUnitPermissions(account.getId());
            }
        }
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.debug((Object)(method + "User has no permissions."));
            return new HashSet<Long>();
        }
        if (unitGroupId != -1L) {
            log.debug((Object)(method + "Found the following permissions (without filtering for unitGroupId '" + unitGroupId + "'):" + unitPermissions));
            log.debug((Object)(method + "Filter now permissions for unitGroupId '" + unitGroupId + "' ..."));
            try {
                UnitTreeNode unitTree = this.unitTreeFacade.getAirportMapTreeModel(unitPermissions);
                if (unitTree != null) {
                    UnitTreeNode rootUnitNode = (UnitTreeNode)unitTree.getRoot();
                    UnitTreeNode unitGroupNode = this.findUnitGroupNode(rootUnitNode, unitGroupId);
                    if (unitGroupNode != null) {
                        rootUnitNode = unitGroupNode;
                    }
                    HashSet<Long> tmpUnitPermissions = new HashSet<Long>(unitPermissions);
                    for (Long unitId : unitPermissions) {
                        if (this.isUnitIdInGroup(rootUnitNode, unitId)) continue;
                        tmpUnitPermissions.remove(unitId);
                    }
                    unitPermissions = tmpUnitPermissions;
                }
                log.debug((Object)(method + "User has the following permissions (filtered for unitGroupId '" + unitGroupId + "'):" + unitPermissions));
            }
            catch (Exception ex) {
                log.error((Object)(method + "Could not filter for unitGroupId '" + unitGroupId + "', error while trying to get unit tree"), (Throwable)ex);
                log.debug((Object)(method + "User has now the following permissions:" + unitPermissions));
            }
        } else {
            log.debug((Object)(method + "User has the following permissions:" + unitPermissions));
        }
        return unitPermissions;
    }

    @Override
    @Business(viewType="both")
    public ConcurrentHashMap<String, Map<String, Object>> getOnlineStandsData() {
        ConcurrentHashMap<String, Map<String, Object>> allStands = new ConcurrentHashMap<String, Map<String, Object>>();
        List<StandStateCacheValue> standStateCacheValues = this.fisMapFacade.findAllStandStateCachesWithFlights();
        for (int i = 0; i < standStateCacheValues.size(); ++i) {
            StandStateCacheValue standEvent = standStateCacheValues.get(i);
            StandStateCacheValue.PK primaryKey = standEvent.getPk();
            String standId = "Stand_" + primaryKey.getStand();
            Map<String, Object> tmpStandMap = this.getStandEventMap(standEvent);
            Map<String, Object> standMap = allStands.get(standId);
            if (standMap == null) {
                standMap = new HashMap<String, Object>();
            }
            standMap.putAll(tmpStandMap);
            allStands.put(standId, standMap);
        }
        return allStands;
    }

    private Map<String, Object> getStandEventMap(StandStateCacheValue standEvent) {
        StandStateCacheValue.PK primaryKey = standEvent.getPk();
        long stateModelId = primaryKey.getStateModelId();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("fstd", "Stand_" + primaryKey.getStand());
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        stateMap.put("stateId", standEvent.getStateId());
        FISFlightValue inboundFlight = standEvent.getInbFlight();
        Map<String, Object> inboundFlightMap = this.getFlightMap(inboundFlight, true);
        FISFlightValue outboundFlight = standEvent.getOutbFlight();
        Map<String, Object> outboundFlightMap = this.getFlightMap(outboundFlight, false);
        stateMap.put("inbound", inboundFlightMap);
        stateMap.put("outbound", outboundFlightMap);
        String aircraftType = "";
        String registration = "";
        if (inboundFlight != null) {
            aircraftType = inboundFlight.getAircraftType();
            if (aircraftType == null) {
                aircraftType = "";
            }
            if ((registration = inboundFlight.getRegistration()) == null) {
                registration = "";
            }
            if (outboundFlight != null) {
                String tmpAircraftType = outboundFlight.getAircraftType();
                if (tmpAircraftType == null) {
                    tmpAircraftType = "";
                }
                if (aircraftType.trim().length() == 0) {
                    aircraftType = tmpAircraftType;
                } else if (tmpAircraftType.trim().length() != 0 && !tmpAircraftType.equals(aircraftType)) {
                    log.error((Object)("Different aircraft type in inbound and outbound flight! Inbound = '" + aircraftType + "' Outbound = '" + tmpAircraftType + "'. Assuming that inbound is correct ..."));
                }
                String tmpRegistration = outboundFlight.getRegistration();
                if (tmpRegistration == null) {
                    tmpRegistration = "";
                }
                if (registration.trim().length() == 0) {
                    registration = tmpRegistration;
                } else if (tmpRegistration.trim().length() != 0 && !tmpRegistration.equals(registration)) {
                    log.error((Object)("Different registration in inbound and outbound flight! Inbound = '" + registration + "' Outbound = '" + tmpRegistration + "'. Assuming that inbound is correct ..."));
                }
            }
        } else if (outboundFlight != null) {
            aircraftType = outboundFlight.getAircraftType();
            if (aircraftType == null) {
                aircraftType = "";
            }
            if ((registration = outboundFlight.getRegistration()) == null) {
                registration = "";
            }
        }
        stateMap.put("AircraftType", aircraftType);
        stateMap.put("reg", registration);
        valueMap.put("StateModel_" + stateModelId, stateMap);
        return valueMap;
    }

    private Map<String, Object> getFlightMap(FISFlightValue flightEvent, boolean inbound) {
        long bestTime = 0L;
        long estimatedTime = 0L;
        long scheduledTime = 0L;
        long onOffBlock = 0L;
        String flightNumber = "";
        String flightType = "";
        String movementType = "";
        String origin = "";
        String destination = "";
        if (flightEvent != null) {
            bestTime = flightEvent.getBestTime();
            estimatedTime = flightEvent.getEstimatedTime();
            scheduledTime = flightEvent.getScheduledTime();
            onOffBlock = flightEvent.getOnOffBlockTime();
            flightNumber = flightEvent.getFlightNumber();
            if (flightNumber == null) {
                flightNumber = "";
            }
            if ((flightType = flightEvent.getFlightNature()) == null) {
                flightType = "";
            }
            if ((movementType = flightEvent.getMovementType()) == null) {
                movementType = "";
            }
            if ((origin = flightEvent.getOrigin()) == null) {
                origin = "";
            }
            if ((destination = flightEvent.getDestination()) == null) {
                destination = "";
            }
        }
        HashMap<String, Object> flightMap = new HashMap<String, Object>();
        flightMap.put("flightNo", flightNumber);
        flightMap.put("flightType", flightType);
        flightMap.put("movementType", movementType);
        flightMap.put("estimatedTime", estimatedTime);
        flightMap.put("scheduledTime", scheduledTime);
        flightMap.put("oBlock", onOffBlock);
        if (inbound) {
            flightMap.put("origin", origin);
            flightMap.put("starttime", bestTime);
        } else {
            flightMap.put("destination", destination);
            flightMap.put("endtime", bestTime);
        }
        return flightMap;
    }

    @Override
    @Business(viewType="both")
    public ConcurrentHashMap<Long, Map<String, Object>> getOnlineUnitData() {
        String method = "getOnlineMapData(): ";
        ConcurrentHashMap<Long, Map<String, Object>> allStamps = new ConcurrentHashMap<Long, Map<String, Object>>();
        Map<Long, UnitIdentity> unitIdentities = this.getAllUnitIdentities();
        long startTime = System.currentTimeMillis() - 86400000L;
        List<NotifyHistory> notifiesList = this.notifyFacadeLocal.findAllOlderThanGivenTimestamp(startTime);
        Map<Long, List<NotifyHistory>> notifyEvents = this.getAllNotifyEvents(notifiesList);
        Map<Long, Notification> notifyMessages = this.getAllNotifyMessages();
        Map<Long, KeepAliveCache> currentKeepAlives = this.getAllKeepAliveCache();
        Map<Long, UseCache> currentUseEvents = this.getAllUseCache();
        Map<Long, UseUser> useUsers = this.getAllUsers();
        Collection<ScanmanMsgCache> scanmanMsgList = this.scanmanMsgFacade.findCacheAll();
        Map<Long, Map<Integer, ScanmanMsgCache>> scanManMessages = this.getAllScanmanMessages(scanmanMsgList);
        Map<Long, InfomanSetup> currentInfomanSetups = this.getAllCurrentInfomanSetups();
        Map<Long, GdataCache> currentGdatas = this.getAllCurrentGdataCache();
        List<StateCache> stateCacheList = this.stateOutFacadeLocal.findAllCaches();
        Map<Long, Map<Integer, StateCache>> currentStateEvents = this.getAllCurrentStates(stateCacheList);
        Map<Long, Map<Integer, MeasurementCache>> currentMeasurements = this.getAllCurrentMeasurements();
        Iterator<Long> ite = unitIdentities.keySet().iterator();
        while (ite.hasNext()) {
            Map<String, Object> geoEvent;
            GdataCache currentGdata;
            Map<String, Object> measurementEvents;
            Map<String, Object> stateEvents;
            TreeMap<String, Map> notifies;
            Map<String, Object> useEvent;
            HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
            long unitID = ite.next();
            Map<String, Object> scanmanMessageEvents = this.getScanmanMessagesForUnit(unitID, scanManMessages);
            if (!scanmanMessageEvents.isEmpty()) {
                mapClientStamp.putAll(scanmanMessageEvents);
            }
            InfomanSetup infomanSetup = currentInfomanSetups.get(unitID);
            Map<String, Object> infomanSetupMap = this.getCurrentInfomanSetupForUnit(unitID, infomanSetup);
            mapClientStamp.putAll(infomanSetupMap);
            KeepAliveCache currentKeepAlive = currentKeepAlives.get(unitID);
            Map<String, Object> keepAliveEvent = this.getKeepAliveForUnit(unitID, currentKeepAlive);
            mapClientStamp.putAll(keepAliveEvent);
            UseCache useCache = currentUseEvents.get(unitID);
            if (useCache != null && (useEvent = this.getUseEvent(useCache, useUsers)) != null) {
                mapClientStamp.putAll(useEvent);
            }
            if ((notifies = this.getNotifyMessages(unitID, notifyEvents, notifyMessages)) != null) {
                mapClientStamp.put("NotifyEvents", notifies);
            }
            if (!(stateEvents = this.getStatesForUnit(unitID, currentStateEvents)).isEmpty()) {
                mapClientStamp.putAll(stateEvents);
            }
            if (!(measurementEvents = this.getMeasurementsForUnit(unitID, currentMeasurements)).isEmpty()) {
                mapClientStamp.putAll(measurementEvents);
            }
            if ((currentGdata = currentGdatas.get(unitID)) != null && !(geoEvent = this.getGeoEventForUnit(currentGdata)).isEmpty()) {
                mapClientStamp.putAll(geoEvent);
            }
            UnitIdentity unitIdentity = unitIdentities.get(unitID);
            try {
                Map<String, Object> basicData = this.getBasicGSEData(unitIdentity);
                mapClientStamp.putAll(basicData);
            }
            catch (NoAirportMapUnitException ex) {
                log.error((Object)("Could not get basic data for unit with ID: " + unitID), (Throwable)ex);
                continue;
            }
            allStamps.put(unitID, mapClientStamp);
        }
        return allStamps;
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode, long unitGroupId) {
        List children;
        if (unitNode == null) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModel unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModel();
        long unitId = unitModelValue.getUnitId();
        if (unitId == unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode, unitGroupId);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private boolean isUnitIdInGroup(UnitTreeNode unitNode, long unitId) {
        List children;
        boolean ret = false;
        if (unitNode == null) {
            return ret;
        }
        UnitModel unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModel();
        long thisUnitId = unitModelValue.getUnitId();
        if (thisUnitId == unitId) {
            ret = true;
            return ret;
        }
        if (!unitModelValue.getBasic() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.isUnitIdInGroup(childUnitNode, unitId);
                if (!ret) continue;
                return ret;
            }
        }
        return ret;
    }

    private Map<Long, Map<Integer, StateCache>> getAllCurrentStates(Collection<StateCache> stateCache) {
        HashMap<Long, Map<Integer, StateCache>> states = new HashMap<Long, Map<Integer, StateCache>>();
        if (stateCache != null) {
            for (StateCache value : stateCache) {
                long unitId = value.getUnitId();
                HashMap<Integer, StateCache> msgs = (HashMap<Integer, StateCache>)states.get(unitId);
                if (msgs == null) {
                    msgs = new HashMap<Integer, StateCache>();
                }
                msgs.put(value.getStateModelId(), value);
                states.put(unitId, msgs);
            }
        }
        return states;
    }

    private Map<Long, InfomanSetup> getAllCurrentInfomanSetups() {
        HashMap<Long, InfomanSetup> infomanSetups = new HashMap<Long, InfomanSetup>();
        List<InfomanSetup> col = this.infomanSetupFacade.getAllCurrentInfomanSetups();
        for (InfomanSetup value : col) {
            infomanSetups.put(value.getUnitId(), value);
        }
        return infomanSetups;
    }

    private Map<Long, GdataCache> getAllCurrentGdataCache() {
        HashMap<Long, GdataCache> gdatas = new HashMap<Long, GdataCache>();
        List<GdataCache> col = this.gdataFacadeLocal.findCacheAll();
        for (GdataCache value : col) {
            gdatas.put(value.getUnitId(), value);
        }
        return gdatas;
    }

    private Map<Long, Map<Integer, MeasurementCache>> getAllCurrentMeasurements() {
        HashMap<Long, Map<Integer, MeasurementCache>> measurements = new HashMap<Long, Map<Integer, MeasurementCache>>();
        List<MeasurementCache> measurementCacheList = this.measurementFacadeLocal.getMeasurementCache();
        if (measurementCacheList == null) {
            return measurements;
        }
        for (MeasurementCache value : measurementCacheList) {
            long unitId = value.getUnitId();
            HashMap<Integer, MeasurementCache> measurementsOfUnit = (HashMap<Integer, MeasurementCache>)measurements.get(unitId);
            if (measurementsOfUnit == null) {
                measurementsOfUnit = new HashMap<Integer, MeasurementCache>();
            }
            measurementsOfUnit.put(value.getMeasurementDefinitionId(), value);
            measurements.put(unitId, measurementsOfUnit);
        }
        return measurements;
    }

    private Map<Long, UseCache> getAllUseCache() {
        HashMap<Long, UseCache> useEvents = new HashMap<Long, UseCache>();
        List<UseCache> allUseCacheCol = this.useFacade.findAllUseCache();
        for (UseCache value : allUseCacheCol) {
            if (value == null) continue;
            useEvents.put(value.getUnitId(), value);
        }
        return useEvents;
    }

    private Map<Long, UseUser> getAllUsers() {
        HashMap<Long, UseUser> useEvents = new HashMap<Long, UseUser>();
        List<UseUser> allUseCacheCol = this.useUserAdminFacade.getAllUseUsersIncludeDeleted();
        for (UseUser value : allUseCacheCol) {
            if (value == null || value.getDeleted()) continue;
            useEvents.put(value.getId(), value);
        }
        return useEvents;
    }

    private Map<Long, KeepAliveCache> getAllKeepAliveCache() {
        String method = "getAllKeepAliveCache(): ";
        HashMap<Long, KeepAliveCache> alives = new HashMap<Long, KeepAliveCache>();
        Collection<KeepAliveCache> col = this.keepAliveOutFacadeLocal.findAll();
        for (KeepAliveCache keepAliveCache : col) {
            alives.put(keepAliveCache.getUnitId(), keepAliveCache);
        }
        return alives;
    }

    private Map<Long, UnitIdentity> getAllUnitIdentities() {
        String method = "getAllUnitIdentities(): ";
        HashMap<Long, UnitIdentity> identities = new HashMap<Long, UnitIdentity>();
        List<UnitIdentity> col = this.unitFacade.findAllIncludingDeleted();
        for (UnitIdentity value : col) {
            identities.put(value.getUnitId(), value);
        }
        return identities;
    }

    private Map<Long, Map<Integer, ScanmanMsgCache>> getAllScanmanMessages(Collection<ScanmanMsgCache> scanmanMsgCache) {
        String method = "getScanmanMessages(): ";
        HashMap<Long, Map<Integer, ScanmanMsgCache>> messages = new HashMap<Long, Map<Integer, ScanmanMsgCache>>();
        for (ScanmanMsgCache value : scanmanMsgCache) {
            long unitId = value.getUnitId();
            HashMap<Integer, ScanmanMsgCache> msgs = (HashMap<Integer, ScanmanMsgCache>)messages.get(unitId);
            if (msgs == null) {
                msgs = new HashMap<Integer, ScanmanMsgCache>();
            }
            msgs.put(value.getType(), value);
            messages.put(unitId, msgs);
        }
        return messages;
    }

    private Map<Long, Notification> getAllNotifyMessages() {
        String method = "getAllNotifyMessages(): ";
        HashMap<Long, Notification> messages = new HashMap<Long, Notification>();
        List<Notification> col = this.notificationAdminFacade.getAllNotifications();
        for (Notification value : col) {
            messages.put(value.getId(), value);
        }
        return messages;
    }

    private Map<Long, List<NotifyHistory>> getAllNotifyEvents(Collection<NotifyHistory> notifyHistory) {
        String method = "getAllNotifyEvents(): ";
        HashMap<Long, List<NotifyHistory>> notifies = new HashMap<Long, List<NotifyHistory>>();
        for (NotifyHistory value : notifyHistory) {
            long unitId = value.getUnitId();
            ArrayList<NotifyHistory> notifyList = (ArrayList<NotifyHistory>)notifies.get(unitId);
            if (notifyList == null) {
                notifyList = new ArrayList<NotifyHistory>();
            }
            notifyList.add(value);
            notifies.put(unitId, notifyList);
        }
        this.limitAmountOfNotifies(notifies);
        return notifies;
    }

    private void limitAmountOfNotifies(Map<Long, List<NotifyHistory>> notifies) {
        if (this.configurationLocal.isConfigured("observable.notifies.maximumPerUnitPerDay")) {
            try {
                this.maxOfNotifyEvents = this.configurationLocal.getInteger("observable.notifies.maximumPerUnitPerDay");
            }
            catch (Throwable ex) {
                log.error((Object)"Could not get property \"observable.notifies.maximumPerUnitPerDay\"", ex);
            }
        }
        for (List<NotifyHistory> tmp : notifies.values()) {
            if (tmp.size() <= this.maxOfNotifyEvents) continue;
            Collections.sort(tmp, this.comparator);
            if (tmp.size() < 1) continue;
            tmp.subList(this.maxOfNotifyEvents, tmp.size()).clear();
        }
    }

    @Override
    @Business(viewType="both")
    public Map<String, Object> getUnitData(long unitID, boolean infomanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded) throws NoAirportMapUnitException {
        Map<String, Object> geoEvent;
        GdataCache currentGdata;
        String method = "getUnitData(): ";
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        if (infomanMessagesNeeded) {
            Collection<ScanmanMsgCache> scanmanMsgList = this.scanmanMsgFacade.findCacheByUnit(unitID);
            Map<Long, Map<Integer, ScanmanMsgCache>> scanManMessages = this.getAllScanmanMessages(scanmanMsgList);
            Map<String, Object> scanmanMessageEvents = this.getScanmanMessagesForUnit(unitID, scanManMessages);
            if (!scanmanMessageEvents.isEmpty()) {
                mapClientStamp.putAll(scanmanMessageEvents);
            }
            InfomanSetup infomanSetup = null;
            try {
                infomanSetup = this.infomanSetupFacade.getCurrentInfomanSetup(unitID);
            }
            catch (ObjectNotFoundException ex) {
                // empty catch block
            }
            Map<String, Object> infomanSetupMap = this.getCurrentInfomanSetupForUnit(unitID, infomanSetup);
            mapClientStamp.putAll(infomanSetupMap);
        }
        if (useMessagesNeeded) {
            Map<String, Object> useEvent;
            Map<Long, UseUser> useUsers = this.getAllUsers();
            UseCache useCache = this.useFacade.findByUnitId(unitID);
            if (useCache != null && (useEvent = this.getUseEvent(useCache, useUsers)) != null) {
                mapClientStamp.putAll(useEvent);
            }
        }
        if (notifyMessagesNeeded) {
            Map<Long, Notification> notifyMessages = this.getAllNotifyMessages();
            long startTime = System.currentTimeMillis() - 86400000L;
            List<NotifyHistory> notifyHistory = this.notifyFacadeLocal.findNotifyHistoryAllOlderThanGivenTimestampByUnitId(unitID, startTime);
            Map<Long, List<NotifyHistory>> notifyEvents = this.getAllNotifyEvents(notifyHistory);
            TreeMap<String, Map> notifies = this.getNotifyMessages(unitID, notifyEvents, notifyMessages);
            if (notifies != null) {
                mapClientStamp.put("NotifyEvents", notifies);
            }
        }
        KeepAliveCache currentKeepAlive = this.keepAliveOutFacadeLocal.findByUnitId(unitID);
        Map<String, Object> keepAliveEvent = this.getKeepAliveForUnit(unitID, currentKeepAlive);
        mapClientStamp.putAll(keepAliveEvent);
        List<StateCache> stateCache = this.stateOutFacadeLocal.findByUnitId(unitID);
        Map<Long, Map<Integer, StateCache>> currentStateEvents = this.getAllCurrentStates(stateCache);
        Map<String, Object> stateEvents = this.getStatesForUnit(unitID, currentStateEvents);
        if (!stateEvents.isEmpty()) {
            mapClientStamp.putAll(stateEvents);
        }
        if ((currentGdata = this.gdataFacadeLocal.findCacheByUnitId(unitID)) != null && !(geoEvent = this.getGeoEventForUnit(currentGdata)).isEmpty()) {
            mapClientStamp.putAll(geoEvent);
        }
        UnitIdentity unitIdentity = this.unitFacade.getUnitIdentity(unitID);
        Map<String, Object> basicData = this.getBasicGSEData(unitIdentity);
        mapClientStamp.putAll(basicData);
        return mapClientStamp;
    }

    private Map<String, Object> getBasicGSEData(UnitIdentity unitIdentity) throws NoAirportMapUnitException {
        if (unitIdentity == null) {
            throw new NoAirportMapUnitException();
        }
        long unitID = unitIdentity.getUnitId();
        UnitModel unitModel = null;
        UnitTypeIdentity unitTypeIdentityValue = null;
        String unitTypeName = null;
        String unitSymbolName = null;
        boolean airportMapFlag = false;
        boolean deletedMapFlag = false;
        try {
            unitModel = unitIdentity.getUnitModel();
        }
        catch (Throwable ex) {
            log.error((Object)("Could not get UnitModel for unit with unitId '" + unitID + "'!"));
            throw new NoAirportMapUnitException();
        }
        try {
            airportMapFlag = unitModel.getAirportmapVisible();
        }
        catch (Throwable ex) {
            log.error((Object)("Could not determine airport map visible flag for unit with unitId '" + unitID + "'!"));
        }
        try {
            deletedMapFlag = unitModel.getDeleted();
        }
        catch (Throwable ex) {
            log.error((Object)("Could not determine deleted unit flag for unit with unitId '" + unitID + "'!"));
        }
        try {
            unitTypeIdentityValue = unitModel.getUnitTypeIdentity();
        }
        catch (Throwable ex) {
            log.error((Object)("No unit type identity for unit with unitId '" + unitID + "' found!"));
        }
        if (unitTypeIdentityValue != null) {
            String tmp = unitTypeIdentityValue.getImageType().getName();
            if (tmp != null && tmp.trim().length() > 0) {
                unitSymbolName = tmp;
            }
            if ((tmp = unitTypeIdentityValue.getName()) != null && tmp.trim().length() > 0) {
                unitTypeName = tmp;
            }
        }
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        mapClientStamp.put("UnitId", unitID);
        mapClientStamp.put("UnitType", unitTypeName);
        mapClientStamp.put("UnitKind", unitSymbolName);
        mapClientStamp.put("UnitName", unitIdentity.getName());
        mapClientStamp.put("UnitAirportMapFlag", airportMapFlag);
        mapClientStamp.put("UnitDeletedFlag", deletedMapFlag);
        return mapClientStamp;
    }

    private Area getArea(GdataCache currentGdata) {
        Area area = currentGdata.getArea();
        if (area == null) {
            log.trace((Object)("Empty area in CURRENT_GDATA_CACHE for unitId '" + currentGdata.getUnitId() + "'. Seems like GSE is out of space."));
            area = new Area();
            area.setArea("-");
            area.setDescription("(not defined)");
            area.setPriority(0);
        }
        return area;
    }

    private Map<String, Object> getScanmanMessagesForUnit(long unitID, Map<Long, Map<Integer, ScanmanMsgCache>> scanManMessages) {
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        ScanmanMsgBase lastIPMessage = null;
        ScanmanMsgBase lastBootMessage = null;
        ScanmanMsgCache lastErrorMessage = null;
        Map<Integer, ScanmanMsgCache> msgs = scanManMessages.get(unitID);
        if (msgs != null) {
            lastErrorMessage = msgs.get(9);
            lastIPMessage = msgs.get(10);
            lastBootMessage = msgs.get(25);
        }
        if (lastBootMessage != null) {
            mapClientStamp.put("SmBootTimestamp", lastBootMessage.getCreateTime());
            mapClientStamp.put("SmBootMessage", lastBootMessage.getMessage());
        }
        if (lastIPMessage != null) {
            mapClientStamp.put("SmIpTimestamp", lastIPMessage.getCreateTime());
            mapClientStamp.put("SmIpMessage", lastIPMessage.getMessage());
        }
        if (lastErrorMessage != null) {
            mapClientStamp.put("SmErrorTimestamp", lastErrorMessage.getCreateTime());
            mapClientStamp.put("SmErrorMessage", lastErrorMessage.getMessage());
        }
        return mapClientStamp;
    }

    private Map<String, Object> getKeepAliveForUnit(long unitID, KeepAliveCache currentKeepAlive) {
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        boolean currentKeepAliveTimeout = false;
        if (currentKeepAlive == null) {
            currentKeepAlive = new KeepAliveCache();
            currentKeepAlive.setUnitId(unitID);
            currentKeepAlive.setReceiveTime(0L);
            currentKeepAlive.setCreateTime(0L);
            currentKeepAliveTimeout = false;
        } else if (System.currentTimeMillis() - currentKeepAlive.getCreateTime() > this.infomanKeepaliveTimeout) {
            currentKeepAliveTimeout = true;
        }
        mapClientStamp.put("KeepaliveTimestamp", currentKeepAlive.getCreateTime());
        mapClientStamp.put("KeepaliveTimeout", currentKeepAliveTimeout);
        return mapClientStamp;
    }

    private Map<String, Object> getCurrentInfomanSetupForUnit(long unitID, InfomanSetup infomanSetup) {
        String method = "getCurrentInfomanSetupForUnit(): ";
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        String configName = "";
        boolean configUpToDate = false;
        String hardware = "";
        String hardwareSN = "";
        String infomanSN = "";
        String javaVMVersion = "";
        String kernelVersion = "";
        String pmVersion = "";
        String rootFSVersion = "";
        String swVersion = "";
        if (infomanSetup != null) {
            configName = infomanSetup.getConfigurationName();
            configUpToDate = infomanSetup.getConfigurationUpToDate();
            hardware = infomanSetup.getHardware();
            hardwareSN = infomanSetup.getHardwareSn();
            infomanSN = infomanSetup.getInfomanSn();
            javaVMVersion = infomanSetup.getJavaVmVersion();
            kernelVersion = infomanSetup.getKernelVersion();
            pmVersion = infomanSetup.getPowerManagementVersion();
            rootFSVersion = infomanSetup.getRootfsVersion();
            swVersion = infomanSetup.getSoftwareVersion();
        }
        mapClientStamp.put("infomanConfigurationName", configName);
        mapClientStamp.put("infomanConfigurationUpToDate", configUpToDate);
        mapClientStamp.put("infomanHardware", hardware);
        mapClientStamp.put("infomanHardwareSN", hardwareSN);
        mapClientStamp.put("infomanInfomanSN", infomanSN);
        mapClientStamp.put("infomanJavaVMVersion", javaVMVersion);
        mapClientStamp.put("infomanKernelVersion", kernelVersion);
        mapClientStamp.put("infomanPMVersion", pmVersion);
        mapClientStamp.put("infomanRootFSVersion", rootFSVersion);
        mapClientStamp.put("infomanSoftwareVersion", swVersion);
        return mapClientStamp;
    }

    private Map<String, Object> getGeoEventForUnit(GdataCache currentGdata) {
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        if (currentGdata != null) {
            mapClientStamp.put("GeoBegin", currentGdata.getBeginTime());
            mapClientStamp.put("GpsGga", currentGdata.getGgaRec());
            mapClientStamp.put("GpsRmc", currentGdata.getRmcRec());
            mapClientStamp.put("GpsTrusted", currentGdata.getTrusted());
            mapClientStamp.put("GpsLatMsec", currentGdata.getLatMsec());
            mapClientStamp.put("GpsLongMsec", currentGdata.getLongMsec());
            Area area = this.getArea(currentGdata);
            mapClientStamp.put("Area", area.getArea());
            mapClientStamp.put("AreaName", area.getDescription());
        }
        return mapClientStamp;
    }

    private Map<String, Object> getMeasurementsForUnit(long unitId, Map<Long, Map<Integer, MeasurementCache>> currentMeasurements) {
        String methodName = "getMeasurementsForUnit(): ";
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        if (currentMeasurements == null) {
            return mapClientStamp;
        }
        Map<Integer, MeasurementCache> measurementDefnIds = currentMeasurements.get(unitId);
        if (measurementDefnIds == null) {
            return mapClientStamp;
        }
        for (int measurementDefnId : measurementDefnIds.keySet()) {
            MeasurementCache measurement = measurementDefnIds.get(measurementDefnId);
            HashMap<String, Number> measurementMap = new HashMap<String, Number>();
            measurementMap.put("MeasurementValue", Float.valueOf(measurement.getValue()));
            measurementMap.put("MeasurementBegin", measurement.getBeginTime());
            mapClientStamp.put("Measurement_" + measurementDefnId, measurementMap);
        }
        return mapClientStamp;
    }

    private Map<String, Object> getUseEvent(UseCache useEvent, Map<Long, UseUser> useUsers) {
        Long userId = useEvent.getUseUserId();
        if (userId != null) {
            UseUser useUserValue = useUsers.get(userId);
            if (useUserValue != null) {
                HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
                mapClientStamp.put("UseEventTimestamp", useEvent.getBeginTime());
                mapClientStamp.put("UseEventLogin", true);
                mapClientStamp.put("UseEventReceiveTime", useEvent.getBeginReceiveTime());
                mapClientStamp.put("UseEventUserKey", useUserValue.getKeyId());
                mapClientStamp.put("UseEventDriverName", useUserValue.getName());
                mapClientStamp.put("UseEventPersonalNumber", useUserValue.getPersonalNumber());
                return mapClientStamp;
            }
            log.error((Object)("getUseEvent(): User with id '" + userId + "' not found, will not add login event for unit with id '" + useEvent.getUnitId() + "'"));
        } else {
            log.info((Object)("getUseEvent(): User in UseEvent with id '" + useEvent.getPrimaryKey() + "' was null, will not add login event for unit with id '" + useEvent.getUnitId() + "'"));
        }
        return null;
    }

    private TreeMap<String, Map> getNotifyMessages(Long uid, Map<Long, List<NotifyHistory>> notifyEvents, Map<Long, Notification> notifyMessages) {
        TreeMap notifyMap = null;
        Collection notifys = notifyEvents.get(uid);
        if (notifys != null) {
            notifyMap = new TreeMap();
            for (NotifyHistory nhv : notifys) {
                long timestamp = nhv.getCreateTime();
                long messageId = nhv.getMessageId();
                Notification value = notifyMessages.get(messageId);
                String message = "";
                if (value != null) {
                    message = value.getDefaultName();
                }
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put("UnitId", nhv.getUnitId());
                valueMap.put("NotifyMessageID", messageId);
                valueMap.put("NotifyMessage", message);
                valueMap.put("NotifyEntry", nhv.getEntry());
                valueMap.put("NotifyTimestamp", timestamp);
                valueMap.put("NotifyReceiveTime", nhv.getReceiveTime());
                notifyMap.put(timestamp + "_" + messageId, valueMap);
            }
        }
        return notifyMap;
    }

    private Map<String, Object> getStatesForUnit(long unitId, Map<Long, Map<Integer, StateCache>> currentStateEvents) {
        Map<Integer, StateCache> stateModels;
        String methodName = "getStatesForUnit(): ";
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        if (currentStateEvents != null && (stateModels = currentStateEvents.get(unitId)) != null) {
            for (int stateModel : stateModels.keySet()) {
                StateCache state = stateModels.get(stateModel);
                HashMap<String, Object> stateMap = new HashMap<String, Object>();
                stateMap.put("StateId", state.getStateId());
                stateMap.put("StateBegin", state.getBeginTime());
                stateMap.put("StateRemark", state.getRemark());
                mapClientStamp.put("StateModel_" + state.getStateModelId(), stateMap);
            }
        }
        return mapClientStamp;
    }

    private class NotifyComparator
    implements Comparator {
        private NotifyComparator() {
        }

        @Business(viewType="local")
        public int compare(Object o1, Object o2) {
            int value = 0;
            value = ((NotifyHistory)o1).getCreateTime() == ((NotifyHistory)o2).getCreateTime() ? 0 : (((NotifyHistory)o1).getCreateTime() < ((NotifyHistory)o2).getCreateTime() ? 1 : -1);
            return value;
        }
    }
}

