/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.audit;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.audit.Auditdata;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.logic.ejb.dataOut.audit.ActionType;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditInfo;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditUtil;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataDAO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="AuditFacade")
@Remote(value={AuditFacadeRemote.class})
@Local(value={AuditFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/AuditFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/AuditFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class AuditFacadeBean
implements AuditFacadeLocal,
AuditFacadeRemote {
    private static final Log log = LogFactory.getLog(AuditFacadeBean.class);
    private static final String CONFIG_PARAM_AUDIT_TRAIL = "auditdata.activated";
    private static final String FILTER_OUT_SUPERADMIN = "filterOutSuperadmin";
    private boolean auditEnabled = false;
    private boolean filterOutSuperadmin = false;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager;
    private AuditdataDAO auditdataDAO = null;
    private UserAdminFacadeLocal userAdminFacadeLocal = null;
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @Resource
    private SessionContext sessionContext;

    @PostConstruct
    public void ejbCreate() {
        try {
            this.auditdataDAO = AuditdataDAO.newInstance(this.entityManager);
            String param = this.configurationLocal.getParameter(CONFIG_PARAM_AUDIT_TRAIL);
            if (param.length() > 0) {
                this.auditEnabled = Boolean.parseBoolean(param);
            }
            if ((param = this.configurationLocal.getParameter(FILTER_OUT_SUPERADMIN)).length() > 0) {
                this.filterOutSuperadmin = Boolean.parseBoolean(param);
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"parameter for auditdata missed, changes wont be logged into auditdata");
        }
    }

    private UserAdminFacadeLocal getUserAdminFacadeLocal() {
        if (this.userAdminFacadeLocal == null) {
            try {
                InitialContext context = new InitialContext();
                this.userAdminFacadeLocal = (UserAdminFacadeLocal)context.lookup("rts/UserAdminFacade/local");
                return this.userAdminFacadeLocal;
            }
            catch (NamingException e) {
                log.error((Object)"Runs into", (Throwable)e);
            }
        }
        return this.userAdminFacadeLocal;
    }

    @Override
    @Business(viewType="both")
    public boolean isAuditTrail() {
        return this.auditEnabled;
    }

    @Override
    @Business(viewType="local")
    public <T extends EntityBase> void logInsert(ModuleType applicationType, T newObject) {
        this.logUpdate(applicationType, null, newObject);
    }

    @Override
    @Business(viewType="local")
    public <T extends EntityBase> void logDelete(ModuleType applicationType, T oldObject) {
        this.logUpdate(applicationType, oldObject, null);
    }

    @Override
    @Business(viewType="local")
    public <T extends EntityBase> void logUpdate(ModuleType applicationType, T oldObject, T newObject) {
        if (oldObject == null && newObject == null) {
            throw new IllegalArgumentException("oldObject and newObject cannot both be null!");
        }
        AuditInfo auditInfo = AuditUtil.generateAuditInfo(oldObject, newObject);
        if (!auditInfo.hasChanges()) {
            return;
        }
        ActionType action = ActionType.Update;
        if (oldObject != null && newObject == null) {
            action = ActionType.Delete;
        } else if (oldObject == null && newObject != null) {
            action = ActionType.Insert;
        }
        T dataObject = oldObject != null ? oldObject : newObject;
        this.logEvent(applicationType, action, dataObject.getClass().getSimpleName(), dataObject.toAuditString(), auditInfo.toString());
    }

    @Override
    @Business(viewType="local")
    public void logEvent(ModuleType applicationType, ActionType action, String entityName, String primaryKey, String changes) {
        this.logEvent(applicationType, action, entityName, primaryKey, changes, null);
    }

    private void logEvent(ModuleType applicationType, ActionType action, String entityName, String primaryKey, String changes, String username) {
        Auditdata auditdata = new Auditdata();
        auditdata.setPkModifiedRecord(primaryKey);
        auditdata.setChanges(changes);
        auditdata.setCreateTime(System.currentTimeMillis());
        auditdata.setModuleId(applicationType.getValue());
        auditdata.setActionType(action);
        auditdata.setModifiedEntity(entityName);
        String user = "";
        try {
            user = username == null ? this.sessionContext.getCallerPrincipal().getName() : username;
        }
        catch (Exception ex) {
            // empty catch block
        }
        Account account = this.getUserAdminFacadeLocal().getAccountByUsername(user);
        auditdata.setUser(account);
        if (action == ActionType.FailedLogin && account == null) {
            return;
        }
        this.auditdataDAO.createEntity(auditdata);
    }

    @Override
    @Business(viewType="both")
    public void logSystemAccess(ModuleType application, ActionType action, String username) {
        if (action != ActionType.Login && action != ActionType.Logout && action != ActionType.FailedLogin) {
            throw new IllegalArgumentException("Action passed to logSystemAccess() must be login, logout or failed login!");
        }
        this.logEvent(application, action, "SystemAccess", username, null, username);
    }

    @Override
    @Business(viewType="both")
    public List<Auditdata> getLog(long begin, long end) {
        List<Auditdata> list = this.auditdataDAO.findNonSystemAccessByInterval(begin, end);
        return this.filterOutSuperadmin ? this.filterSuperadmin(list) : list;
    }

    @Override
    @Business(viewType="both")
    public List<Auditdata> getSystemAccessLog(long begin, long end) {
        List<Auditdata> list = this.auditdataDAO.findSystemAccessByInterval(begin, end);
        return this.filterOutSuperadmin ? this.filterSuperadmin(list) : list;
    }

    private List<Auditdata> filterSuperadmin(List<Auditdata> auditLog) {
        ArrayList<Auditdata> list = new ArrayList<Auditdata>();
        int size = auditLog.size();
        for (int i = 0; i != size; ++i) {
            Auditdata auditdata = auditLog.get(i);
            if (!this.sessionContext.isCallerInRole("superadmin") && auditdata.getUser() == null) continue;
            list.add(auditdata);
        }
        return list;
    }
}

