/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.use;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.use.UseCacheDAO;
import de.proveo.wwt.logic.ejb.dataIn.use.UseHistoryDAO;
import de.proveo.wwt.logic.ejb.dataIn.use.UseOutFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseOutFacadeRemote;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UserNotFoundException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="UseOutFacade")
@Remote(value={UseOutFacadeRemote.class})
@Local(value={UseOutFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UseOutFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UseOutFacade")
public class UseOutFacadeBean
implements UseOutFacadeLocal,
UseOutFacadeRemote {
    private static final Log log = LogFactory.getLog(UseOutFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    @EJB
    private UseUserGroupAdminFacadeLocal useUserGroupAdminFacade = null;
    private UseCacheDAO useCacheDAO = null;
    private UseHistoryDAO useHistoryDAO = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        try {
            this.useCacheDAO = UseCacheDAO.newInstance(this.entityManager);
            this.useHistoryDAO = UseHistoryDAO.newInstance(this.entityManager);
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    protected UseUser getUser(long userId) throws UserNotFoundException {
        try {
            return this.useUserAdminFacade.getUseUserById(userId);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for ID '" + userId + "' runs into " + ex.getMessage());
        }
    }

    protected UseGroup getGroup(long groupId) throws GroupNotFoundException {
        try {
            return this.useUserGroupAdminFacade.getUseGroupById(groupId);
        }
        catch (Exception ex) {
            throw new GroupNotFoundException("getGroup for " + groupId + " runs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public List<UseHistory> findAllByTimeOrderByUnitAndBegin(long beginTime, long endTime) {
        return this.useHistoryDAO.findUseHistoryByTimeOrderByUnitAndBegin(beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public List<UseHistory> findUseHistoryByUnitGroupIdOrderByUnitAndBegin(long unitGroupId, long beginTime, long endTime) {
        return this.useHistoryDAO.findUseHistoryByUnitGroupIdOrderByUnitAndBegin(unitGroupId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public List<UseHistory> findUseHistoryByUnitIdOrderByBegin(long unitId, long beginTime, long endTime) {
        return this.useHistoryDAO.findUseHistoryByUnitIdOrderByBegin(unitId, beginTime, endTime);
    }

    @Override
    @Business(viewType="both")
    public List<UseHistory> findUseHistoryByUnitIdAndUseUserGroupId(long unitId, long beginTime, long endTime, long useUserGroupId) {
        return this.useHistoryDAO.findUseHistoryByUnitIdOrderByBegin(unitId, beginTime, useUserGroupId);
    }

    @Override
    @Business(viewType="both")
    public List<UseCache> findAllUseCaches() {
        return this.useCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public UseCache findUseCachesByUnitId(long unitId) {
        return this.useCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public List<UseCache> findUseCachesByUnitGroupId(long unitGroupId) {
        return this.useCacheDAO.findByUnitGroupId(unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public List<UseCache> findUseCachesByUnitGroupIdAndUseUserId(long unitGroupId, long useUserGroupId) {
        return this.useCacheDAO.findByUnitGroupIdAndUseUserId(unitGroupId, unitGroupId);
    }

    @Override
    @Business(viewType="both")
    public UseCache findUseCacheByUnitId(long unitId) {
        return this.useCacheDAO.findByUnitId(unitId);
    }

    @Override
    @Business(viewType="both")
    public UseCache findUseCachesByUnitIdAndUseUserId(long unitId, long useUserId) {
        return this.useCacheDAO.findByUnitIdAndUseUserId(unitId, useUserId);
    }

    @Override
    @Business(viewType="both")
    public List<UseCache> findUseCachesByUserId(long useUserId) {
        return this.useCacheDAO.findByUserId(useUserId);
    }

    @Override
    @Business(viewType="both")
    public void removeUseCacheFromUnit(long unitId) {
        UseCache useCache = this.useCacheDAO.findByUnitId(unitId);
        if (useCache != null) {
            this.useCacheDAO.removeEntity(useCache);
        }
    }
}

