/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.use;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.group.UseGroup;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseCacheDAO;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.use.exception.GroupNameAlreadyExistsException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UserNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.RemoveException;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="UseFacade")
@Remote(value={UseFacadeRemote.class})
@Local(value={UseFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UseFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UseFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class UseFacadeBean
implements UseFacadeLocal,
UseFacadeRemote {
    private static final Log log = LogFactory.getLog(UseFacadeBean.class);
    @EJB
    private UseUserAdminFacadeLocal useUserAdminFacade = null;
    @EJB
    private UseUserGroupAdminFacadeLocal useUserGroupAdminFacade = null;
    @EJB
    private EventPersisterFacadeLocal eventPersisterFacade;
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private UseCacheDAO useCacheDAO = null;

    @PostConstruct
    private void initImpl() {
        this.useCacheDAO = UseCacheDAO.newInstance(this.entityManager);
    }

    @Override
    @Business(viewType="both")
    public long addGroup(String name, String description, ModuleType module) throws CreateException {
        UseGroup value = this.useUserGroupAdminFacade.getUseGroupByNameIncludeDeleted(name);
        if (value == null) {
            value = new UseGroup();
            value.setName(name);
            value.setDescription(description);
            value.setModule(module);
            this.useUserGroupAdminFacade.insertUseGroup(value);
            return value.getId();
        }
        if (value.getDeleted()) {
            value.setDeleted(false);
            value.setName(name);
            value.setDescription(description);
            value.setModule(module);
            this.useUserGroupAdminFacade.updateUseGroup(value);
            return value.getId();
        }
        log.debug((Object)("addGroup() - group already exists: " + name));
        throw new CreateException("group already exists: " + name);
    }

    @Override
    @Business(viewType="both")
    public void updateGroup(String name, String newName, String description, ModuleType module) throws GroupNotFoundException, GroupNameAlreadyExistsException {
        UseGroup group = this.useUserGroupAdminFacade.getUseGroupByName(name);
        if (group != null) {
            group.setModule(module);
            if (newName != null) {
                group.setName(newName);
            }
            if (description != null) {
                group.setDescription(description);
            }
            try {
                this.useUserGroupAdminFacade.updateUseGroup(group);
            }
            catch (DuplicateKeyException e) {
                throw new GroupNameAlreadyExistsException();
            }
        } else {
            throw new GroupNotFoundException();
        }
    }

    @Override
    @Business(viewType="both")
    public void removeGroup(String name, ModuleType module) throws RemoveException, GroupNotFoundException {
        UseGroup group = this.useUserGroupAdminFacade.getUseGroupByName(name);
        if (group == null) {
            log.info((Object)("No Group found with name: " + name));
            throw new GroupNotFoundException();
        }
        group.setModule(ModuleType.INTERFACE);
        this.useUserGroupAdminFacade.removeUseGroup(group);
    }

    @Override
    @Business(viewType="both")
    public void removeGroup(long groupId, ModuleType module) throws RemoveException, GroupNotFoundException {
        try {
            this.useUserGroupAdminFacade.deleteUseGroup(groupId, module);
        }
        catch (Exception e) {
            log.error((Object)"runs into ", (Throwable)e);
            throw new GroupNotFoundException();
        }
    }

    @Override
    @Business(viewType="both")
    public UseUser getUser(String key) throws UserNotFoundException {
        try {
            UseUser user = this.useUserAdminFacade.getUseUserByKey(key);
            if (user != null) {
                return user;
            }
            throw new UserNotFoundException("no user found for key " + key);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for " + key + " runs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public void addUser(String name, String description, List<String> groupNames, String key, ModuleType module) throws CreateException, GroupNotFoundException {
        List<UseUser> col = this.useUserAdminFacade.findUseUserByKey(key);
        List<UseUser> colDeleted = this.useUserAdminFacade.findDeletedByKey(key);
        if (col.size() == 0) {
            if (colDeleted.size() == 0) {
                UseUser value = new UseUser();
                value.setName(name);
                value.setDescription(description);
                value.setModule(module);
                this.assignGroupsToUser(groupNames, value);
                value.setKeyId(key);
                this.useUserAdminFacade.insertUseUser(value);
            } else {
                Iterator it = colDeleted.iterator();
                if (it.hasNext()) {
                    UseUser userValue = (UseUser)it.next();
                    this.assignGroupsToUser(groupNames, userValue);
                    userValue.setDeleted(false);
                    userValue.setName(name);
                    userValue.setDescription(description);
                    userValue.setModule(module);
                    this.useUserAdminFacade.updateUseUser(userValue);
                }
            }
        } else {
            throw new CreateException("user with key " + key + " already exists");
        }
    }

    @Override
    @Business(viewType="both")
    public void addUser(String name, String description, String personalNumber, List<String> groupNames, String key, ModuleType module) throws CreateException, GroupNotFoundException {
        List<UseUser> col = this.useUserAdminFacade.findUseUserByKey(key);
        List<UseUser> colDeleted = this.useUserAdminFacade.findDeletedByKey(key);
        if (col.size() == 0) {
            if (colDeleted.size() == 0) {
                UseUser userValue = new UseUser();
                userValue.setName(name);
                userValue.setDescription(description);
                userValue.setPersonalNumber(personalNumber);
                userValue.setModule(module);
                this.assignGroupsToUser(groupNames, userValue);
                userValue.setKeyId(key);
                this.useUserAdminFacade.insertUseUser(userValue);
            } else {
                Iterator it = colDeleted.iterator();
                if (it.hasNext()) {
                    UseUser userValue = (UseUser)it.next();
                    this.assignGroupsToUser(groupNames, userValue);
                    userValue.setDeleted(false);
                    userValue.setName(name);
                    userValue.setDescription(description);
                    userValue.setPersonalNumber(personalNumber);
                    userValue.setModule(module);
                    this.useUserAdminFacade.updateUseUser(userValue);
                }
            }
        } else {
            throw new CreateException("user with key " + key + " already exists");
        }
    }

    @Override
    @Business(viewType="both")
    public UseUser getUserByPersonalNumber(String personalNumber) throws UserNotFoundException {
        log.debug((Object)("getUserByPersonalNumber('" + personalNumber + "')"));
        try {
            List<UseUser> users = this.useUserAdminFacade.findUseUserByPersonalNumber(personalNumber);
            Iterator it = users.iterator();
            if (it.hasNext()) {
                return (UseUser)it.next();
            }
            throw new UserNotFoundException("no user found for personalNumber " + personalNumber);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for personalNumber " + personalNumber + " runs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public UseUser getUser(long userId) throws UserNotFoundException {
        try {
            UseUser users = this.useUserAdminFacade.getUseUserById(userId);
            if (users == null) {
                throw new UserNotFoundException("no user found for userId " + userId);
            }
            return users;
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for " + userId + " runs into " + ex.getMessage());
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUser(String name, String description, List<String> groupNames, String key, ModuleType module) throws UserNotFoundException, GroupNotFoundException {
        List<UseUser> col = this.useUserAdminFacade.findUseUserByKey(key);
        Iterator it = col.iterator();
        if (col.size() == 1) {
            UseUser userValue = (UseUser)it.next();
            this.assignGroupsToUser(groupNames, userValue);
            userValue.setModule(module);
            if (name != null) {
                userValue.setName(name);
            }
            if (description != null) {
                userValue.setDescription(description);
            }
            if (key != null) {
                userValue.setKeyId(key);
            }
            try {
                this.useUserAdminFacade.updateUseUser(userValue);
            }
            catch (DuplicateKeyException e) {
                throw new UserNotFoundException(e.getMessage());
            }
        } else {
            throw new UserNotFoundException();
        }
    }

    @Override
    @Business(viewType="both")
    public void updateUser(String name, String description, String personalNumber, List<String> groupNames, String key, ModuleType module) throws UserNotFoundException, GroupNotFoundException {
        List<UseUser> col = this.useUserAdminFacade.findUseUserByKey(key);
        if (col.size() == 0) {
            col = this.useUserAdminFacade.findUseUserByPersonalNumber(personalNumber);
        }
        Iterator it = col.iterator();
        if (col.size() == 1) {
            UseUser userValue = (UseUser)it.next();
            this.assignGroupsToUser(groupNames, userValue);
            userValue.setModule(module);
            if (name != null) {
                userValue.setName(name);
            }
            if (description != null) {
                userValue.setDescription(description);
            }
            if (personalNumber != null) {
                userValue.setPersonalNumber(personalNumber);
            }
            if (key != null) {
                userValue.setKeyId(key);
            }
            try {
                this.useUserAdminFacade.updateUseUser(userValue);
            }
            catch (DuplicateKeyException e) {
                throw new UserNotFoundException(e.getMessage());
            }
        } else {
            throw new UserNotFoundException();
        }
    }

    private void assignGroupsToUser(List<String> groupNames, UseUser userValue) throws GroupNotFoundException {
        if (userValue.getUseGroups() == null) {
            userValue.setUseGroups(new ArrayList<UseGroup>());
        }
        userValue.getUseGroups().clear();
        for (String groupName : groupNames) {
            userValue.addUseGroup(this.getGroup(groupName));
        }
    }

    private long getGroupId(String name) throws GroupNotFoundException {
        UseGroup group = this.useUserGroupAdminFacade.getUseGroupByName(name);
        if (group != null) {
            return group.getId();
        }
        throw new GroupNotFoundException();
    }

    private UseGroup getGroup(String name) throws GroupNotFoundException {
        UseGroup result = this.useUserGroupAdminFacade.getUseGroupByName(name);
        if (result == null) {
            throw new GroupNotFoundException(name);
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public String getGroupName(long groupId) throws GroupNotFoundException {
        UseGroup useGroup = this.useUserGroupAdminFacade.getUseGroupById(groupId);
        if (useGroup == null) {
            throw new GroupNotFoundException();
        }
        return useGroup.getName();
    }

    @Override
    @Business(viewType="both")
    public void removeUserByKey(String keyId) throws RemoveException, UserNotFoundException {
        UseUser user = this.useUserAdminFacade.getUseUserByKey(keyId);
        if (user == null) {
            throw new UserNotFoundException();
        }
        this.useUserAdminFacade.removeUseUser(user);
    }

    @Override
    @Business(viewType="both")
    public void removeUserByExactKey(String key, ModuleType module) throws RemoveException, UserNotFoundException {
        log.debug((Object)"removeUserByExactKey()");
        List<UseUser> col = this.useUserAdminFacade.findUseUserByKey(key);
        if (col.size() == 0) {
            throw new UserNotFoundException();
        }
        for (UseUser user : col) {
            this.useUserAdminFacade.deleteUseUser(user.getId(), module);
        }
    }

    @Override
    @Business(viewType="both")
    public List<UseUser> getUsers(String groupName) throws GroupNotFoundException {
        return this.useUserAdminFacade.getUseUsersByUseGroupId(this.getGroupId(groupName));
    }

    @Override
    @Business(viewType="both")
    public long getUserIdByKey(String key) throws UserNotFoundException {
        UseUser userValue = this.getUser(key);
        return userValue.getId();
    }

    @Override
    @Business(viewType="both")
    public long getUserIdForUnit(long unitId) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get userId for unit " + unitId));
        }
        try {
            UseCache useCache = this.useCacheDAO.findByUnitId(unitId);
            if (useCache != null && useCache.getUseUserId() != null) {
                long userId = useCache.getUseUserId();
                return userId;
            }
            throw new FinderException();
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new FinderException();
        }
    }

    @Override
    @Business(viewType="both")
    public UseCache getCache(long unitId) {
        return (UseCache)this.useCacheDAO.findByPrimaryKey(unitId);
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(long unitId) {
        UseCache cacheEntry = (UseCache)this.useCacheDAO.findByPrimaryKey(unitId);
        if (cacheEntry != null) {
            long endTime = System.currentTimeMillis();
            UseHistory history = cacheEntry.getHistory();
            history.setEndTime(endTime);
            history.setEndReceiveTime(endTime);
            this.eventPersisterFacade.writeHistoryHelperEntries(history);
            history.setCache(null);
            this.useCacheDAO.removeEntity(cacheEntry);
        }
    }

    @Override
    @Business(viewType="both")
    public void deleteCache(UnitModel unitModel) {
        this.deleteCache(unitModel.getUnitId());
    }

    @Override
    @Business(viewType="both")
    public List<UseCache> findAllUseCache() {
        return this.useCacheDAO.findAll();
    }

    @Override
    @Business(viewType="both")
    public UseCache findByUnitId(long unitId) {
        return this.useCacheDAO.findByUnitId(unitId);
    }
}

