/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.observable;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import java.io.Serializable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableJMSSender {
    private static final Log log = LogFactory.getLog(ObservableJMSSender.class);
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicPublisher sender = null;

    public void initialize() throws Exception {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            TopicConnectionFactory factory = ServiceFactory.getInstance().getTopicConnectionFactory();
            this.connection = factory.createTopicConnection();
            this.connection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
            this.session = this.connection.createTopicSession(false, 2);
            Topic topic = null;
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = this.session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
                log.error((Object)"while initialize, runs into: ", (Throwable)ex);
            }
            this.sender = this.session.createPublisher(topic);
            this.sender.setTimeToLive(300000L);
            this.connection.start();
        }
        catch (Exception e) {
            log.error((Object)"initialize runs into ", (Throwable)e);
            this.closeConnection();
            throw e;
        }
        finally {
            log.debug((Object)"ctx.close();");
            ctx.close();
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            log.error((Object)"closeConnection runs into ", (Throwable)e);
        }
    }

    public void sendMessage(String msg, String kindOfEvent) {
        try {
            ObjectMessage message = this.session.createObjectMessage((Serializable)((Object)msg));
            message.setStringProperty("TypeOfInterest", kindOfEvent);
            this.sender.publish((Message)message);
            log.debug((Object)"Message to topic sent!");
        }
        catch (Exception e) {
            log.error((Object)"notifyClients ends in Exception: try to reconnect", (Throwable)e);
            this.closeConnection();
            try {
                this.initialize();
                ObjectMessage message = this.session.createObjectMessage((Serializable)((Object)msg));
                message.setStringProperty("TypeOfInterest", kindOfEvent);
                this.sender.publish((Message)message);
                log.debug((Object)"Message to topic sent!");
            }
            catch (Exception e2) {
                log.error((Object)"notifyClients 2nd try ends in Exception: ", (Throwable)e2);
            }
        }
    }

    public void sendMessage(SerializableEventWrapper wrapper, String kindOfEvent) {
        try {
            ObjectMessage message = this.session.createObjectMessage((Serializable)wrapper);
            message.setStringProperty("TypeOfInterest", kindOfEvent);
            this.sender.publish((Message)message);
            log.debug((Object)"Message to topic sent!");
        }
        catch (Exception e) {
            log.error((Object)"runs into Exception ", (Throwable)e);
            this.closeConnection();
            try {
                this.initialize();
                ObjectMessage message = this.session.createObjectMessage((Serializable)wrapper);
                message.setStringProperty("TypeOfInterest", kindOfEvent);
                this.sender.publish((Message)message);
                log.debug((Object)"Message to topic sent!");
            }
            catch (Exception e2) {
                log.error((Object)"notifyClients 2nd try ends in Exception: ", (Throwable)e2);
            }
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;
        boolean exceptionFlag = false;

        private ExceptionListenerImpl() {
        }

        public synchronized void onException(JMSException e) {
            if (this.exceptionFlag) {
                return;
            }
            this.exceptionFlag = true;
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                ObservableJMSSender.this.closeConnection();
                try {
                    ObservableJMSSender.this.initialize();
                    log.info((Object)"Connection re-established");
                    return;
                }
                catch (Exception e2) {
                    log.warn((Object)"Re-creating connection failed, retrying ...");
                    continue;
                }
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

