/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.informant;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.connection.ServletConnection;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="InformantFacade")
@Remote(value={InformantFacadeRemote.class})
@Local(value={InformantFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/InformantFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/InformantFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class InformantFacadeBean
implements InformantFacadeLocal,
InformantFacadeRemote {
    @EJB
    private ConfigurationLocal configurationLocal = null;
    @EJB
    private ObservableFacadeLocal observableFacadeLocal = null;
    private static final Log log = LogFactory.getLog(InformantFacadeBean.class);
    private final String INFORMANT_TYPE_LOCAL = "local";
    private final String INFORMANT_TYPE_DISTRIBUTED = "distributed";
    private String host = "localhost";
    private int port = 8080;
    private String type = "local";
    private boolean proxyUse = false;
    private String proxyHost = "";
    private int proxyPort = 0;
    private String proxyUser = "";
    private String proxyPass = "";
    private String proxyDomain = "";
    private ServletConnection _servletConnection = null;

    @PostConstruct
    public void ejbCreate() throws CreateException {
        this.getConfiguration();
    }

    @Override
    @Business(viewType="both")
    public void notify(SerializableEventWrapper wrapper, String kindOfEvent) {
        if (this.type.equals("local")) {
            log.debug((Object)"Local notification selected!");
            this.observableFacadeLocal.notifyClients(wrapper, kindOfEvent);
        } else if (this.type.equals("distributed")) {
            log.error((Object)"Selected notification not full implemented!");
        } else {
            log.error((Object)("Selected notification of type '" + this.type + "'not implemented!"));
        }
    }

    @Override
    @Business(viewType="both")
    public void notify(String message, String kindOfEvent) {
        SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)message));
        wrapper.set_typeOfEvent(kindOfEvent);
        if (this.type.equals("local")) {
            log.debug((Object)"Local notification selected!");
            this.observableFacadeLocal.notifyClients(wrapper, kindOfEvent);
        } else if (this.type.equals("distributed")) {
            log.error((Object)"Selected notification not full implemented!");
        } else {
            log.error((Object)("Selected notification of type '" + this.type + "'not implemented!"));
        }
    }

    private void getConfiguration() {
        try {
            this.type = this.configurationLocal.getParameter("observable.informant.type");
            if (this.type.equals("distributed")) {
                log.debug((Object)"Distributed notification selected!");
                this.host = this.configurationLocal.getParameter("observable.informant.host");
                this.port = Integer.parseInt(this.configurationLocal.getParameter("observable.informant.port"));
                this._servletConnection = new ServletConnection(this.host, this.port, "http");
                this.proxyUse = Boolean.parseBoolean(this.configurationLocal.getParameter("observable.informant.proxy"));
                if (this.proxyUse) {
                    this.proxyHost = this.configurationLocal.getParameter("observable.informant.proxy.host");
                    this.proxyPort = Integer.parseInt(this.configurationLocal.getParameter("observable.informant.proxy.port"));
                    this.proxyUser = this.configurationLocal.getParameter("observable.informant.proxy.user");
                    this.proxyPass = this.configurationLocal.getParameter("observable.informant.proxy.pass");
                    this.proxyDomain = this.configurationLocal.getParameter("observable.informant.proxy.domain");
                    this._servletConnection.setupProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPass, this.proxyDomain);
                }
                this._servletConnection.connect();
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"getConfiguration runs into NumberFormatException: ", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"getConfiguration runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
        }
    }
}

