/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.triggers.measurment.frames;

import de.proveo.wwt.datamodel.measurement.MeasurementDefinition;
import de.proveo.wwt.datamodel.measurement.MeasurementInterval;
import de.proveo.wwt.logic.ejb.dataIn.event.triggers.measurment.frames.MeasurementTypeCache;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementEvent;
import de.proveo.wwt.logic.ejb.general.measurement.MeasurementFacadeLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MeasurementTypesHandler {
    private static final Log log = LogFactory.getLog(MeasurementTypesHandler.class);
    private HashMap<Integer, MeasurementTypeCache> typeFrames = new HashMap();
    private MeasurementFacadeLocal measurementFacade = null;

    public MeasurementTypesHandler() {
        try {
            InitialContext context = new InitialContext();
            this.measurementFacade = (MeasurementFacadeLocal)context.lookup("rts/MeasurementFacade/local");
        }
        catch (NamingException e) {
            log.error((Object)"MeasurementTypeFrames() runs into", (Throwable)e);
        }
    }

    public List<MeasurementInterval> putMeasurementEvent(MeasurementEvent event) {
        if (event != null) {
            MeasurementTypeCache frames = this.typeFrames.get(event.getMeasurementDefinitionId());
            MeasurementDefinition measurementDefinition = this.measurementFacade.getMeasurementDefinition(event.getMeasurementDefinitionId());
            if (frames == null) {
                log.debug((Object)("Create new MeasurementTypeFrames for event type: " + event.getMeasurementDefinitionId() + " " + measurementDefinition.getName()));
                frames = new MeasurementTypeCache();
                this.typeFrames.put(event.getMeasurementDefinitionId(), frames);
            }
            if (!measurementDefinition.isCacheOnly()) {
                return frames.putMeasurementEvent(event, measurementDefinition);
            }
            log.debug((Object)("Skip event cause measurement type is cache only: " + event));
        }
        return Collections.emptyList();
    }

    public HashMap<Integer, MeasurementTypeCache> getTypeFrames() {
        return this.typeFrames;
    }
}

