/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.history;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.helper.BaseHelperUtil;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IBeginTime;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IEndTime;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IGroupHistoryId;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryId;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IUnitId;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="EventPersisterFacade")
@Remote(value={EventPersisterFacadeRemote.class})
@Local(value={EventPersisterFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/EventPersisterFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/EventPersisterFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class EventPersisterFacadeBean
implements EventPersisterFacadeLocal,
EventPersisterFacadeRemote {
    private static final Log log = LogFactory.getLog(EventPersisterFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> EventPersisterResult<C, H> persist(H historyEntity) {
        return this.persist(historyEntity, false, false);
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> EventPersisterResult<C, H> persistHistoryOnly(H historyEntity) {
        return this.persist(historyEntity, false, true);
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> EventPersisterResult<C, H> persist(H historyEntity, boolean cacheOnly) {
        return this.persist(historyEntity, cacheOnly, false);
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> EventPersisterResult<C, H> persist(H historyEntity, boolean cacheOnly, boolean finishHistoryOnly) {
        EventPersisterResult<Object, Object> result = null;
        ((IGroupHistoryId)historyEntity).setGroupHistoryId(this.unitFacade.getGrouphistoryId(((IUnitId)historyEntity).getUnitId(), ((IBeginTime)historyEntity).getBeginTime()));
        Object newCache = ((IHistoryEntity)historyEntity).generateCache();
        EntityBase existingCache = (EntityBase)this.entityManager.find(newCache.getClass(), newCache.getPrimaryKey());
        if (existingCache == null) {
            this.entityManager.persist(historyEntity);
            ((IHistoryId)newCache).setHistoryId(((IHistoryId)historyEntity).getHistoryId());
            this.entityManager.persist(newCache);
            if (!cacheOnly) {
                this.persistHelperEntries(null, historyEntity);
            }
            result = new EventPersisterResult(newCache, historyEntity);
        } else if (((IBeginTime)existingCache).getBeginTime() < ((IBeginTime)newCache).getBeginTime()) {
            if (cacheOnly) {
                ((IHistoryId)newCache).setHistoryId(((IHistoryId)existingCache).getHistoryId());
                newCache = (EntityBase)this.entityManager.merge(newCache);
                ((IHistoryId)historyEntity).setHistoryId(((IHistoryId)existingCache).getHistoryId());
                historyEntity = (EntityBase)this.entityManager.merge(historyEntity);
                result = new EventPersisterResult(newCache, historyEntity);
            } else {
                EntityBase oldHistory = (EntityBase)this.entityManager.find(historyEntity.getClass(), (Object)((IHistoryId)existingCache).getHistoryId());
                if (oldHistory instanceof HibernateProxy) {
                    oldHistory = (EntityBase)((HibernateProxy)oldHistory).getHibernateLazyInitializer().getImplementation();
                }
                ((IHistoryEntity)historyEntity).finishHistory(oldHistory);
                if (finishHistoryOnly) {
                    oldHistory.removeRelation(existingCache, existingCache.getClass());
                    this.entityManager.remove((Object)existingCache);
                } else {
                    this.entityManager.persist(historyEntity);
                    ((IHistoryId)newCache).setHistoryId((Long)historyEntity.getPrimaryKey());
                    newCache = (EntityBase)this.entityManager.merge(newCache);
                }
                this.persistHelperEntries(oldHistory, historyEntity);
                result = new EventPersisterResult<Object, EntityBase>((finishHistoryOnly ? null : (Object)newCache), oldHistory);
            }
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> EventPersisterResult<C, H> update(H historyEntity) {
        this.entityManager.flush();
        EventPersisterResult result = null;
        Object newCache = ((IHistoryEntity)historyEntity).generateCache();
        EntityBase existingCache = (EntityBase)this.entityManager.find(newCache.getClass(), newCache.getPrimaryKey());
        if (existingCache != null) {
            long historyId = ((IHistoryId)existingCache).getHistoryId();
            ((IHistoryId)newCache).setHistoryId(historyId);
            ((IHistoryId)historyEntity).setHistoryId(historyId);
            newCache = (EntityBase)this.entityManager.merge(newCache);
            historyEntity = (EntityBase)this.entityManager.merge(historyEntity);
            result = new EventPersisterResult(newCache, historyEntity);
        }
        return result;
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> void remove(C cacheEntry) {
        this.entityManager.remove(((ICacheEntity)cacheEntry).getHistory());
    }

    private <C extends EntityBase, H extends EntityBase> void persistHelperEntries(H oldHistory, H newHistory) {
        Class<HistoryHelperBase> helperClass = ((IHistoryEntity)newHistory).getHelperClass();
        if (helperClass != null) {
            if (oldHistory != null && oldHistory instanceof IEndTime) {
                this.writeHistoryHelperEntries(oldHistory);
            } else if (!(newHistory instanceof IEndTime)) {
                int dayStamp = BaseHelperUtil.roundToDaystamp((long)((IBeginTime)newHistory).getBeginTime());
                this.persistHelperEntry(newHistory, dayStamp);
            }
        }
    }

    @Override
    @Business(viewType="both")
    public <C extends EntityBase, H extends EntityBase> void writeHistoryHelperEntries(H history) {
        if (!(history instanceof IEndTime)) {
            return;
        }
        int[] daystamps = BaseHelperUtil.roundToDaystamps((long)((IBeginTime)history).getBeginTime(), (long)((IEndTime)history).getEndTime());
        for (int i = 0; i < daystamps.length; ++i) {
            this.persistHelperEntry(history, daystamps[i]);
        }
    }

    private <C extends EntityBase, H extends EntityBase> void persistHelperEntry(H historyEntity, int dayStamp) {
        try {
            HistoryHelperBase helper = ((IHistoryEntity)historyEntity).getHelperClass().newInstance();
            helper.setGroupHistoryId(((IGroupHistoryId)historyEntity).getGroupHistoryId());
            helper.setUnitId(((IUnitId)historyEntity).getUnitId());
            helper.setPk(new HistoryHelperBase.PK(((IHistoryId)historyEntity).getHistoryId(), dayStamp));
            this.entityManager.persist((Object)helper);
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }
}

