/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.EventHandlerUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.GeoEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(TestEventHandler.class);
    private MonitoringMBean testEventCounter;
    private GeoEventHandler geoHandler;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (EventHandlerUtil.isTestEvent(event)) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleTestEvent(event, eventInfo.unitIds[i], eventInfo, eventWrappers)) continue;
                result = EventResult.ERROR;
                break;
            }
        }
        return result;
    }

    private boolean handleTestEvent(Properties event, long unitId, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        this.testEventCounter.increment();
        String testType = event.getProperty("test");
        if (testType != null && testType.equals("geoA1")) {
            try {
                StringBuilder cause = new StringBuilder("A1");
                long timestamp = Long.parseLong(event.getProperty("t"));
                double latitude = Double.parseDouble(event.getProperty("aLat"));
                double longitude = Double.parseDouble(event.getProperty("aLong"));
                boolean trusted = Integer.parseInt(event.getProperty("aCF")) == 2 && Integer.parseInt(event.getProperty("aFS")) != 0;
                cause.append(" ");
                cause.append(event.getProperty("aI"));
                int latitudeMSec = (int)(latitude * 60.0 * 60.0 * 1000.0 + 0.5);
                int longitudeMSec = (int)(longitude * 60.0 * 60.0 * 1000.0 + 0.5);
                float speed = (float)Integer.parseInt(event.getProperty("aV")) / 10.0f;
                GeoStruct geoEvent = new GeoStruct(unitId, timestamp, eventInfo.receiveTime, latitudeMSec, longitudeMSec, trusted, cause.toString());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("time", event.getProperty("t"));
                params.put("status", trusted ? "A" : "V");
                params.put("latitude", Long.toString(latitudeMSec));
                params.put("longitude", Long.toString(longitudeMSec));
                params.put("speed", Float.toString(speed));
                params.put("trackMadeGood", Float.toString((float)Integer.parseInt(event.getProperty("aHe")) / 10.0f));
                String record = GPSPosition.createNMEArecord((String)"RMC", params);
                geoEvent.setRmcRec(record);
                params = new HashMap();
                params.put("time", event.getProperty("t"));
                params.put("latitude", Long.toString(latitudeMSec));
                params.put("longitude", Long.toString(longitudeMSec));
                params.put("quality", trusted ? "1" : "0");
                params.put("sats", event.getProperty("aS"));
                params.put("altitude", event.getProperty("aAt"));
                record = GPSPosition.createNMEArecord((String)"GGA", params);
                geoEvent.setGgaRec(record);
                this.geoHandler.handleGeoEvent(geoEvent.generateEventProperties(), eventInfo, unitId, eventWrappers);
                return true;
            }
            catch (Exception ex) {
                log.error((Object)"handleTestEvent() runs during parse into", (Throwable)ex);
                return false;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("handleTestEvent() unkown test event: " + event));
        }
        return true;
    }

    @Override
    public void initialize() {
        try {
            this.testEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "TestEvents");
        }
        catch (Exception e) {
            log.error((Object)"TestEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
        this.geoHandler = new GeoEventHandler();
        this.geoHandler.initialize();
    }
}

