/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.datasync.ejb.TaskManagementFacadeLocal;
import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.util.service.ServiceFactory;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.history.EventPersisterResult;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanMessageEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(InfomanMessageEventHandler.class);
    private MonitoringMBean scanmanMsgEventCounter;
    private EventPersisterFacadeLocal eventPersisterFacade = null;
    private InfomanSetupFacadeLocal infomanSetupFacade = null;
    private TaskManagementFacadeLocal taskManagementFacade = null;
    private UnitFacadeLocal unitFacade = null;
    private UnitUserLocal unitUser = null;
    private GeofencingUpdateFacadeLocal geofUpdateFacade = null;
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 254;
    private int maxMessageLength = 254;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("st")) {
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                this.handleInfomanMessageEvent(event, eventInfo, eventInfo.unitIds[i], eventInfo.gdataHistoryId, eventWrappers);
            }
        }
        return result;
    }

    private void handleInfomanMessageEvent(Properties event, EventInfo eventInfo, long unitId, Long gdataHistoryId, ArrayList<SerializableEventWrapper> eventWrappers) {
        log.debug((Object)"handleInfomanMessageEvent() new event of type 'scanman message' ");
        this.scanmanMsgEventCounter.increment();
        int infomanMessageType = Integer.parseInt(event.getProperty("st"));
        long createTime = Long.parseLong(event.getProperty("t"));
        String infomanMessageInfo = this.getMessageInfo(event);
        ScanmanMsgHistory scanmanMsgHistory = new ScanmanMsgHistory();
        scanmanMsgHistory.setUnitId(unitId);
        scanmanMsgHistory.setCreateTime(createTime);
        scanmanMsgHistory.setType(infomanMessageType);
        scanmanMsgHistory.setReceiveTime(eventInfo.receiveTime);
        scanmanMsgHistory.setMessage(infomanMessageInfo);
        scanmanMsgHistory.setGdataHistoryId(gdataHistoryId);
        boolean newStyleBootMessage = false;
        if (infomanMessageType == 25 && scanmanMsgHistory.getMessage().contains("=")) {
            newStyleBootMessage = true;
        }
        if (event.containsKey("binary")) {
            scanmanMsgHistory.setBinaryPayload((byte[])event.get("binary"));
        }
        String message = infomanMessageInfo;
        switch (infomanMessageType) {
            case 10: {
                message = "current IP: " + infomanMessageInfo;
                break;
            }
            case 20: {
                message = StringUtil.appendStrings((String[])new String[]{"reboot", " ", infomanMessageInfo});
                break;
            }
            case 9: {
                message = StringUtil.appendStrings((String[])new String[]{"begin event failed: ", " ", infomanMessageInfo});
                break;
            }
            case 8: {
                message = "end event failed";
                break;
            }
            case 11: {
                message = "disconnect VPN";
                break;
            }
            case 25: {
                if (!newStyleBootMessage) break;
                scanmanMsgHistory.setMessage(infomanMessageInfo);
                if (!event.containsKey("noD")) {
                    this.infomanSetupFacade.infomanBoot(scanmanMsgHistory);
                }
                message = this.infomanSetupFacade.getOldStyleBootMessage(infomanMessageInfo);
                break;
            }
            case 30: {
                message = infomanMessageInfo;
                this.infomanSetupFacade.updateConfiguration(scanmanMsgHistory);
                break;
            }
            case 31: {
                this.infomanSetupFacade.updateReport(scanmanMsgHistory.getCreateTime(), scanmanMsgHistory.getMessage());
                break;
            }
            case 32: {
                this.unitUser.updateReport(scanmanMsgHistory.getUnitId(), scanmanMsgHistory.getCreateTime(), scanmanMsgHistory.getMessage());
                break;
            }
            case 33: {
                this.geofUpdateFacade.updateGeofReport(scanmanMsgHistory.getUnitId(), scanmanMsgHistory.getCreateTime(), scanmanMsgHistory.getMessage());
                break;
            }
            case 300: {
                this.unitFacade.updateSCLReport(scanmanMsgHistory.getUnitId(), scanmanMsgHistory.getCreateTime(), scanmanMsgHistory.getMessage());
                break;
            }
            case 35: {
                try {
                    this.taskManagementFacade.finishTask(scanmanMsgHistory.getCreateTime(), scanmanMsgHistory.getMessage());
                }
                catch (Exception ex) {
                    log.error((Object)"handleInfomanMessageEvent() runs into", (Throwable)ex);
                }
                break;
            }
            default: {
                message = infomanMessageInfo;
            }
        }
        scanmanMsgHistory.setMessage(message);
        if (scanmanMsgHistory.getMessage().length() > this.maxMessageLength) {
            String oldMsg = scanmanMsgHistory.getMessage();
            scanmanMsgHistory.setMessage(oldMsg.substring(0, this.maxMessageLength));
            if (log.isWarnEnabled()) {
                log.warn((Object)("event() msg exceeded maximumlenth of " + this.maxMessageLength + " cutted off. orignal: " + oldMsg + " cutted to: " + scanmanMsgHistory.getMessage()));
            }
        }
        this.persistEvent(scanmanMsgHistory, eventWrappers);
    }

    public void persistEvent(ScanmanMsgHistory scanmanMsgHistory, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventPersisterResult result = this.eventPersisterFacade.persist(scanmanMsgHistory);
        if (result != null) {
            try {
                SerializableEventWrapper eventWrapper = new SerializableEventWrapper((Serializable)((Object)scanmanMsgHistory));
                eventWrapper.set_typeOfEvent("InfomanMessages");
                eventWrappers.add(eventWrapper);
            }
            catch (Exception e) {
                log.error((Object)"handleInfomanMessageEvent() runs into: ", (Throwable)e);
            }
        }
    }

    private String getMessageInfo(Properties event) {
        if (event.containsKey("si")) {
            return event.getProperty("si");
        }
        StringBuilder buffer = new StringBuilder();
        int index = 1;
        while (event.containsKey("si" + index)) {
            buffer.append(event.getProperty("si" + index));
            buffer.append(';');
            ++index;
        }
        return buffer.toString();
    }

    @Override
    public void initialize() {
        try {
            this.scanmanMsgEventCounter = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "ScanmanMsgEvents");
            InitialContext context = new InitialContext();
            this.eventPersisterFacade = (EventPersisterFacadeLocal)context.lookup("rts/EventPersisterFacade/local");
            this.infomanSetupFacade = (InfomanSetupFacadeLocal)context.lookup("rts/InfomanSetupFacade/local");
            this.unitFacade = (UnitFacadeLocal)context.lookup("rts/UnitFacade/local");
            this.unitUser = (UnitUserLocal)context.lookup("rts/UnitUser/local");
            this.geofUpdateFacade = (GeofencingUpdateFacadeLocal)context.lookup("rts/GeofencingUpdateFacade/local");
            this.maxMessageLength = 254;
            this.taskManagementFacade = (TaskManagementFacadeLocal)context.lookup("datasync/TaskManagementFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"InfomanMessageEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

