/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event.handlers;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.geofencing.GeofUnitModel;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventResult;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.EventHandlerUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofencingUpdateFacadeLocal;
import java.util.ArrayList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeofencingEventHandler
implements IEventHandler {
    private static final Log log = LogFactory.getLog(GeofencingEventHandler.class);
    private GeofencingUpdateFacadeLocal geofencingUpdateFacade = null;

    @Override
    public EventResult handleEvent(Properties event, EventResponse eventResponse, EventInfo eventInfo, ArrayList<SerializableEventWrapper> eventWrappers) {
        EventResult result = EventResult.SUCCESS;
        if (event.containsKey("req") && event.getProperty("req").equals("gf")) {
            GeofUnitModel geofUnitModel;
            int numUnits = eventInfo.unitIds.length;
            for (int i = 0; i != numUnits; ++i) {
                if (this.handleGEOFRequest(eventInfo.unitIds[i])) continue;
                result = EventResult.ERROR;
                break;
            }
            if (numUnits != 0 && EventHandlerUtil.isTestEvent(event) && (geofUnitModel = eventInfo.unitModels[0].getGeofUnitModel()) != null && this.geofencingUpdateFacade.isGeofAreasUpdateNecessary(geofUnitModel)) {
                eventResponse.setGeoAreasChanged(true);
                EventPayload payload = this.geofencingUpdateFacade.startGeofAreasUpdate(geofUnitModel);
                eventResponse.addPayload(payload);
            }
        }
        return result;
    }

    protected boolean handleGEOFRequest(long unitId) {
        log.trace((Object)"handleGEOFRequest()");
        try {
            this.geofencingUpdateFacade.updateGeofUnitModel(unitId, true);
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"handleGEOFRequest() runs into", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"handleGEOFRequest() runs into", (Throwable)ex);
        }
        return true;
    }

    @Override
    public void initialize() {
        try {
            InitialContext context = new InitialContext();
            this.geofencingUpdateFacade = (GeofencingUpdateFacadeLocal)context.lookup("rts/GeofencingUpdateFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"GeofencingEventHandler() runs into", (Throwable)e);
            throw new EJBException("EJB reference problem", e);
        }
    }
}

