/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.KeepAliveTimeoutLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.KeepAliveTimeoutRemote;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="KeepAliveTimeout")
@Local(value={KeepAliveTimeoutLocal.class})
@Remote(value={KeepAliveTimeoutRemote.class})
@JndiLocalBinding(localJndiBinding="rts/KeepAliveTimeout")
@JndiRemoteBinding(remoteJndiBinding="rts/KeepAliveTimeout")
@RunAs(value="nobody")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class KeepAliveTimeoutBean
implements KeepAliveTimeoutLocal,
KeepAliveTimeoutRemote,
TimedObject {
    private static final Log log = LogFactory.getLog(KeepAliveTimeoutBean.class);
    private static final String CREATE_OUTOFSYNC_KEY = "infoman.keepalive.timeout.createOutOfSync";
    private static final String CHECK_INTERVAL_KEY = "infoman.keepalive.timeout.checkInterval";
    private static String DEFAULT_INTERVAL = "300000";
    private long interval;
    private Timer timer = null;
    private TimerService timerService;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveOutFacade;
    @EJB
    private EventFacadeLocal eventFacade;
    @EJB
    private ConfigurationLocal configurationLocal;

    @PostConstruct
    public void init() {
        log.debug((Object)"init()");
        this.timerService = this.sessionContext.getTimerService();
        this.interval = Long.parseLong(this.configurationLocal.getParameter(CHECK_INTERVAL_KEY, DEFAULT_INTERVAL));
    }

    @Override
    @Business(viewType="both")
    public void createTimer() {
        log.debug((Object)"createTimer()");
        try {
            this.timer = this.timerService.createTimer(0L, this.interval, (Serializable)((Object)"KeepAliveTimeoutBean"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("timer created: " + this.timer));
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    @PermitAll
    public void ejbTimeout(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTimeout()" + timer));
        }
        if (this.configurationLocal.getBoolean(CREATE_OUTOFSYNC_KEY, true)) {
            Stopwatch stopwatch = new Stopwatch(KeepAliveTimeoutBean.class, "KeepAliveTimeout");
            stopwatch.start("Overall");
            stopwatch.start("Database access");
            List<StateCache> stateCaches = this.currentStateFacade.findAllByStateModelId(2140, 2141);
            stopwatch.stop("Database access", true, stateCaches.size());
            for (StateCache stateCache : stateCaches) {
                long unitId = stateCache.getPk().getUnitId();
                if (!stateCache.getUnitModel().getDeleted()) {
                    KeepAliveCache keepAliveCache = this.keepAliveOutFacade.findByUnitId(unitId);
                    if (keepAliveCache.getReceiveTime() >= System.currentTimeMillis() - this.keepAliveOutFacade.getKeepAliveTimeout()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("unit " + unitId + " -> keep alive timeout -> failed event"));
                    }
                    log.debug((Object)"create failed event");
                    Properties offlineEvent = new Properties();
                    offlineEvent.setProperty("u", Long.toString(unitId));
                    offlineEvent.setProperty("m", Long.toString(2140L));
                    offlineEvent.setProperty("s", Long.toString(2143L));
                    offlineEvent.setProperty("t", Long.toString(keepAliveCache.getReceiveTime() + this.keepAliveOutFacade.getKeepAliveTimeout()));
                    offlineEvent.setProperty("c", "triggered by KeepAliveTimeoutBean");
                    EventResponse eventResponse = this.eventFacade.handleEventInNewTx(offlineEvent);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("eventResponse: " + eventResponse));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("unit " + unitId + " is deleted! dont create failed event!"));
            }
            stopwatch.stop("Overall", true);
        } else {
            log.debug((Object)"create failed event disabled!");
        }
    }
}

