/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.event;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.EventUtil;
import de.proveo.rts.configuration.infoman.InfomanEventServiceMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeRemote;
import de.proveo.wwt.logic.ejb.dataIn.event.EventInfo;
import de.proveo.wwt.logic.ejb.dataIn.event.EventManager;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.ACLEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.ACLUpdateHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.CallbackEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.DatasyncHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.GeoEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.GeofencingEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.IEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.InfomanAdministrationEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.InfomanMessageEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.KeepaliveEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.MeasurementEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.NotifyEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.RFIDEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.SCLEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.StateEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.TestEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.TimestampEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.UnitValidationEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.UseEventHandler;
import de.proveo.wwt.logic.ejb.dataIn.event.handlers.ZeroconfEventHandler;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="EventFacade")
@Remote(value={EventFacadeRemote.class})
@Local(value={EventFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/EventFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/EventFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=100, timeout=10000L)
public class EventFacadeBean
implements EventFacadeLocal,
EventFacadeRemote {
    private static final Log log = LogFactory.getLog(EventFacadeBean.class);
    private static Map<Long, Object> syncHandleMap = new HashMap<Long, Object>();
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;
    private InfomanEventServiceMBean infomanEventService;
    private EventManager eventManager;
    private static final List<Class<? extends IEventHandler>> handlerClasses = new ArrayList<Class<? extends IEventHandler>>();

    @PostConstruct
    public void initialize() {
        try {
            this.eventManager = new EventManager(handlerClasses);
            this.infomanEventService = (InfomanEventServiceMBean)ServiceFactory.getInstance().getService(InfomanEventServiceMBean.class);
        }
        catch (Exception ex) {
            log.error((Object)"ejbCreate() runs into", (Throwable)ex);
            throw new EJBException("ejb reference problem", ex);
        }
    }

    @Override
    @Business(viewType="both")
    public EventResponse handleEvent(Properties event) throws NoSuchElementException {
        return this.handleEvent(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Business(viewType="both")
    public EventResponse handleEvent(Properties event, EventInfo eventInfo) throws NoSuchElementException {
        EventResponse eventResponse;
        if (eventInfo == null) {
            eventInfo = new EventInfo();
        }
        if (eventInfo.receiveTime == 0L) {
            eventInfo.receiveTime = System.currentTimeMillis();
        }
        if (this.infomanEventService.isEventsDisabled()) {
            eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
        } else if (event.getProperty("p") != null && event.getProperty("p").equals("ejb")) {
            eventResponse = new EventResponse();
            eventResponse.setEventResponse(true);
        } else {
            long unitId = EventFacadeBean.getUnitId(event);
            Object object = EventFacadeBean.getSyncHandle(unitId);
            synchronized (object) {
                eventResponse = this.eventManager.handleEvent(event, eventInfo);
            }
        }
        return eventResponse;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public EventResponse handleEventInNewTx(Properties event) {
        return this.handleEvent(event);
    }

    @Override
    @Business(viewType="both")
    public void resetCallback(Properties event) {
        long[] unitIds = EventUtil.getUnitIds((Properties)event);
        for (int index = 0; index < unitIds.length; ++index) {
            UnitModel unitModel = this.unitFacadeLocal.getUnitModel(unitIds[index]);
            unitModel.setCallback(false);
        }
    }

    private static long getUnitId(Properties event) {
        long[] unitIds = EventUtil.getUnitIds((Properties)event);
        if (unitIds.length == 0) {
            return -1L;
        }
        return unitIds[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getSyncHandle(long unitId) {
        Object syncHandle;
        Map<Long, Object> map = syncHandleMap;
        synchronized (map) {
            syncHandle = syncHandleMap.get(unitId);
            if (syncHandle == null) {
                syncHandle = new Object();
                syncHandleMap.put(unitId, syncHandle);
            }
        }
        return syncHandle;
    }

    static {
        handlerClasses.add(TimestampEventHandler.class);
        handlerClasses.add(ZeroconfEventHandler.class);
        handlerClasses.add(UnitValidationEventHandler.class);
        handlerClasses.add(GeoEventHandler.class);
        handlerClasses.add(UseEventHandler.class);
        handlerClasses.add(CallbackEventHandler.class);
        handlerClasses.add(RFIDEventHandler.class);
        handlerClasses.add(StateEventHandler.class);
        handlerClasses.add(InfomanMessageEventHandler.class);
        handlerClasses.add(KeepaliveEventHandler.class);
        handlerClasses.add(MeasurementEventHandler.class);
        handlerClasses.add(NotifyEventHandler.class);
        handlerClasses.add(ACLEventHandler.class);
        handlerClasses.add(ACLUpdateHandler.class);
        handlerClasses.add(GeofencingEventHandler.class);
        handlerClasses.add(SCLEventHandler.class);
        handlerClasses.add(TestEventHandler.class);
        handlerClasses.add(InfomanAdministrationEventHandler.class);
        handlerClasses.add(DatasyncHandler.class);
    }
}

