/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.locale;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.locale.Locale;
import de.proveo.wwt.logic.app.locale.LocaleDAO;
import de.proveo.wwt.logic.app.locale.LocaleFacadeLocal;
import de.proveo.wwt.logic.app.locale.LocaleFacadeRemote;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="LocaleFacade")
@Remote(value={LocaleFacadeRemote.class})
@Local(value={LocaleFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/LocaleFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/LocaleFacade")
public class LocaleFacadeBean {
    private static final Log log = LogFactory.getLog(LocaleFacadeBean.class);
    @PersistenceContext(unitName="rts")
    private EntityManager entityManager = null;
    private LocaleDAO localeDAO;

    @PostConstruct
    public void initialize() {
        this.localeDAO = LocaleDAO.newInstance(this.entityManager);
    }

    @Business(viewType="both")
    public List<Locale> getLocales() {
        return this.localeDAO.findAll();
    }

    @Business(viewType="both")
    public Locale findLocale(int id) {
        return (Locale)this.localeDAO.findByPrimaryKey(id);
    }

    @Business(viewType="both")
    public Locale findLocale(String language, String country) {
        return this.localeDAO.findByLanguageAndCountry(language, country);
    }

    @Business(viewType="both")
    public void createLocale(Locale locale) {
        this.localeDAO.createEntity(locale);
    }

    @Business(viewType="both")
    public void removeLocale(int id) {
        Locale locale = (Locale)this.localeDAO.findByPrimaryKey(id);
        this.localeDAO.removeEntity(locale);
    }

    @Business(viewType="both")
    public Locale updateLocale(Locale locale) {
        return (Locale)this.localeDAO.updateEntity(locale);
    }
}

