/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.use.license;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.Trim;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.use.license.LicenseType;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.LicenseStatus;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="license")
@NamedQueries(value={@NamedQuery(name="License.findAllWithUseUser", query="SELECT e FROM License e LEFT JOIN FETCH e.useUser", hints={@QueryHint(name="org.hibernate.cacheable", value="false")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, include="all")
public class License
extends AuditEntityBase
implements Serializable {
    private static final long serialVersionUID = -3123175476590053223L;
    @AuditRelevant
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private int id;
    @AuditRelevant
    @Column(name="REMARK")
    @Equals
    @Trim
    @ToString
    private String remark;
    @AuditRelevant
    @Column(name="STARTDATE")
    @Equals
    @ToString
    private long startDate = System.currentTimeMillis();
    @AuditRelevant
    @Column(name="REVOKED")
    @Equals
    @ToString
    private boolean revoked = false;
    @ManyToOne(targetEntity=LicenseType.class, fetch=FetchType.EAGER)
    @JoinColumn(name="TYPE_ID")
    private LicenseType licenseType;
    @ManyToOne(targetEntity=UseUser.class, fetch=FetchType.LAZY)
    @JoinColumn(name="USE_USER_ID")
    private UseUser useUser;

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public UseUser getUseUser() {
        return this.useUser;
    }

    public void setUseUser(UseUser useUser) {
        this.useUser = useUser;
    }

    public void setId(int id) {
        this.id = id;
    }

    public License() {
    }

    public License(License license) {
        this();
        this.id = license.id;
        this.useUser = license.useUser;
        this.licenseType = license.licenseType;
        this.startDate = license.startDate;
        this.remark = license.remark;
        this.revoked = license.revoked;
    }

    public int getId() {
        return this.id;
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public String getName() {
        return this.licenseType.getName();
    }

    public Date getStartDateAsDate() {
        return new Date(this.startDate);
    }

    public void setStartDateAsDate(Date date) {
        this.startDate = date.getTime();
    }

    public int getDuration() {
        return this.licenseType.getDuration();
    }

    public long getEndDate() {
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(new Date(this.startDate));
        switch (this.licenseType.getDurationType()) {
            case HOUR: {
                endDate.add(10, this.licenseType.getDuration());
                break;
            }
            case DAY: {
                endDate.add(5, this.licenseType.getDuration());
                break;
            }
            case WEEK: {
                endDate.add(5, this.licenseType.getDuration() * 7);
                break;
            }
            case MONTH: {
                endDate.add(2, this.licenseType.getDuration());
                break;
            }
            case YEAR: {
                endDate.add(1, this.licenseType.getDuration());
            }
        }
        return endDate.getTimeInMillis();
    }

    public boolean isExpired() {
        return this.getEndDate() < System.currentTimeMillis();
    }

    public LicenseStatus getStatus() {
        if (this.isRevoked()) {
            return LicenseStatus.REVOKED;
        }
        if (this.isExpired()) {
            return LicenseStatus.EXPIRED;
        }
        return LicenseStatus.ACTIVE;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("License");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("remark = ");
        stringBuilder.append(this.remark == null ? "[null]" : this.remark.toString());
        stringBuilder.append(", ");
        stringBuilder.append("startDate = ");
        stringBuilder.append(this.startDate);
        stringBuilder.append(", ");
        stringBuilder.append("revoked = ");
        stringBuilder.append(this.revoked);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        License license = (License)object;
        if (this.id != license.id) {
            return false;
        }
        if (this.remark == null ? license.remark != null : !this.remark.equals(license.remark)) {
            return false;
        }
        if (this.startDate != license.startDate) {
            return false;
        }
        return this.revoked == license.revoked;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.remark == null ? 0 : this.remark.hashCode());
        n2 = n * n2 + (int)(this.startDate ^ this.startDate >>> 32);
        n2 = n * n2 + (this.revoked ? 0 : 1);
        return n2;
    }
}

