/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.unit.model;

import de.proveo.util.jpa.entity.Relation;
import de.proveo.util.jpa.entity.Trim;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.geo.GdataHistoryHelper;
import de.proveo.wwt.datamodel.geofencing.GeofUnitModel;
import de.proveo.wwt.datamodel.grouphistory.Grouphistory;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetup;
import de.proveo.wwt.datamodel.infoman.setup.InfomanSetupHistory;
import de.proveo.wwt.datamodel.infoman.setup.update.InfomanUpdate;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.keepalive.KeepAliveHistory;
import de.proveo.wwt.datamodel.keepalive.KeepaliveHistoryHelper;
import de.proveo.wwt.datamodel.measurement.MeasurementCache;
import de.proveo.wwt.datamodel.measurement.MeasurementHistory;
import de.proveo.wwt.datamodel.notify.NotifyCache;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.notify.NotifyHistoryHelper;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistory;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistoryHelper;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistory;
import de.proveo.wwt.datamodel.state.StateHistoryHelper;
import de.proveo.wwt.datamodel.statesum.StateSummary;
import de.proveo.wwt.datamodel.unit.identity.UnitIdentity;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.datamodel.use.UseHistory;
import de.proveo.wwt.datamodel.use.UseHistoryHelper;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="unit_model")
@NamedQueries(value={@NamedQuery(name="unitModel.findAll", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.deleted = FALSE"), @NamedQuery(name="unitModel.findByPrimaryKeyFetchJoin", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.unitId = ?1"), @NamedQuery(name="unitModel.findNonDeletedByIsBasic", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.basic = ?1 AND u.deleted = FALSE ORDER BY u.unitIdentity.name"), @NamedQuery(name="findUnitModelByIsBasicAndUnitUserRefreshTmp", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.basic = true AND u.unitUserRefreshTmp = true AND u.deleted = FALSE"), @NamedQuery(name="findUnitModelByCustomerUnitId", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.customerUnitId = ?1"), @NamedQuery(name="findUnitModelByParentUnitIdAndFilterStateId", query="SELECT u FROM UnitModel u, IN (u.parentModel) up, IN(u.currentStateCaches) c LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE up.unitId = ?1 AND c.stateId = ?2"), @NamedQuery(name="findUnitModelByParentUnitIdWithUnitOnlyUnitIDAndBasic", query="SELECT NEW de.proveo.wwt.datamodel.unit.model.UnitModel (u.unitId, u.basic) FROM UnitModel u, IN (u.parentModel) up WHERE up.unitId = ?1"), @NamedQuery(name="findUnitModelByParentUnitId", query="SELECT u FROM UnitModel u, IN (u.parentModel) up LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE up.unitId = ?1"), @NamedQuery(name="findUnitModelByParentUnitIdFilterByTypeAndPositionAndTrusted", query="SELECT u FROM UnitModel u, IN (u.parentModel) up LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE up.unitId = :unitId AND u.basic = true AND (:type IS NULL OR u.unitIdentity.unitKind = :type) AND (:position IS NULL OR u.gdataCache.area = :position) AND (:trusted IS NULL OR u.gdataCache.trusted = :trusted) AND u.deleted = FALSE"), @NamedQuery(name="findUnitModelByParentsFromChildId", query="SELECT u FROM UnitModel u, IN (u.childModel) up LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE up.unitId = ?1"), @NamedQuery(name="findUnitModelByUnitIdWithGroupId", query="SELECT u FROM UnitModel u, IN (u.parentModel) up LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel"), @NamedQuery(name="unitModel.findDeletedBasic", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.basic = true AND u.deleted = true ORDER BY u.unitIdentity.name"), @NamedQuery(name="unitModel.findByIsBasic", query="SELECT u FROM UnitModel u LEFT JOIN FETCH u.useCache LEFT JOIN FETCH u.keepAliveCache LEFT JOIN FETCH u.infomanSetup LEFT JOIN FETCH u.gdataCache LEFT JOIN FETCH u.geofUnitModel WHERE u.basic = ?1 ORDER BY u.unitIdentity.name"), @NamedQuery(name="unitModel.findByIMEI", query="SELECT u.unitId FROM UnitModel u WHERE u.deleted = false AND u.basic = true AND u.imei = ?1"), @NamedQuery(name="unitModel.findBySerialNumber", query="SELECT u.unitId FROM UnitModel u WHERE u.deleted = false AND u.basic = true AND u.serialNumber = ?1")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@SqlResultSetMappings(value={@SqlResultSetMapping(name="unitModel_idName", entities={@EntityResult(entityClass=UnitModel.class, fields={@FieldResult(name="unitId", column="unit_id")})}), @SqlResultSetMapping(name="unitModel_idNameOnly", columns={@ColumnResult(name="UNIT_ID"), @ColumnResult(name="NAME")})})
public class UnitModel
extends AuditEntityBase
implements Comparable<UnitModel> {
    private static final long serialVersionUID = -3482514674173468846L;
    @AuditRelevant
    @Id
    @Column(name="UNIT_ID")
    private long unitId;
    @AuditRelevant
    @Column(name="UNIT_USER_REFRESH")
    private boolean unitUserRefresh;
    @Column(name="UNIT_USER_SYNC_START_TIME")
    private long unitUserSyncStartTime;
    @AuditRelevant
    @ManyToOne(targetEntity=UnitTypeIdentity.class, fetch=FetchType.EAGER)
    @JoinColumn(name="UNIT_TYPE_ID")
    private UnitTypeIdentity unitTypeIdentity;
    @Column(name="UNIT_USER_SYNC_ERROR")
    private String unitUserSyncError;
    @Column(name="UNIT_USER_SYNC_END_TIME")
    private long unitUserSyncEndTime;
    @Column(name="UNIT_SCL_REFRESH")
    private boolean unitSclRefresh;
    @Column(name="UNIT_SCL_SYNC_START_TIME")
    private long unitSclSyncStartTime;
    @Column(name="UNIT_SCL_VALID_TIME")
    private long unitSclValidTime;
    @Column(name="UNIT_SCL_SYNC_ERROR")
    private String unitSclSyncError;
    @Column(name="UNIT_SCL_SYNC_END_TIME")
    private long unitSclSynchEndTime;
    @Column(name="UNIT_SCL_SYNC_DONE")
    private boolean unitSclSyncDone;
    @Column(name="UNIT_SCL_REFRESH_TYPE")
    private String unitSclRefreshType = null;
    @AuditRelevant
    @Column(name="MODEL_TYPE")
    private String modelType;
    @AuditRelevant
    @Column(name="DELETED")
    private boolean deleted;
    @Column(name="DELETED_TIME")
    private long deletedTime;
    @AuditRelevant
    @Column(name="DELETED_BY_USERNAME")
    private String deletedByUsername;
    @AuditRelevant
    @Column(name="BRAND")
    private String brand;
    @AuditRelevant
    @Column(name="CUSTOMER_UNIT_ID")
    private String customerUnitId;
    @AuditRelevant
    @Column(name="SERIAL_NUMBER")
    private String serialNumber;
    @AuditRelevant
    @Column(name="OPERATIVE_TIME_OFFSET")
    private long operativeTimeOffset;
    @AuditRelevant
    @Column(name="NEXT_MAINTENANCE")
    private int nextMaintenance;
    @AuditRelevant
    @Column(name="IS_BASIC")
    private boolean basic;
    @AuditRelevant
    @Column(name="IP_ADDRESS")
    private String ipAddress;
    @Column(name="UNIT_USER_REFRESH_TMP")
    private boolean unitUserRefreshTmp;
    @AuditRelevant
    @Column(name="REGISTRATION_NUMBER")
    private String registrationNumber;
    @Column(name="UNIT_USER_SYNC_SUCCESSFUL")
    private boolean unitUserSyncSuccessful;
    @AuditRelevant
    @Column(name="SEND_DATA")
    private boolean sendData;
    @AuditRelevant
    @Column(name="BODY_NUMBER")
    private String bodyNumber;
    @AuditRelevant
    @Column(name="SIM_NUMBER")
    private String simNumber;
    @Column(name="UNIT_USER_SYNC_DONE")
    private boolean unitUserSyncDone;
    @AuditRelevant
    @Column(name="AIRPORTMAP_VISIBLE")
    private boolean airportmapVisible;
    @AuditRelevant
    @Column(name="CALLBACK")
    private boolean callback;
    @AuditRelevant
    @Column(name="TELEPHONE_NUMBER")
    private String telephoneNumber;
    @AuditRelevant
    @Column(name="IMEI")
    @Trim
    private String imei;
    @AuditRelevant
    @Column(name="DEVICE_TYPE")
    private String deviceType;
    @AuditRelevant(deep=true)
    @OneToOne(targetEntity=UnitIdentity.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @PrimaryKeyJoinColumn(name="UNIT_ID")
    private UnitIdentity unitIdentity;
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="unit", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="UNIT_ID")
    @Relation(targetName="unit")
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="group", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="GROUP_ID")
    @Relation(targetName="group")
    private List<UnitPermission> groupPermissions = new ArrayList<UnitPermission>();
    @ManyToMany(targetEntity=Grouphistory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="unitGroups")
    @JoinTable(name="grouphistory_x_unitmodel", joinColumns={@JoinColumn(name="UNITGROUP_ID", referencedColumnName="UNIT_ID")}, inverseJoinColumns={@JoinColumn(name="GROUP_HISTORY_ID")})
    @Relation(targetName="unitGroups")
    private List<Grouphistory> groupHistories = new ArrayList<Grouphistory>();
    @OneToMany(targetEntity=Grouphistory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="unit")
    @JoinColumn(name="BASIC_UNIT_ID")
    @Relation(targetName="unit")
    private List<Grouphistory> groupHistoryBasicUnit;
    @OneToMany(targetEntity=UseHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<UseHistory> useHistories = new ArrayList<UseHistory>();
    @OneToMany(targetEntity=UseHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<UseHistoryHelper> useHistoryHelpers = new ArrayList<UseHistoryHelper>();
    @OneToOne(targetEntity=UseCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @PrimaryKeyJoinColumn(name="UNIT_ID")
    private UseCache useCache;
    @OneToOne(targetEntity=KeepAliveCache.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private KeepAliveCache keepAliveCache;
    @OneToMany(targetEntity=KeepAliveHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<KeepAliveHistory> keepAliveHistories = new ArrayList<KeepAliveHistory>();
    @OneToMany(targetEntity=KeepaliveHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<KeepaliveHistoryHelper> keepAliveHistoryHelpers = new ArrayList<KeepaliveHistoryHelper>();
    @OneToMany(targetEntity=StateCache.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<StateCache> currentStateCaches = new ArrayList<StateCache>();
    @OneToMany(targetEntity=StateHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<StateHistory> stateHistories = new ArrayList<StateHistory>();
    @OneToMany(targetEntity=StateHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<StateHistoryHelper> stateHistoryHelpers = new ArrayList<StateHistoryHelper>();
    @OneToMany(targetEntity=NotifyCache.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<NotifyCache> currentNotifyCaches = new ArrayList<NotifyCache>();
    @OneToMany(targetEntity=NotifyHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<NotifyHistory> notifyHistories = new ArrayList<NotifyHistory>();
    @OneToMany(targetEntity=NotifyHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<NotifyHistoryHelper> notifyHistoryHelpers = new ArrayList<NotifyHistoryHelper>();
    @OneToMany(targetEntity=ScanmanMsgCache.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ScanmanMsgCache> scanmanMsgCache;
    @OneToMany(targetEntity=ScanmanMsgHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ScanmanMsgHistory> scanmanMsgHistories = new ArrayList<ScanmanMsgHistory>();
    @OneToMany(targetEntity=ScanmanMsgHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ScanmanMsgHistoryHelper> scanmanMsgHistoryHelpers = new ArrayList<ScanmanMsgHistoryHelper>();
    @AuditRelevant
    @ManyToMany(targetEntity=UnitModel.class, fetch=FetchType.LAZY, mappedBy="childModel")
    @JoinTable(name="unitmodel_x_unitmodel", joinColumns={@JoinColumn(name="UNIT_ID")}, inverseJoinColumns={@JoinColumn(name="GROUP_ID", referencedColumnName="UNIT_ID")})
    @Relation(targetName="childModel")
    private List<UnitModel> parentModel = new ArrayList<UnitModel>();
    @AuditRelevant
    @ManyToMany(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinTable(name="unitmodel_x_unitmodel", joinColumns={@JoinColumn(name="GROUP_ID", referencedColumnName="UNIT_ID")}, inverseJoinColumns={@JoinColumn(name="UNIT_ID")})
    @Relation(targetName="parentModel")
    private List<UnitModel> childModel = new ArrayList<UnitModel>();
    @OneToOne(targetEntity=InfomanSetup.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private InfomanSetup infomanSetup;
    @OneToMany(targetEntity=InfomanSetupHistory.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="unitModel")
    private List<InfomanSetupHistory> infomanSetupHistory = new ArrayList<InfomanSetupHistory>();
    @OneToOne(targetEntity=GdataCache.class, optional=true, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @PrimaryKeyJoinColumn(name="UNIT_ID")
    private GdataCache gdataCache;
    @OneToMany(targetEntity=GdataHistory.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<GdataHistory> gdataHistories = new ArrayList<GdataHistory>();
    @OneToMany(targetEntity=GdataHistoryHelper.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<GdataHistoryHelper> gdataHistoryHelpers = new ArrayList<GdataHistoryHelper>();
    @OneToMany(targetEntity=InfomanUpdate.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<InfomanUpdate> infomanUpdates = new ArrayList<InfomanUpdate>();
    @OneToMany(targetEntity=StateSummary.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<StateSummary> stateSummaries = new ArrayList<StateSummary>();
    @OneToOne(targetEntity=GeofUnitModel.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private GeofUnitModel geofUnitModel;
    @OneToMany(targetEntity=Area.class, mappedBy="unitModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Area> areas = new ArrayList<Area>();
    @OneToMany(targetEntity=MeasurementCache.class, mappedBy="unitModel", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MeasurementCache> measurementCache = new ArrayList<MeasurementCache>();
    @OneToMany(targetEntity=MeasurementHistory.class, mappedBy="unitModel", cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private List<MeasurementHistory> measurementHistory = new ArrayList<MeasurementHistory>();

    public UnitModel(UnitModel unitModel) {
        this.unitId = unitModel.unitId;
        this.unitUserRefresh = unitModel.unitUserRefresh;
        this.unitUserSyncStartTime = unitModel.unitUserSyncStartTime;
        this.unitTypeIdentity = unitModel.unitTypeIdentity;
        this.unitUserSyncError = unitModel.unitUserSyncError;
        this.unitUserSyncEndTime = unitModel.unitUserSyncEndTime;
        this.modelType = unitModel.modelType;
        this.deleted = unitModel.deleted;
        this.deletedTime = unitModel.deletedTime;
        this.deletedByUsername = unitModel.deletedByUsername;
        this.brand = unitModel.brand;
        this.customerUnitId = unitModel.customerUnitId;
        this.serialNumber = unitModel.serialNumber;
        this.operativeTimeOffset = unitModel.operativeTimeOffset;
        this.nextMaintenance = unitModel.nextMaintenance;
        this.basic = unitModel.basic;
        this.ipAddress = unitModel.ipAddress;
        this.unitUserRefreshTmp = unitModel.unitUserRefreshTmp;
        this.registrationNumber = unitModel.registrationNumber;
        this.unitUserSyncSuccessful = unitModel.unitUserSyncSuccessful;
        this.sendData = unitModel.sendData;
        this.bodyNumber = unitModel.bodyNumber;
        this.simNumber = unitModel.simNumber;
        this.unitUserSyncDone = unitModel.unitUserSyncDone;
        this.airportmapVisible = unitModel.airportmapVisible;
        this.callback = unitModel.callback;
        this.telephoneNumber = unitModel.telephoneNumber;
        this.imei = unitModel.imei;
        this.deviceType = unitModel.deviceType;
        this.unitIdentity = unitModel.unitIdentity;
        this.unitSclSyncStartTime = unitModel.unitSclSyncStartTime;
        this.unitSclSynchEndTime = unitModel.unitSclSynchEndTime;
        this.unitSclRefreshType = unitModel.unitSclRefreshType;
        this.unitSclSyncDone = unitModel.unitSclSyncDone;
        this.unitSclRefresh = unitModel.unitSclRefresh;
        this.unitSclSyncError = unitModel.unitSclSyncError;
        this.unitSclValidTime = unitModel.unitSclValidTime;
    }

    public UnitModel() {
    }

    public UnitModel(long unit_id, boolean basic) {
        this.unitId = unit_id;
        this.basic = basic;
    }

    public UnitModel(long unitId) {
        this.unitId = unitId;
    }

    public String getName() {
        return this.unitIdentity.getName();
    }

    public Object getPrimaryKey() {
        return this.getUnitId();
    }

    public long getUnitId() {
        return this.unitId;
    }

    public List<InfomanSetupHistory> getInfomanSetupHistory() {
        return this.infomanSetupHistory;
    }

    public void setInfomanSetupHistory(List<InfomanSetupHistory> infomanSetupHistory) {
        this.infomanSetupHistory = infomanSetupHistory;
    }

    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public List<UnitPermission> getGroupPermissions() {
        return this.groupPermissions;
    }

    public void setGroupPermissions(List<UnitPermission> groupPermissions) {
        this.groupPermissions = groupPermissions;
    }

    public List<GdataHistoryHelper> getGdataHistoryHelpers() {
        return this.gdataHistoryHelpers;
    }

    public void setGdataHistoryHelpers(List<GdataHistoryHelper> gdataHistoryHelpers) {
        this.gdataHistoryHelpers = gdataHistoryHelpers;
    }

    public List<KeepaliveHistoryHelper> getKeepAliveHistoryHelpers() {
        return this.keepAliveHistoryHelpers;
    }

    public void setKeepAliveHistoryHelpers(List<KeepaliveHistoryHelper> keepAliveHistoryHelpers) {
        this.keepAliveHistoryHelpers = keepAliveHistoryHelpers;
    }

    public List<NotifyHistoryHelper> getNotifyHistoryHelpers() {
        return this.notifyHistoryHelpers;
    }

    public void setNotifyHistoryHelpers(List<NotifyHistoryHelper> notifyHistoryHelpers) {
        this.notifyHistoryHelpers = notifyHistoryHelpers;
    }

    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    public List<ScanmanMsgHistoryHelper> getScanmanMsgHistoryHelpers() {
        return this.scanmanMsgHistoryHelpers;
    }

    public void setScanmanMsgHistoryHelpers(List<ScanmanMsgHistoryHelper> scanmanMsgHistoryHelpers) {
        this.scanmanMsgHistoryHelpers = scanmanMsgHistoryHelpers;
    }

    public List<StateHistoryHelper> getStateHistoryHelpers() {
        return this.stateHistoryHelpers;
    }

    public void setStateHistoryHelpers(List<StateHistoryHelper> stateHistoryHelpers) {
        this.stateHistoryHelpers = stateHistoryHelpers;
    }

    public List<UseHistoryHelper> getUseHistoryHelpers() {
        return this.useHistoryHelpers;
    }

    public void setUseHistoryHelpers(List<UseHistoryHelper> useHistoryHelpers) {
        this.useHistoryHelpers = useHistoryHelpers;
    }

    public boolean getUnitUserRefresh() {
        return this.unitUserRefresh;
    }

    public void setUnitUserRefresh(boolean unitUserRefresh) {
        this.unitUserRefresh = unitUserRefresh;
    }

    public long getUnitUserSyncStartTime() {
        return this.unitUserSyncStartTime;
    }

    public void setUnitUserSyncStartTime(long unitUserSyncStartTime) {
        this.unitUserSyncStartTime = unitUserSyncStartTime;
    }

    public UnitTypeIdentity getUnitTypeIdentity() {
        return this.unitTypeIdentity;
    }

    public void setUnitTypeIdentity(UnitTypeIdentity unitTypeIdentity) {
        this.unitTypeIdentity = unitTypeIdentity;
    }

    public String getUnitUserSyncError() {
        return this.unitUserSyncError;
    }

    public void setUnitUserSyncError(String unitUserSyncError) {
        this.unitUserSyncError = unitUserSyncError;
    }

    public long getUnitUserSyncEndTime() {
        return this.unitUserSyncEndTime;
    }

    public void setUnitUserSyncEndTime(long unitUserSyncEndTime) {
        this.unitUserSyncEndTime = unitUserSyncEndTime;
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        if (!this.deleted && deleted) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.REMOVE);
        } else if (this.deleted && !deleted) {
            this.setAuditBehaviour(AuditEntityBase.AuditBehaviour.DEFAULT);
        }
        this.deleted = deleted;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getCustomerUnitId() {
        return this.customerUnitId;
    }

    public void setCustomerUnitId(String customerUnitId) {
        this.customerUnitId = customerUnitId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public long getOperativeTimeOffset() {
        return this.operativeTimeOffset;
    }

    public void setOperativeTimeOffset(long operativeTimeOffset) {
        this.operativeTimeOffset = operativeTimeOffset;
    }

    public int getNextMaintenance() {
        return this.nextMaintenance;
    }

    public void setNextMaintenance(int nextMaintenance) {
        this.nextMaintenance = nextMaintenance;
    }

    public boolean getBasic() {
        return this.basic;
    }

    public void setBasic(boolean isBasic) {
        this.basic = isBasic;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public boolean getUnitUserRefreshTmp() {
        return this.unitUserRefreshTmp;
    }

    public void setUnitUserRefreshTmp(boolean unitUserRefreshTmp) {
        this.unitUserRefreshTmp = unitUserRefreshTmp;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public boolean getUnitUserSyncSuccessful() {
        return this.unitUserSyncSuccessful;
    }

    public void setUnitUserSyncSuccessful(boolean unitUserSyncSuccessful) {
        this.unitUserSyncSuccessful = unitUserSyncSuccessful;
    }

    public boolean getSendData() {
        return this.sendData;
    }

    public void setSendData(boolean sendData) {
        this.sendData = sendData;
    }

    public String getBodyNumber() {
        return this.bodyNumber;
    }

    public void setBodyNumber(String bodyNumber) {
        this.bodyNumber = bodyNumber;
    }

    public String getSimNumber() {
        return this.simNumber;
    }

    public void setSimNumber(String simNumber) {
        this.simNumber = simNumber;
    }

    public boolean getUnitUserSyncDone() {
        return this.unitUserSyncDone;
    }

    public void setUnitUserSyncDone(boolean unitUserSyncDone) {
        this.unitUserSyncDone = unitUserSyncDone;
    }

    public boolean getAirportmapVisible() {
        return this.airportmapVisible;
    }

    public void setAirportmapVisible(boolean airportmapVisible) {
        this.airportmapVisible = airportmapVisible;
    }

    public boolean getCallback() {
        return this.callback;
    }

    public void setCallback(boolean callback) {
        this.callback = callback;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public UnitIdentity getUnitIdentity() {
        return this.unitIdentity;
    }

    public void setUnitIdentity(UnitIdentity unitIdentity) {
        this.unitIdentity = unitIdentity;
    }

    public List<Grouphistory> getGroupHistories() {
        return this.groupHistories;
    }

    public void setGroupHistories(List<Grouphistory> groupHistories) {
        this.groupHistories = groupHistories;
    }

    public List<UseHistory> getUseHistories() {
        return this.useHistories;
    }

    public void setUseHistories(List<UseHistory> useHistories) {
        this.useHistories = useHistories;
    }

    public UseCache getUseCache() {
        return this.useCache;
    }

    public void setUseCache(UseCache useCache) {
        this.useCache = useCache;
    }

    public KeepAliveCache getKeepAliveCache() {
        return this.keepAliveCache;
    }

    public void setKeepAliveCache(KeepAliveCache keepAliveCaches) {
        this.keepAliveCache = keepAliveCaches;
    }

    public List<KeepAliveHistory> getKeepAliveHistories() {
        return this.keepAliveHistories;
    }

    public void setKeepAliveHistories(List<KeepAliveHistory> keepAliveHistories) {
        this.keepAliveHistories = keepAliveHistories;
    }

    public List<StateCache> getCurrentStateCaches() {
        return this.currentStateCaches;
    }

    public void setCurrentStateCaches(List<StateCache> currentStateCaches) {
        this.currentStateCaches = currentStateCaches;
    }

    public List<StateHistory> getStateHistories() {
        return this.stateHistories;
    }

    public void setStateHistories(List<StateHistory> stateHistories) {
        this.stateHistories = stateHistories;
    }

    public List<UnitModel> getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(List<UnitModel> parentModel) {
        this.parentModel = parentModel;
    }

    public List<NotifyCache> getCurrentNotifyCaches() {
        return this.currentNotifyCaches;
    }

    public void setCurrentNotifyCaches(List<NotifyCache> currentNotifyCaches) {
        this.currentNotifyCaches = currentNotifyCaches;
    }

    public List<NotifyHistory> getNotifyHistories() {
        return this.notifyHistories;
    }

    public void setNotifyHistories(List<NotifyHistory> notifyHistories) {
        this.notifyHistories = notifyHistories;
    }

    public InfomanSetup getInfomanSetup() {
        return this.infomanSetup;
    }

    public void setInfomanSetup(InfomanSetup infomanSetup) {
        this.infomanSetup = infomanSetup;
    }

    public GdataCache getCurrentGdataCache() {
        return this.gdataCache;
    }

    public void setCurrentGdataCache(GdataCache currentGdataCache) {
        this.gdataCache = currentGdataCache;
    }

    public List<InfomanUpdate> getInfomanUpdates() {
        return this.infomanUpdates;
    }

    public void setInfomanUpdates(List<InfomanUpdate> infomanUpdates) {
        this.infomanUpdates = infomanUpdates;
    }

    public List<UnitModel> getChildModel() {
        return this.childModel;
    }

    public void setChildModel(List<UnitModel> childModel) {
        this.childModel = childModel;
    }

    public List<StateSummary> getStateSummeries() {
        return this.stateSummaries;
    }

    public void setStateSummeries(List<StateSummary> stateSummeries) {
        this.stateSummaries = stateSummeries;
    }

    public List<GdataHistory> getGdataHistories() {
        return this.gdataHistories;
    }

    public long getDeletedTime() {
        return this.deletedTime;
    }

    public void setDeletedTime(long deletedTime) {
        this.deletedTime = deletedTime;
    }

    public void setGdataHistories(List<GdataHistory> gdataHistories) {
        this.gdataHistories = gdataHistories;
    }

    public boolean idHasBeenSet() {
        return this.unitId != 0L;
    }

    public String getDeletedByUsername() {
        return this.deletedByUsername;
    }

    public void setDeletedByUsername(String deletedByUsername) {
        this.deletedByUsername = deletedByUsername;
    }

    public GeofUnitModel getGeofUnitModel() {
        return this.geofUnitModel;
    }

    public void setGeofUnitModel(GeofUnitModel geofUnitModel) {
        this.geofUnitModel = geofUnitModel;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public void setAreas(List<Area> areas) {
        this.areas = areas;
    }

    public List<Grouphistory> getGroupHistoryBasicUnit() {
        return this.groupHistoryBasicUnit;
    }

    public void setGroupHistoryBasicUnit(List<Grouphistory> groupHistoryBasicUnit) {
        this.groupHistoryBasicUnit = groupHistoryBasicUnit;
    }

    public List<ScanmanMsgCache> getScanmanMsgCache() {
        return this.scanmanMsgCache;
    }

    public void setScanmanMsgCache(List<ScanmanMsgCache> scanmanMsgCache) {
        this.scanmanMsgCache = scanmanMsgCache;
    }

    public List<ScanmanMsgHistory> getScanmanMsgHistories() {
        return this.scanmanMsgHistories;
    }

    public void setScanmanMsgHistories(List<ScanmanMsgHistory> scanmanMsgHistories) {
        this.scanmanMsgHistories = scanmanMsgHistories;
    }

    public boolean isUnitSclRefresh() {
        return this.unitSclRefresh;
    }

    public void setUnitSclRefresh(boolean unitSclRefresh) {
        this.unitSclRefresh = unitSclRefresh;
    }

    public long getUnitSclSyncStartTime() {
        return this.unitSclSyncStartTime;
    }

    public void setUnitSclSyncStartTime(long unitSclSyncStartTime) {
        this.unitSclSyncStartTime = unitSclSyncStartTime;
    }

    public long getUnitSclValidTime() {
        return this.unitSclValidTime;
    }

    public void setUnitSclValidTime(long unitSclValidTime) {
        this.unitSclValidTime = unitSclValidTime;
    }

    public String getUnitSclSyncError() {
        return this.unitSclSyncError;
    }

    public void setUnitSclSyncError(String unitSclSyncError) {
        this.unitSclSyncError = unitSclSyncError;
    }

    public long getUnitSclSynchEndTime() {
        return this.unitSclSynchEndTime;
    }

    public void setUnitSclSynchEndTime(long unitSclSynchEndTime) {
        this.unitSclSynchEndTime = unitSclSynchEndTime;
    }

    public boolean isUnitSclSyncDone() {
        return this.unitSclSyncDone;
    }

    public void setUnitSclSyncDone(boolean unitSclSyncDone) {
        this.unitSclSyncDone = unitSclSyncDone;
    }

    public String getUnitSclRefreshType() {
        return this.unitSclRefreshType;
    }

    public void setUnitSclRefreshType(String unitSclRefreshType) {
        this.unitSclRefreshType = unitSclRefreshType;
    }

    public List<MeasurementCache> getMeasurementCache() {
        return this.measurementCache;
    }

    public void setMeasurementCache(List<MeasurementCache> measurementCache) {
        this.measurementCache = measurementCache;
    }

    public List<MeasurementHistory> getMeasurementHistory() {
        return this.measurementHistory;
    }

    public void setMeasurementHistory(List<MeasurementHistory> measurementHistory) {
        this.measurementHistory = measurementHistory;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.airportmapVisible ? 1231 : 1237);
        result = 31 * result + (this.basic ? 1231 : 1237);
        result = 31 * result + (this.bodyNumber == null ? 0 : this.bodyNumber.hashCode());
        result = 31 * result + (this.brand == null ? 0 : this.brand.hashCode());
        result = 31 * result + (this.callback ? 1231 : 1237);
        result = 31 * result + (this.customerUnitId == null ? 0 : this.customerUnitId.hashCode());
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.deletedByUsername == null ? 0 : this.deletedByUsername.hashCode());
        result = 31 * result + (int)(this.deletedTime ^ this.deletedTime >>> 32);
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.modelType == null ? 0 : this.modelType.hashCode());
        result = 31 * result + this.nextMaintenance;
        result = 31 * result + (int)(this.operativeTimeOffset ^ this.operativeTimeOffset >>> 32);
        result = 31 * result + (this.registrationNumber == null ? 0 : this.registrationNumber.hashCode());
        result = 31 * result + (this.sendData ? 1231 : 1237);
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.simNumber == null ? 0 : this.simNumber.hashCode());
        result = 31 * result + (this.telephoneNumber == null ? 0 : this.telephoneNumber.hashCode());
        result = 31 * result + (int)(this.unitId ^ this.unitId >>> 32);
        result = 31 * result + (this.unitIdentity == null ? 0 : this.unitIdentity.hashCode());
        result = 31 * result + (this.unitUserRefresh ? 1231 : 1237);
        result = 31 * result + (this.unitUserRefreshTmp ? 1231 : 1237);
        result = 31 * result + (this.unitUserSyncDone ? 1231 : 1237);
        result = 31 * result + (int)(this.unitUserSyncEndTime ^ this.unitUserSyncEndTime >>> 32);
        result = 31 * result + (this.unitUserSyncError == null ? 0 : this.unitUserSyncError.hashCode());
        result = 31 * result + (int)(this.unitUserSyncStartTime ^ this.unitUserSyncStartTime >>> 32);
        result = 31 * result + (this.unitUserSyncSuccessful ? 1231 : 1237);
        result = 31 * result + (this.unitSclRefreshType == null ? 0 : this.unitSclRefreshType.hashCode());
        result = 31 * result + (this.imei == null ? 0 : this.imei.hashCode());
        result = 31 * result + (this.deviceType == null ? 0 : this.deviceType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitModel other = (UnitModel)obj;
        if (this.airportmapVisible != other.airportmapVisible) {
            return false;
        }
        if (this.basic != other.basic) {
            return false;
        }
        if (this.bodyNumber == null ? other.bodyNumber != null : !this.bodyNumber.equals(other.bodyNumber)) {
            return false;
        }
        if (this.brand == null ? other.brand != null : !this.brand.equals(other.brand)) {
            return false;
        }
        if (this.callback != other.callback) {
            return false;
        }
        if (this.customerUnitId == null ? other.customerUnitId != null : !this.customerUnitId.equals(other.customerUnitId)) {
            return false;
        }
        if (this.deleted != other.deleted) {
            return false;
        }
        if (this.deletedByUsername == null ? other.deletedByUsername != null : !this.deletedByUsername.equals(other.deletedByUsername)) {
            return false;
        }
        if (this.deletedTime != other.deletedTime) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.modelType == null ? other.modelType != null : !this.modelType.equals(other.modelType)) {
            return false;
        }
        if (this.nextMaintenance != other.nextMaintenance) {
            return false;
        }
        if (this.operativeTimeOffset != other.operativeTimeOffset) {
            return false;
        }
        if (this.registrationNumber == null ? other.registrationNumber != null : !this.registrationNumber.equals(other.registrationNumber)) {
            return false;
        }
        if (this.sendData != other.sendData) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        if (this.simNumber == null ? other.simNumber != null : !this.simNumber.equals(other.simNumber)) {
            return false;
        }
        if (this.telephoneNumber == null ? other.telephoneNumber != null : !this.telephoneNumber.equals(other.telephoneNumber)) {
            return false;
        }
        if (this.unitId != other.unitId) {
            return false;
        }
        if (this.unitIdentity == null ? other.unitIdentity != null : !this.unitIdentity.equals((Object)other.unitIdentity)) {
            return false;
        }
        if (this.unitUserRefresh != other.unitUserRefresh) {
            return false;
        }
        if (this.unitUserRefreshTmp != other.unitUserRefreshTmp) {
            return false;
        }
        if (this.unitUserSyncDone != other.unitUserSyncDone) {
            return false;
        }
        if (this.unitUserSyncEndTime != other.unitUserSyncEndTime) {
            return false;
        }
        if (this.unitUserSyncError == null ? other.unitUserSyncError != null : !this.unitUserSyncError.equals(other.unitUserSyncError)) {
            return false;
        }
        if (this.unitUserSyncStartTime != other.unitUserSyncStartTime) {
            return false;
        }
        if (this.unitUserSyncSuccessful != other.unitUserSyncSuccessful) {
            return false;
        }
        if (this.imei == null ? other.imei != null : !this.imei.equals(other.imei)) {
            return false;
        }
        return !(this.deviceType == null ? other.deviceType != null : !this.deviceType.equals(other.deviceType));
    }

    @Override
    public int compareTo(UnitModel o) {
        int result = 0;
        if (!this.equals(o)) {
            result = this.getUnitId() < o.getUnitId() ? -1 : 1;
        }
        return result;
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer retValue = new StringBuffer();
        retValue.append("UnitModel ( ").append(super.toString()).append("    ").append("unitId = ").append(this.unitId).append("    ").append("unitUserRefresh = ").append(this.unitUserRefresh).append("    ").append("unitUserSyncStartTime = ").append(this.unitUserSyncStartTime).append("    ").append("unitTypeIdentity = ").append(this.unitTypeIdentity).append("    ").append("unitUserSyncError = ").append(this.unitUserSyncError).append("    ").append("unitUserSyncEndTime = ").append(this.unitUserSyncEndTime).append("    ").append("unitSclRefresh = ").append(this.unitSclRefresh).append("    ").append("unitSclSyncStartTime = ").append(this.unitSclSyncStartTime).append("    ").append("unitSclSyncError = ").append(this.unitSclSyncError).append("    ").append("unitSclSynchEndTime = ").append(this.unitSclSynchEndTime).append("    ").append("unitSclSyncDone = ").append(this.unitSclSyncDone).append("    ").append("unitSclValidTime = ").append(this.unitSclValidTime).append("    ").append("modelType = ").append(this.modelType).append("    ").append("deleted = ").append(this.deleted).append("    ").append("deletedTime = ").append(this.deletedTime).append("    ").append("deletedByUsername = ").append(this.deletedByUsername).append("    ").append("brand = ").append(this.brand).append("    ").append("customerUnitId = ").append(this.customerUnitId).append("    ").append("serialNumber = ").append(this.serialNumber).append("    ").append("imei = ").append(this.imei).append("    ").append("deviceType = ").append(this.deviceType).append("    ").append("operativeTimeOffset = ").append(this.operativeTimeOffset).append("    ").append("nextMaintenance = ").append(this.nextMaintenance).append("    ").append("basic = ").append(this.basic).append("    ").append("ipAddress = ").append(this.ipAddress).append("    ").append("unitUserRefreshTmp = ").append(this.unitUserRefreshTmp).append("    ").append("registrationNumber = ").append(this.registrationNumber).append("    ").append("unitUserSyncSuccessful = ").append(this.unitUserSyncSuccessful).append("    ").append("sendData = ").append(this.sendData).append("    ").append("bodyNumber = ").append(this.bodyNumber).append("    ").append("simNumber = ").append(this.simNumber).append("    ").append("unitUserSyncDone = ").append(this.unitUserSyncDone).append("    ").append("airportmapVisible = ").append(this.airportmapVisible).append("    ").append("callback = ").append(this.callback).append("    ").append("telephoneNumber = ").append(this.telephoneNumber).append("    ").append(" )");
        return retValue.toString();
    }

    public String getIMEI() {
        return this.imei;
    }

    public void setIMEI(String imei) {
        this.imei = imei;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }
}

