/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.stateModel;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.audit.ReportAudit;
import de.proveo.wwt.datamodel.image.ImageLayerMapping;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.datamodel.stateModel.StateModelBase;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import de.proveo.wwt.logic.ejb.entityListener.StateModelListener;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="state_model_defn")
@NamedQueries(value={@NamedQuery(name="StateModel.findAll", query="SELECT s FROM StateModel s ORDER BY s.order, s.id"), @NamedQuery(name="StateModel.findAllIncludingStates", query="SELECT s FROM StateModel s JOIN FETCH s.states ORDER BY s.order, s.id"), @NamedQuery(name="StateModel.findActive", query="SELECT s FROM StateModel s WHERE s.active = true ORDER BY s.order, s.id"), @NamedQuery(name="StateModel.findActiveIncludingStates", query="SELECT s FROM StateModel s JOIN FETCH s.states WHERE s.active = true ORDER BY s.order, s.id")})
@EntityListeners(value={StateModelListener.class})
public class StateModel
extends StateModelBase {
    private static final long serialVersionUID = -5547339748099726475L;
    @AuditRelevant
    @Equals
    @Id
    @Column(name="id")
    @ToString
    private int id;
    @AuditRelevant
    @Equals
    @Column(name="filterable")
    @ToString
    private boolean filterable;
    @AuditRelevant
    @Equals
    @Column(name="active")
    @ToString
    private boolean active;
    @AuditRelevant
    @OrderBy(value="order, pk.id")
    @OneToMany(targetEntity=State.class, fetch=FetchType.EAGER, cascade={CascadeType.REMOVE}, mappedBy="stateModel")
    private List<State> states = new ArrayList<State>();
    @OneToMany(targetEntity=ReportAudit.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="stateModel")
    private List<ReportAudit> reportAudits = new ArrayList<ReportAudit>();
    @OneToMany(targetEntity=ImageLayerMapping.class, mappedBy="stateModel", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<ImageLayerMapping> imageLayerMappings = new ArrayList<ImageLayerMapping>();

    public StateModel() {
    }

    public StateModel(StateModel stateModel) {
        super(stateModel);
        this.id = stateModel.id;
    }

    public String getName() {
        return String.valueOf(this.id);
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<State> getStates() {
        return this.states;
    }

    public List<ImageLayerMapping> getImageLayerMappings() {
        return this.imageLayerMappings;
    }

    public void setImageLayerMappings(List<ImageLayerMapping> imageLayerMappings) {
        this.imageLayerMappings = imageLayerMappings;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StateModel");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("filterable = ");
        stringBuilder.append(this.filterable);
        stringBuilder.append(", ");
        stringBuilder.append("active = ");
        stringBuilder.append(this.active);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        StateModel stateModel = (StateModel)((Object)object);
        if (this.id != stateModel.id) {
            return false;
        }
        if (this.filterable != stateModel.filterable) {
            return false;
        }
        return this.active == stateModel.active;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.filterable ? 0 : 1);
        n2 = n * n2 + (this.active ? 0 : 1);
        return n2;
    }
}

