/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.state;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.state.StateBase;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.state.StateHistoryHelper;
import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IEndTime;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="state_history")
@NamedQueries(value={@NamedQuery(name="findStateHistoryByUnitStateModelBetween", query="SELECT h FROM StateHistory h WHERE h.unitId = :unitId AND h.stateModelId = :stateModelId AND h.endTime > :since AND h.beginTime < :until"), @NamedQuery(name="findStateHistoryByUnitSorted", query="SELECT h FROM StateHistory h WHERE h.unitId = ?1 ORDER BY h.beginTime"), @NamedQuery(name="findStateHistoryByUnitPeriod", query="SELECT h FROM StateHistory h WHERE h.unitId = :unitId AND h.endTime > :since AND h.beginTime < :until"), @NamedQuery(name="findStateHistoryByUnitStateModelSorted", query="SELECT h FROM StateHistory h WHERE h.unitId = ?1 AND h.stateModelId = ?2 ORDER BY h.beginTime"), @NamedQuery(name="findStateHistoryByRotationAssignment", query="SELECT h FROM StateHistory h WHERE h.stateModelId = :stateModelId AND h.stateId = :stateId AND h.remark = :rkey ORDER BY h.unitId ASC, h.beginTime ASC"), @NamedQuery(name="findByUnitStateModelBeginTime", query="SELECT h FROM StateHistory h WHERE h.unitId = :unitId AND h.stateModelId = :stateModelId and h.beginTime = :beginTime"), @NamedQuery(name="findByUnitStateModelEndTime", query="SELECT h FROM StateHistory h WHERE h.unitId = :unitId AND h.stateModelId = :stateModelId and h.endTime = :endTime"), @NamedQuery(name="getMaxStateHistoryId", query="SELECT MAX(h.stateHistoryId) FROM StateHistory h")})
public class StateHistory
extends StateBase
implements IHistoryEntity<StateHistory, StateCache>,
IEndTime {
    private static final long serialVersionUID = 3586787690879328547L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long stateHistoryId;
    @OneToMany(targetEntity=StateHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="ID", updatable=false, insertable=false)
    private List<StateHistoryHelper> stateHistoryHelper;
    @Column(name="END_TIME")
    @Equals
    @ToString
    private long endTime;
    @Column(name="END_RECEIVE_TIME")
    @Equals
    @ToString
    private long endReceiveTime;
    @Column(name="STATE_MODEL_ID", nullable=false)
    @Equals
    @ToString
    private int stateModelId;
    @Column(name="STATE_ID_NEXT")
    @Equals
    @ToString
    private Integer stateIdNext;
    @Column(name="DURATION")
    @Equals
    @ToString
    private long duration;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private long unitId;
    @ManyToOne(targetEntity=State.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="state_id", insertable=false, updatable=false), @JoinColumn(name="state_model_id", insertable=false, updatable=false)})
    private State state;
    @ManyToOne(targetEntity=State.class, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="state_id_next", insertable=false, updatable=false), @JoinColumn(name="state_model_id", insertable=false, updatable=false)})
    private State stateNext;
    @OneToOne(targetEntity=StateCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private StateCache cache;

    public StateHistory() {
    }

    public StateHistory(StateCache stateCache) {
        super(stateCache);
    }

    @Override
    public StateCache generateCache() {
        return new StateCache(this);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return StateHistoryHelper.class;
    }

    @Override
    public void finishHistory(StateHistory oldHistory) {
        oldHistory.endTime = this.getBeginTime();
        oldHistory.endReceiveTime = this.getBeginReceiveTime();
        oldHistory.stateIdNext = this.getStateId();
        oldHistory.duration = oldHistory.endTime - oldHistory.getBeginTime();
    }

    @Override
    public long getHistoryId() {
        return this.stateHistoryId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.stateHistoryId = historyId;
    }

    public Object getPrimaryKey() {
        return this.stateHistoryId;
    }

    public long getId() {
        return this.stateHistoryId;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    public void setEndReceiveTime(long endReceiveTime) {
        this.endReceiveTime = endReceiveTime;
    }

    @Override
    public int getStateModelId() {
        return this.stateModelId;
    }

    @Override
    public void setStateModelId(int stateModelId) {
        this.stateModelId = stateModelId;
    }

    public Integer getStateIdNext() {
        return this.stateIdNext;
    }

    public void setStateIdNext(Integer stateIdNext) {
        this.stateIdNext = stateIdNext;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public void setCache(StateCache cache) {
        this.cache = cache;
    }

    public StateCache getCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("StateHistory");
        stringBuilder.append(" (");
        stringBuilder.append("stateHistoryId = ");
        stringBuilder.append(this.stateHistoryId);
        stringBuilder.append(", ");
        stringBuilder.append("endTime = ");
        stringBuilder.append(this.endTime);
        stringBuilder.append(", ");
        stringBuilder.append("endReceiveTime = ");
        stringBuilder.append(this.endReceiveTime);
        stringBuilder.append(", ");
        stringBuilder.append("stateModelId = ");
        stringBuilder.append(this.stateModelId);
        stringBuilder.append(", ");
        stringBuilder.append("stateIdNext = ");
        stringBuilder.append(this.stateIdNext == null ? "[null]" : this.stateIdNext.toString());
        stringBuilder.append(", ");
        stringBuilder.append("duration = ");
        stringBuilder.append(this.duration);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StateHistory stateHistory = (StateHistory)object;
        if (this.stateHistoryId != stateHistory.stateHistoryId) {
            return false;
        }
        if (this.endTime != stateHistory.endTime) {
            return false;
        }
        if (this.endReceiveTime != stateHistory.endReceiveTime) {
            return false;
        }
        if (this.stateModelId != stateHistory.stateModelId) {
            return false;
        }
        if (this.stateIdNext == null ? stateHistory.stateIdNext != null : !this.stateIdNext.equals(stateHistory.stateIdNext)) {
            return false;
        }
        if (this.duration != stateHistory.duration) {
            return false;
        }
        return this.unitId == stateHistory.unitId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.stateHistoryId ^ this.stateHistoryId >>> 32);
        n2 = n * n2 + (int)(this.endTime ^ this.endTime >>> 32);
        n2 = n * n2 + (int)(this.endReceiveTime ^ this.endReceiveTime >>> 32);
        n2 = n * n2 + this.stateModelId;
        n2 = n * n2 + (this.stateIdNext == null ? 0 : this.stateIdNext.hashCode());
        n2 = n * n2 + (int)(this.duration ^ this.duration >>> 32);
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        return n2;
    }
}

