/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.scanmanmsg;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgBase;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgHistoryHelper;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="scanman_msg_history")
@NamedQueries(value={@NamedQuery(name="findScanmanMsgHistoryAllByTime", query="SELECT h FROM ScanmanMsgHistory h WHERE h.createTime BETWEEN ?1 AND ?2"), @NamedQuery(name="findScanmanMsgHistoryAllByTimeAndType", query="SELECT h FROM ScanmanMsgHistory h WHERE h.type = :type AND h.createTime BETWEEN :since AND :until"), @NamedQuery(name="findScanmanMsgHistoryByUnit", query="SELECT h FROM ScanmanMsgHistory h WHERE h.unitId = :unitId AND h.createTime BETWEEN :since AND :until ORDER BY h.createTime"), @NamedQuery(name="findScanmanMsgHistoryByUnitId", query="SELECT h FROM ScanmanMsgHistory h WHERE h.unitId = ?1"), @NamedQuery(name="findScanmanMsgHistoryByTypeAndUnit", query="SELECT h FROM ScanmanMsgHistory h WHERE h.type = :type AND h.unitId = :unitId AND h.createTime BETWEEN :since AND :until ORDER BY h.createTime"), @NamedQuery(name="findScanmanMsgHistoryByUnitGroupId", query="SELECT h FROM ScanmanMsgHistory h, IN (h.groupHistory.unitGroups) ug WHERE ug.unitId = :unitId AND h.createTime BETWEEN :since AND :until")})
public class ScanmanMsgHistory
extends ScanmanMsgBase
implements IHistoryEntity<ScanmanMsgHistory, ScanmanMsgCache> {
    private static final long serialVersionUID = 8070681681692995396L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @OneToMany(targetEntity=ScanmanMsgHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="ID", updatable=false, insertable=false)
    private List<ScanmanMsgHistoryHelper> scanmanMsgHistoryHelper;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private Long unitId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="TYPE")
    @Equals
    @ToString
    private int type;
    @Transient
    @Equals
    private byte[] binaryPayload;
    @OneToOne(targetEntity=ScanmanMsgCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private ScanmanMsgCache cache;

    public ScanmanMsgHistory() {
    }

    public ScanmanMsgHistory(ScanmanMsgCache scanmanMsgCache) {
        super(scanmanMsgCache);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return ScanmanMsgHistoryHelper.class;
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    @Override
    public void finishHistory(ScanmanMsgHistory oldHistory) {
    }

    @Override
    public ScanmanMsgCache generateCache() {
        return new ScanmanMsgCache(this);
    }

    @Override
    public long getHistoryId() {
        return this.id;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.id = historyId;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public byte[] getBinaryPayload() {
        return this.binaryPayload;
    }

    public void setBinaryPayload(byte[] binaryPayload) {
        this.binaryPayload = binaryPayload;
    }

    public boolean isBinaryPayloadEmpty() {
        return this.binaryPayload == null || this.binaryPayload.length == 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ScanmanMsgHistory");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("type = ");
        stringBuilder.append(this.type);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScanmanMsgHistory scanmanMsgHistory = (ScanmanMsgHistory)object;
        if (this.id != scanmanMsgHistory.id) {
            return false;
        }
        if (this.unitId == null ? scanmanMsgHistory.unitId != null : !this.unitId.equals(scanmanMsgHistory.unitId)) {
            return false;
        }
        if (this.type != scanmanMsgHistory.type) {
            return false;
        }
        return Arrays.equals(this.binaryPayload, scanmanMsgHistory.binaryPayload);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (this.unitId == null ? 0 : this.unitId.hashCode());
        n2 = n * n2 + this.type;
        n2 = n * n2 + Arrays.hashCode(this.binaryPayload);
        return n2;
    }
}

