/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.role;

import de.proveo.util.jpa.entity.Relation;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.groupIdent.GroupIdent;
import de.proveo.wwt.datamodel.role.IRoleOwner;
import de.proveo.wwt.datamodel.unit.permission.IUnitPermissionOwner;
import de.proveo.wwt.datamodel.unit.permission.UnitPermission;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="role")
@NamedQueries(value={@NamedQuery(name="findRoleAll", query="SELECT u FROM Role u ORDER BY u.roleName ASC", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findRoleByRolename", query="SELECT a FROM Role a where a.roleName = ?1", hints={@QueryHint(name="org.hibernate.cacheable", value="true")}), @NamedQuery(name="findRoleByStartsWith", query="SELECT a FROM Role a where a.roleName like concat(?1,'%')", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Role
extends AuditEntityBase
implements Serializable,
IUnitPermissionOwner,
IRoleOwner,
Comparable<Role> {
    @AuditRelevant
    @Id
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Column(name="ID")
    private long id;
    @Column(name="NOT_EDITABLE", nullable=false)
    private boolean notEditable;
    @AuditRelevant
    @Column(name="ROLE_NAME")
    private String roleName;
    @AuditRelevant
    @Column(name="IS_ADMIN_ROLE", nullable=false)
    private boolean isAdminRole;
    @AuditRelevant
    @ManyToMany(targetEntity=Role.class, fetch=FetchType.LAZY)
    @JoinTable(name="role_x_role", joinColumns={@JoinColumn(name="ID_ROLE")}, inverseJoinColumns={@JoinColumn(name="ID_SECTIONROLE")})
    @Relation(targetName="parentSectionRoles")
    private List<Role> childSectionRoles = new ArrayList<Role>();
    @AuditRelevant
    @ManyToMany(targetEntity=Role.class, fetch=FetchType.LAZY, mappedBy="childSectionRoles")
    @JoinTable(name="role_x_role", joinColumns={@JoinColumn(name="ID_SECTIONROLE")}, inverseJoinColumns={@JoinColumn(name="ID_ROLE")})
    @Relation(targetName="childSectionRoles")
    private List<Role> parentSectionRoles = new ArrayList<Role>();
    @AuditRelevant
    @OneToMany(targetEntity=UnitPermission.class, mappedBy="role", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<UnitPermission> unitPermissions = new ArrayList<UnitPermission>();
    @AuditRelevant
    @ManyToMany(targetEntity=Account.class, fetch=FetchType.LAZY, mappedBy="roles")
    @JoinTable(name="account_x_role", joinColumns={@JoinColumn(name="ID_ROLE")}, inverseJoinColumns={@JoinColumn(name="ID_ACCOUNT")})
    private List<Account> accounts = new ArrayList<Account>();
    @AuditRelevant
    @ManyToMany(targetEntity=GroupIdent.class, fetch=FetchType.LAZY, mappedBy="roles")
    @JoinTable(name="groupident_x_role", joinColumns={@JoinColumn(name="ID_ROLE")}, inverseJoinColumns={@JoinColumn(name="ID_GROUPIDENT")})
    private List<GroupIdent> groups = new ArrayList<GroupIdent>();
    private static final long serialVersionUID = 1L;

    public Role(Role role) {
        this.id = role.id;
        this.notEditable = role.notEditable;
        this.roleName = role.roleName;
        this.childSectionRoles = role.childSectionRoles;
        this.unitPermissions = role.unitPermissions;
        this.accounts = role.accounts;
        this.groups = role.groups;
    }

    public Role() {
    }

    public String getName() {
        return this.roleName;
    }

    @Override
    public Object getPrimaryKey() {
        return this.getId();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean getNotEditable() {
        return this.notEditable;
    }

    public void setNotEditable(boolean notEditable) {
        this.notEditable = notEditable;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public List<Role> getRoles() {
        return this.childSectionRoles;
    }

    public List<Role> getParentRoles() {
        return this.parentSectionRoles;
    }

    @Override
    public void setRoles(List<Role> sectionRoles) {
        this.childSectionRoles = sectionRoles;
    }

    @Override
    public List<UnitPermission> getUnitPermissions() {
        return this.unitPermissions;
    }

    @Override
    public void setUnitPermissions(List<UnitPermission> unitPermissions) {
        this.unitPermissions = unitPermissions;
    }

    @Override
    public void setPermissionOwner(UnitPermission unitPermission) {
        unitPermission.setRoleId(this.getId());
    }

    @Override
    public boolean isPermissionOwner(UnitPermission unitPermission) {
        Long id = unitPermission.getRoleId();
        return id != null && id.equals(this.getPrimaryKey());
    }

    public List<GroupIdent> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupIdent> groups) {
        this.groups = groups;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public boolean idHasBeenSet() {
        return this.id != 0L;
    }

    public void addAccount(Account account) {
        if (account != null && !this.accounts.contains(account)) {
            this.accounts.add(account);
            account.addRole(this);
        }
    }

    public void addGroupIdent(GroupIdent groupIdent) {
        if (groupIdent != null && !this.groups.contains(groupIdent)) {
            this.groups.add(groupIdent);
            groupIdent.addRole(this);
        }
    }

    @Override
    public void addRole(Role role) {
        if (role != null) {
            this.childSectionRoles.add(role);
        }
    }

    @Override
    public void addRoles(List<Role> roles) {
        for (Role role : roles) {
            this.addRole(role);
        }
    }

    @Override
    public void replaceRoles(List<Role> newRoles) {
        if (this.childSectionRoles == null) {
            this.childSectionRoles = new ArrayList<Role>(newRoles.size());
        } else {
            this.childSectionRoles.clear();
        }
        this.addRoles(newRoles);
    }

    public void addUnitPermission(UnitPermission unitPermission) {
        if (unitPermission != null) {
            unitPermission.setRoleId(this.getId());
            if (!this.unitPermissions.contains(unitPermission)) {
                this.unitPermissions.add(unitPermission);
                unitPermission.setRoleId(this.getId());
            }
        }
    }

    public boolean isAdminRole() {
        return this.isAdminRole;
    }

    public void setAdminRole(boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isAdminRole ? 1231 : 1237);
        result = 31 * result + (this.notEditable ? 1231 : 1237);
        result = 31 * result + (this.roleName == null ? 0 : this.roleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.isAdminRole != other.isAdminRole) {
            return false;
        }
        if (this.notEditable != other.notEditable) {
            return false;
        }
        return !(this.roleName == null ? other.roleName != null : !this.roleName.equals(other.roleName));
    }

    public String toString() {
        String TAB = "    ";
        StringBuffer retValue = new StringBuffer();
        retValue.append("Role ( ").append(super.toString()).append("    ").append("id = ").append(this.id).append("    ").append("notEditable = ").append(this.notEditable).append("    ").append("roleName = ").append(this.roleName).append("    ").append("isAdminRole = ").append(this.isAdminRole).append("    ").append(" )");
        return retValue.toString();
    }

    @Override
    public int compareTo(Role o) {
        return this.equals(o) ? 0 : -1;
    }
}

