/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.notify;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.string.StringUtil;
import de.proveo.wwt.datamodel.notify.NotifyBase;
import de.proveo.wwt.datamodel.notify.NotifyHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="notify_cache")
@NamedQueries(value={@NamedQuery(name="findCurrentNotifyCacheAll", query="SELECT c FROM NotifyCache c"), @NamedQuery(name="findCurrentNotifyCacheAllSortedById", query="SELECT c FROM NotifyCache c ORDER BY c.historyId"), @NamedQuery(name="findCurrentNotifyCacheByMessageId", query="SELECT c FROM NotifyCache c WHERE c.pk.messageId = ?1"), @NamedQuery(name="findCurrentNotifyCacheByUnitId", query="SELECT c FROM NotifyCache c WHERE c.pk.unitId = ?1"), @NamedQuery(name="findCurrentNotifyCacheByUnitIdAndMessageId", query="SELECT c FROM NotifyCache c WHERE c.pk.unitId = ?1 AND c.pk.messageId = ?2"), @NamedQuery(name="findCurrentNotifyCacheByUnitIdSorted", query="SELECT h FROM NotifyCache h WHERE h.pk.unitId = :unitId AND h.entry = :entry AND h.createTime BETWEEN :since AND :until ORDER BY h.createTime"), @NamedQuery(name="findCurrentNotifyCacheLastByUnitId", query="SELECT DISTINCT c FROM NotifyCache c WHERE c.pk.unitId = ?1 AND c.entry = true ORDER BY c.createTime DESC LIMIT 1"), @NamedQuery(name="findCurrentNotifyCacheByUnitGroupId", query="SELECT c FROM NotifyCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1"), @NamedQuery(name="findCurrentNotifyCacheByUnitGroupIdAndMessageId", query="SELECT c FROM NotifyCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1 AND c.pk.messageId = ?2")})
public class NotifyCache
extends NotifyBase
implements ICacheEntity<NotifyHistory> {
    private static final long serialVersionUID = -7886549036824705719L;
    @EmbeddedId
    @Equals
    @ToString
    private PK pk = new PK();
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=NotifyHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private NotifyHistory history;

    public NotifyCache() {
    }

    public NotifyCache(NotifyBase notifyBase) {
        super(notifyBase);
        this.pk = new PK(notifyBase.getUnitId(), notifyBase.getMessageId());
        this.setUnitModel(new UnitModel(notifyBase.getUnitId()));
    }

    @Override
    public long getBeginTime() {
        return this.getCreateTime();
    }

    @Override
    public void setBeginTime(long timestamp) {
        this.setCreateTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.pk;
    }

    @Override
    public long getUnitId() {
        return this.pk.getUnitId();
    }

    @Override
    public void setUnitId(long unitId) {
        this.pk.setUnitId(unitId);
    }

    @Override
    public long getMessageId() {
        return this.pk.getMessageId();
    }

    @Override
    public void setMessageId(long messageId) {
        this.pk.setMessageId(messageId);
    }

    public PK getPk() {
        return this.pk;
    }

    public void setPk(PK pk) {
        this.pk = pk;
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public NotifyHistory getHistory() {
        return this.history;
    }

    public boolean isDifferentEvent(NotifyCache currentNotifyCache) {
        if (this.getEntry() != currentNotifyCache.getEntry() || this.getCreateTime() != currentNotifyCache.getCreateTime()) {
            this.updateCache(currentNotifyCache);
            return true;
        }
        return false;
    }

    private void updateCache(NotifyCache event) {
        this.setCreateTime(event.getCreateTime());
        this.setReceiveTime(event.getReceiveTime());
        this.setEntry(event.getEntry());
        this.setRemark(event.getRemark());
        this.setAreaId(event.getAreaId());
        this.setUseUserId(event.getUseUserId());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NotifyCache");
        stringBuilder.append(" (");
        stringBuilder.append("pk = ");
        stringBuilder.append(this.pk == null ? "[null]" : this.pk.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NotifyCache notifyCache = (NotifyCache)object;
        if (this.pk == null ? notifyCache.pk != null : !this.pk.equals(notifyCache.pk)) {
            return false;
        }
        return this.historyId == notifyCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (this.pk == null ? 0 : this.pk.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }

    @Embeddable
    public static class PK
    implements Serializable {
        private static final long serialVersionUID = -7168344621694889834L;
        @Column(name="UNIT_ID")
        private long unitId;
        @Column(name="MESSAGE_ID")
        private long messageId;

        public PK() {
        }

        public PK(long unitId, long messageId) {
            this.unitId = unitId;
            this.messageId = messageId;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(long unitId) {
            this.unitId = unitId;
        }

        public long getMessageId() {
            return this.messageId;
        }

        public void setMessageId(long messageId) {
            this.messageId = messageId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PK)) {
                return false;
            }
            PK other = (PK)o;
            return this.unitId == other.unitId && this.messageId == other.messageId;
        }

        public int hashCode() {
            return (int)(this.unitId ^ this.unitId >>> 32) ^ (int)(this.messageId ^ this.messageId >>> 32);
        }

        public String toString() {
            String superString = super.toString();
            boolean hasSuperString = superString != null;
            return StringUtil.appendStrings((String[])new String[]{this.getClass().getSimpleName(), " (", hasSuperString ? superString : "", hasSuperString ? "; " : "", "unitId = ", String.valueOf(this.unitId), "; ", "messageId = ", String.valueOf(this.messageId), ")"});
        }
    }
}

