/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.infoman.setup;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.codec.binary.Base64;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="infoman_setup_history")
@NamedQueries(value={@NamedQuery(name="findInfomanSetupHistoryByUnit", query="SELECT h FROM InfomanSetupHistory h WHERE h.unitId = :unitId AND h.createTime BETWEEN :since AND :until ORDER BY h.createTime DESC"), @NamedQuery(name="findByUnitId", query="SELECT h FROM InfomanSetupHistory h WHERE h.unitId = :unitId ORDER BY h.createTime DESC")})
public class InfomanSetupHistory
extends EntityBase {
    private static final long serialVersionUID = 4565057321163443817L;
    @Transient
    private static final int BLOB_SIZE = Integer.MAX_VALUE;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    private long id;
    @Column(name="INFOMAN_SN")
    private String infomanSn;
    @Column(name="UNIT_ID")
    private long unitId;
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    private UnitModel unitModel;
    @Column(name="CONFIGURATION_CHECKSUM")
    private String configurationChecksum;
    @Column(name="ROOTFS_VERSION")
    private String rootfsVersion;
    @Column(name="CREATE_TIME")
    private long createTime;
    @Column(name="SOFTWARE_VERSION")
    private String softwareVersion;
    @Column(name="SOFTWARE_REVISION")
    private String softwareRevision;
    @Column(name="KERNEL_VERSION")
    private String kernelVersion;
    @Column(name="PM_VERSION")
    private String powerManagementVersion;
    @Column(length=0x7FFFFFFF)
    @Lob
    private byte[] configuration;
    @Column(name="CONFIGURATION_CONTENT_TYPE")
    private String configurationContentType;
    @Column(name="CONFIGURATION_CHECKSUM_TYPE")
    private String configurationChecksumType;
    @Column(name="CONFIGURATION_NAME")
    private String configurationName;
    @Column(name="DEVICE_TYPE")
    private String deviceType;
    @Column(name="HARDWARE")
    private String hardware;
    @Column(name="JAVAVM_VERSION")
    private String javaVmVersion;
    @Column(name="HARDWARE_SN")
    private String hardwareSn;
    @Column(name="MODEM_FIRMWARE_VERSION")
    private String modemFirmwareVersion;
    @Column(name="SIM_CARD_NO")
    private String simCardNo;
    @Column(name="IMSI")
    private String imsi;
    @Column(name="IMEI")
    private String imei;
    @Column(name="GPS_FIRMWARE")
    private String gpsFirmware;
    @Column(name="MODEM_TYPE")
    private String modemType;
    @Column(name="WIFI_FIRMWARE")
    private String wifiFirmware;
    @Column(name="WIFI_MAC")
    private String wifiMac;
    @Column(name="VEHICLE_ID")
    private String vehicleId;

    public InfomanSetupHistory(InfomanSetupHistory infomanSetupHistory) {
        this.id = infomanSetupHistory.id;
        this.infomanSn = infomanSetupHistory.infomanSn;
        this.unitId = infomanSetupHistory.unitId;
        this.configurationChecksum = infomanSetupHistory.configurationChecksum;
        this.rootfsVersion = infomanSetupHistory.rootfsVersion;
        this.createTime = infomanSetupHistory.createTime;
        this.softwareVersion = infomanSetupHistory.softwareVersion;
        this.softwareRevision = infomanSetupHistory.softwareRevision;
        this.kernelVersion = infomanSetupHistory.kernelVersion;
        this.powerManagementVersion = infomanSetupHistory.powerManagementVersion;
        this.configuration = infomanSetupHistory.configuration;
        this.configurationContentType = infomanSetupHistory.configurationContentType;
        this.configurationChecksumType = infomanSetupHistory.configurationChecksumType;
        this.configurationName = infomanSetupHistory.configurationName;
        this.hardware = infomanSetupHistory.deviceType;
        this.hardware = infomanSetupHistory.hardware;
        this.javaVmVersion = infomanSetupHistory.javaVmVersion;
        this.hardwareSn = infomanSetupHistory.hardwareSn;
        this.modemFirmwareVersion = infomanSetupHistory.modemFirmwareVersion;
        this.simCardNo = infomanSetupHistory.simCardNo;
        this.imsi = infomanSetupHistory.imsi;
        this.imei = infomanSetupHistory.imei;
        this.gpsFirmware = infomanSetupHistory.gpsFirmware;
        this.modemType = infomanSetupHistory.modemType;
        this.wifiFirmware = infomanSetupHistory.wifiFirmware;
        this.wifiMac = infomanSetupHistory.wifiMac;
        this.vehicleId = infomanSetupHistory.vehicleId;
    }

    public InfomanSetupHistory() {
        try {
            new PropertyUtilsBean().getPropertyDescriptor((Object)this, "configuration").setValue("transient", Boolean.TRUE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getName() {
        return this.configurationName;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public String getGpsFirmware() {
        return this.gpsFirmware;
    }

    public void setGpsFirmware(String gpsFirmware) {
        this.gpsFirmware = gpsFirmware;
    }

    public String getImei() {
        return this.imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImsi() {
        return this.imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getModemFirmwareVersion() {
        return this.modemFirmwareVersion;
    }

    public void setModemFirmwareVersion(String modemFirmwareVersion) {
        this.modemFirmwareVersion = modemFirmwareVersion;
    }

    public String getModemType() {
        return this.modemType;
    }

    public void setModemType(String modemType) {
        this.modemType = modemType;
    }

    public String getSimCardNo() {
        return this.simCardNo;
    }

    public void setSimCardNo(String simCardNo) {
        this.simCardNo = simCardNo;
    }

    public String getWifiFirmware() {
        return this.wifiFirmware;
    }

    public void setWifiFirmware(String wifiFirmware) {
        this.wifiFirmware = wifiFirmware;
    }

    public String getWifiMac() {
        return this.wifiMac;
    }

    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    public String getInfomanSn() {
        return this.infomanSn;
    }

    public void setInfomanSn(String infomanSn) {
        this.infomanSn = infomanSn;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    public String getConfigurationChecksum() {
        return this.configurationChecksum;
    }

    public void setConfigurationChecksum(String configurationChecksum) {
        this.configurationChecksum = configurationChecksum;
    }

    public String getRootfsVersion() {
        return this.rootfsVersion;
    }

    public void setRootfsVersion(String rootfsVersion) {
        this.rootfsVersion = rootfsVersion;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public String getPowerManagementVersion() {
        return this.powerManagementVersion;
    }

    public void setPowerManagementVersion(String powerManagementVersion) {
        this.powerManagementVersion = powerManagementVersion;
    }

    public byte[] getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(byte[] configuration) {
        this.configuration = configuration;
    }

    public String getConfigurationContentType() {
        return this.configurationContentType;
    }

    public void setConfigurationContentType(String configurationContentType) {
        this.configurationContentType = configurationContentType;
    }

    public String getConfigurationChecksumType() {
        return this.configurationChecksumType;
    }

    public void setConfigurationChecksumType(String configurationChecksumType) {
        this.configurationChecksumType = configurationChecksumType;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getHardware() {
        return this.hardware;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getJavaVmVersion() {
        return this.javaVmVersion;
    }

    public void setJavaVmVersion(String javaVmVersion) {
        this.javaVmVersion = javaVmVersion;
    }

    public String getHardwareSn() {
        return this.hardwareSn;
    }

    public void setHardwareSn(String hardwareSn) {
        this.hardwareSn = hardwareSn;
    }

    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public void setEncodedConfiguration(String encodedConfiguration) {
        try {
            this.setConfiguration(Base64.decodeBase64((byte[])encodedConfiguration.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getEncodedConfiguration() {
        if (this.getConfiguration() == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64((byte[])this.getConfiguration()), "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public String toString() {
        String TAB = "    ";
        StringBuilder retValue = new StringBuilder();
        retValue.append("InfomanSetupHistory ( ").append(super.toString()).append("    ").append("configurationChecksum = ").append(this.configurationChecksum).append("    ").append("configurationChecksumType = ").append(this.configurationChecksumType).append("    ").append("configurationContentType = ").append(this.configurationContentType).append("    ").append("configurationName = ").append(this.configurationName).append("    ").append("createTime = ").append(this.createTime).append("    ").append("deviceType = ").append(this.deviceType).append("    ").append("hardware = ").append(this.hardware).append("    ").append("hardwareSn = ").append(this.hardwareSn).append("    ").append("id = ").append(this.id).append("    ").append("infomanSn = ").append(this.infomanSn).append("    ").append("javavmVersion = ").append(this.javaVmVersion).append("    ").append("kernelVersion = ").append(this.kernelVersion).append("    ").append("pmVersion = ").append(this.powerManagementVersion).append("    ").append("rootfsVersion = ").append(this.rootfsVersion).append("    ").append("softwareVersion = ").append(this.softwareVersion).append("    ").append("softwareRevision = ").append(this.softwareRevision).append("    ").append("unitId = ").append(this.unitId).append("    ").append("modemFirmwareVersion").append(this.modemFirmwareVersion).append("    ").append("simCardNo").append(this.simCardNo).append("    ").append("imsi").append(this.imsi).append("    ").append("imei").append(this.imei).append("    ").append("gpsFirmware").append(this.gpsFirmware).append("    ").append("modemType").append(this.modemType).append("    ").append("wifiFirmware").append(this.wifiFirmware).append("    ").append("wifiMac").append(this.wifiMac).append("    ").append("vehicleId").append(this.vehicleId).append("    ").append(" )");
        return retValue.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.configuration);
        result = 31 * result + (this.configurationChecksum == null ? 0 : this.configurationChecksum.hashCode());
        result = 31 * result + (this.configurationChecksumType == null ? 0 : this.configurationChecksumType.hashCode());
        result = 31 * result + (this.configurationContentType == null ? 0 : this.configurationContentType.hashCode());
        result = 31 * result + (this.configurationName == null ? 0 : this.configurationName.hashCode());
        result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
        result = 31 * result + (this.deviceType == null ? 0 : this.deviceType.hashCode());
        result = 31 * result + (this.hardware == null ? 0 : this.hardware.hashCode());
        result = 31 * result + (this.hardwareSn == null ? 0 : this.hardwareSn.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.infomanSn == null ? 0 : this.infomanSn.hashCode());
        result = 31 * result + (this.javaVmVersion == null ? 0 : this.javaVmVersion.hashCode());
        result = 31 * result + (this.kernelVersion == null ? 0 : this.kernelVersion.hashCode());
        result = 31 * result + (this.powerManagementVersion == null ? 0 : this.powerManagementVersion.hashCode());
        result = 31 * result + (this.rootfsVersion == null ? 0 : this.rootfsVersion.hashCode());
        result = 31 * result + (this.softwareVersion == null ? 0 : this.softwareVersion.hashCode());
        result = 31 * result + (int)(this.unitId ^ this.unitId >>> 32);
        result = 31 * result + (this.modemFirmwareVersion == null ? 0 : this.modemFirmwareVersion.hashCode());
        result = 31 * result + (this.simCardNo == null ? 0 : this.simCardNo.hashCode());
        result = 31 * result + (this.imsi == null ? 0 : this.imsi.hashCode());
        result = 31 * result + (this.imei == null ? 0 : this.imei.hashCode());
        result = 31 * result + (this.gpsFirmware == null ? 0 : this.gpsFirmware.hashCode());
        result = 31 * result + (this.modemType == null ? 0 : this.modemType.hashCode());
        result = 31 * result + (this.wifiFirmware == null ? 0 : this.wifiFirmware.hashCode());
        result = 31 * result + (this.wifiMac == null ? 0 : this.wifiMac.hashCode());
        result = 31 * result + (this.vehicleId == null ? 0 : this.vehicleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfomanSetupHistory)) {
            return false;
        }
        InfomanSetupHistory other = (InfomanSetupHistory)((Object)obj);
        if (!Arrays.equals(this.configuration, other.configuration)) {
            return false;
        }
        if (this.configurationChecksum == null ? other.configurationChecksum != null : !this.configurationChecksum.equals(other.configurationChecksum)) {
            return false;
        }
        if (this.configurationChecksumType == null ? other.configurationChecksumType != null : !this.configurationChecksumType.equals(other.configurationChecksumType)) {
            return false;
        }
        if (this.configurationContentType == null ? other.configurationContentType != null : !this.configurationContentType.equals(other.configurationContentType)) {
            return false;
        }
        if (this.configurationName == null ? other.configurationName != null : !this.configurationName.equals(other.configurationName)) {
            return false;
        }
        if (this.createTime != other.createTime) {
            return false;
        }
        if (this.deviceType == null ? other.deviceType != null : !this.deviceType.equals(other.deviceType)) {
            return false;
        }
        if (this.hardware == null ? other.hardware != null : !this.hardware.equals(other.hardware)) {
            return false;
        }
        if (this.hardwareSn == null ? other.hardwareSn != null : !this.hardwareSn.equals(other.hardwareSn)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.infomanSn == null ? other.infomanSn != null : !this.infomanSn.equals(other.infomanSn)) {
            return false;
        }
        if (this.javaVmVersion == null ? other.javaVmVersion != null : !this.javaVmVersion.equals(other.javaVmVersion)) {
            return false;
        }
        if (this.kernelVersion == null ? other.kernelVersion != null : !this.kernelVersion.equals(other.kernelVersion)) {
            return false;
        }
        if (this.powerManagementVersion == null ? other.powerManagementVersion != null : !this.powerManagementVersion.equals(other.powerManagementVersion)) {
            return false;
        }
        if (this.rootfsVersion == null ? other.rootfsVersion != null : !this.rootfsVersion.equals(other.rootfsVersion)) {
            return false;
        }
        if (this.softwareVersion == null ? other.softwareVersion != null : !this.softwareVersion.equals(other.softwareVersion)) {
            return false;
        }
        if (this.softwareRevision == null ? other.softwareRevision != null : !this.softwareRevision.equals(other.softwareRevision)) {
            return false;
        }
        if (this.unitId != other.unitId) {
            return false;
        }
        if (this.modemFirmwareVersion == null ? other.modemFirmwareVersion != null : !this.modemFirmwareVersion.equals(other.modemFirmwareVersion)) {
            return false;
        }
        if (this.simCardNo == null ? other.simCardNo != null : !this.simCardNo.equals(other.simCardNo)) {
            return false;
        }
        if (this.imsi == null ? other.imsi != null : !this.imsi.equals(other.imsi)) {
            return false;
        }
        if (this.imei == null ? other.imei != null : !this.imei.equals(other.imei)) {
            return false;
        }
        if (this.gpsFirmware == null ? other.gpsFirmware != null : !this.gpsFirmware.equals(other.gpsFirmware)) {
            return false;
        }
        if (this.modemType == null ? other.modemType != null : !this.modemType.equals(other.modemType)) {
            return false;
        }
        if (this.wifiFirmware == null ? other.wifiFirmware != null : !this.wifiFirmware.equals(other.wifiFirmware)) {
            return false;
        }
        if (this.wifiMac == null ? other.wifiMac != null : !this.wifiMac.equals(other.wifiMac)) {
            return false;
        }
        return !(this.vehicleId == null ? other.vehicleId != null : !this.vehicleId.equals(other.vehicleId));
    }

    public void setSoftwareRevision(String softwareRevision) {
        this.softwareRevision = softwareRevision;
    }

    public String getSoftwareRevision() {
        return this.softwareRevision;
    }
}

