/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.geo;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.base.HistoryHelperBase;
import de.proveo.wwt.datamodel.geo.GdataBase;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.geo.GdataHistoryHelper;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IEndTime;
import de.proveo.wwt.logic.ejb.dataIn.event.history.IHistoryEntity;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="gdata_history")
@NamedQueries(value={@NamedQuery(name="findGdataHistoryAll", query="SELECT h FROM GdataHistory h"), @NamedQuery(name="findGdataHistoryByUnit", query="SELECT h FROM GdataHistory h WHERE h.unitId = :unitId AND h.endTime > :begin AND h.beginTime < :end ORDER BY h.beginTime DESC"), @NamedQuery(name="findGdataHistoryByUnitIdAtTime", query="SELECT h FROM GdataHistory h WHERE h.unitId = ?1 AND h.endTime > ?2 AND h.beginTime < ?2"), @NamedQuery(name="findByUnitIdBegintime", query="SELECT h FROM GdataHistory h WHERE h.unitId = ?1 AND h.beginTime = ?2"), @NamedQuery(name="gdataHistory.findMaxId", query="SELECT MAX(h.id) FROM GdataHistory h")})
public class GdataHistory
extends GdataBase
implements IHistoryEntity<GdataHistory, GdataCache>,
IEndTime {
    private static final long serialVersionUID = -7215732915602645363L;
    @Id
    @Column(name="ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @ToString
    private long id;
    @OneToMany(targetEntity=GdataHistoryHelper.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="ID", updatable=false, insertable=false)
    private List<GdataHistoryHelper> gdataHistoryHelper;
    @Column(name="END_TIME")
    @Equals
    @ToString
    private long endTime;
    @Column(name="END_RECEIVE_TIME")
    @Equals
    @ToString
    private long endReceiveTime;
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private Long unitId;
    @AuditRelevant
    @ManyToOne(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    @Equals
    @ToString
    private UnitModel unitModel;
    @OneToOne(targetEntity=GdataCache.class, fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="history")
    @JoinColumn(name="id", referencedColumnName="history_id", insertable=false, updatable=false)
    private GdataCache cache;

    public GdataHistory(GdataCache gdataCache) {
        super(gdataCache);
        this.endTime = 0L;
        this.endReceiveTime = 0L;
        this.setLoggingEnabled(false);
    }

    public GdataHistory() {
        this.setLoggingEnabled(false);
    }

    @Override
    public Class<? extends HistoryHelperBase> getHelperClass() {
        return GdataHistoryHelper.class;
    }

    @Override
    public void finishHistory(GdataHistory oldHistory) {
        oldHistory.endTime = this.getBeginTime();
        oldHistory.endReceiveTime = this.getBeginReceiveTime();
    }

    @Override
    public GdataCache generateCache() {
        return new GdataCache(this);
    }

    @Override
    public void setHistoryId(long historyId) {
        this.id = historyId;
    }

    @Override
    public long getHistoryId() {
        return this.id;
    }

    public Object getPrimaryKey() {
        return this.id;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }

    @Override
    public void setEndReceiveTime(long endReceiveTime) {
        this.endReceiveTime = endReceiveTime;
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    public void setCache(GdataCache cache) {
        this.cache = cache;
    }

    public GdataCache getCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GdataHistory");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("endTime = ");
        stringBuilder.append(this.endTime);
        stringBuilder.append(", ");
        stringBuilder.append("endReceiveTime = ");
        stringBuilder.append(this.endReceiveTime);
        stringBuilder.append(", ");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId == null ? "[null]" : this.unitId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("unitModel = ");
        stringBuilder.append(this.unitModel == null ? "[null]" : this.unitModel.toString());
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GdataHistory gdataHistory = (GdataHistory)object;
        if (this.id != gdataHistory.id) {
            return false;
        }
        if (this.endTime != gdataHistory.endTime) {
            return false;
        }
        if (this.endReceiveTime != gdataHistory.endReceiveTime) {
            return false;
        }
        if (this.unitId == null ? gdataHistory.unitId != null : !this.unitId.equals(gdataHistory.unitId)) {
            return false;
        }
        return !(this.unitModel == null ? gdataHistory.unitModel != null : !this.unitModel.equals(gdataHistory.unitModel));
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.id ^ this.id >>> 32);
        n2 = n * n2 + (int)(this.endTime ^ this.endTime >>> 32);
        n2 = n * n2 + (int)(this.endReceiveTime ^ this.endReceiveTime >>> 32);
        n2 = n * n2 + (this.unitId == null ? 0 : this.unitId.hashCode());
        n2 = n * n2 + (this.unitModel == null ? 0 : this.unitModel.hashCode());
        return n2;
    }
}

