/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.geo;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.geo.GdataBase;
import de.proveo.wwt.datamodel.geo.GdataHistory;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataIn.event.history.ICacheEntity;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="gdata_cache")
@NamedQueries(value={@NamedQuery(name="findCurrentGdataCacheAll", query="SELECT c FROM GdataCache c"), @NamedQuery(name="findCurrentGdataCacheAllByCreateTime", query="SELECT c FROM GdataCache c WHERE c.beginTime < ?1"), @NamedQuery(name="gdataCache.findAllOrderByHistoryId", query="SELECT c FROM GdataCache c ORDER BY c.historyId"), @NamedQuery(name="findCurrentGdataCacheAllSortedByUnitID", query="SELECT c FROM GdataCache c"), @NamedQuery(name="findCurrentGdataCacheByUnitId", query="SELECT c FROM GdataCache c WHERE c.unitId = ?1"), @NamedQuery(name="findCurrentGdataCacheByUnitIdCreatedTime", query="SELECT c FROM GdataCache c WHERE c.unitId = ?1 AND c.beginTime < ?2"), @NamedQuery(name="findCurrentGdataCacheByUnitGroupId", query="SELECT c FROM GdataCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1"), @NamedQuery(name="findCurrentGdataCacheByUnitGroupIdCreateTime", query="SELECT c FROM GdataCache c, IN (c.groupHistory.unitGroups) ug WHERE ug.unitId = ?1 AND c.beginTime < ?2")})
public class GdataCache
extends GdataBase
implements ICacheEntity<GdataHistory> {
    private static final long serialVersionUID = -1052495542335317077L;
    @AuditRelevant
    @Id
    @Column(name="UNIT_ID")
    @Equals
    @ToString
    private long unitId;
    @AuditRelevant
    @OneToOne(targetEntity=UnitModel.class, fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="UNIT_ID", updatable=false, insertable=false)
    @Equals
    @ToString
    private UnitModel unitModel;
    @Column(name="history_id", nullable=false)
    @Equals
    @ToString
    private long historyId;
    @OneToOne(targetEntity=GdataHistory.class, fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="history_id", updatable=false, insertable=false)
    private GdataHistory history;

    public GdataCache() {
        this.setLoggingEnabled(false);
    }

    public GdataCache(GdataBase gdataBase) {
        super(gdataBase);
        this.unitId = gdataBase.getUnitId();
        this.unitModel = new UnitModel(this.unitId);
        this.setLoggingEnabled(false);
    }

    public long getTimestamp() {
        return this.getBeginTime();
    }

    public void setTimestamp(long timestamp) {
        this.setBeginTime(timestamp);
    }

    public Object getPrimaryKey() {
        return this.getUnitId();
    }

    @Override
    public long getUnitId() {
        return this.unitId;
    }

    @Override
    public void setUnitId(long unitId) {
        this.unitId = unitId;
    }

    @Override
    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    @Override
    protected void setUnitModel(UnitModel unitModel) {
        this.unitModel = unitModel;
    }

    @Override
    public long getHistoryId() {
        return this.historyId;
    }

    @Override
    public void setHistoryId(long historyId) {
        this.historyId = historyId;
    }

    @Override
    public GdataHistory getHistory() {
        return this.history;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GdataCache");
        stringBuilder.append(" (");
        stringBuilder.append("unitId = ");
        stringBuilder.append(this.unitId);
        stringBuilder.append(", ");
        stringBuilder.append("unitModel = ");
        stringBuilder.append(this.unitModel == null ? "[null]" : this.unitModel.toString());
        stringBuilder.append(", ");
        stringBuilder.append("historyId = ");
        stringBuilder.append(this.historyId);
        stringBuilder.append(" (");
        stringBuilder.append(super.toString());
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GdataCache gdataCache = (GdataCache)object;
        if (this.unitId != gdataCache.unitId) {
            return false;
        }
        if (this.unitModel == null ? gdataCache.unitModel != null : !this.unitModel.equals(gdataCache.unitModel)) {
            return false;
        }
        return this.historyId == gdataCache.historyId;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = n * n2 + (int)(this.unitId ^ this.unitId >>> 32);
        n2 = n * n2 + (this.unitModel == null ? 0 : this.unitModel.hashCode());
        n2 = n * n2 + (int)(this.historyId ^ this.historyId >>> 32);
        return n2;
    }
}

