/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.fis;

import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.logic.ejb.interfaces.fis.standState.StandStateCacheValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="fis_flight")
@NamedQueries(value={@NamedQuery(name="findFlightsByFLNandST", query="SELECT o FROM FISFlight o WHERE o.flightNumber=?1 AND o.scheduledTime=?2 AND o.current=1 AND o.deleted=0 ORDER BY o.receiveTime"), @NamedQuery(name="findFlightsByFLNandSTandMOVTYPE", query="SELECT o FROM FISFlight o WHERE o.flightNumber=?1 AND o.scheduledTime=?2 AND o.movementType=?3 AND o.current=1 AND o.deleted=0 ORDER BY o.receiveTime"), @NamedQuery(name="findSequence", query="SELECT o FROM FISFlight o WHERE o.sequenceId=?1 AND o.deleted=0 "), @NamedQuery(name="findCurrentSequence", query="SELECT o FROM FISFlight o WHERE o.sequenceId=?1 AND o.current=1 AND o.deleted=0 "), @NamedQuery(name="findFlightsBySeqIdandStand", query="SELECT o FROM FISFlight o WHERE o.sequenceId=?1 and o.parkingStand=?2 AND o.deleted=0 ORDER BY o.receiveTime"), @NamedQuery(name="findCurrentFlightsByStand", query="SELECT o FROM FISFlight o WHERE  o.parkingStand=?1 AND o.deleted=0 AND o.current=1 ORDER BY o.bestTime"), @NamedQuery(name="findFlightsByUFN", query="SELECT o FROM FISFlight o WHERE o.uniqueFlightNumber=?1 AND o.deleted=0 ORDER BY receiveTime"), @NamedQuery(name="findCurrentFlightByUFN", query="SELECT o from FISFlight o WHERE o.uniqueFlightNumber=?1 AND o.current=1 AND o.deleted=0"), @NamedQuery(name="findCurrentFlightByLFLNAndLSTAndMovType", query="SELECT o from FISFlight o WHERE o.linkedFlightNumber=?1 AND o.linkedScheduledTime=?2 AND o.movementType=?3 AND o.current=1 AND o.deleted=0"), @NamedQuery(name="findPairInbound", query="SELECT o from FISFlight o where ((o.scheduledTime in (SELECT max(i.scheduledTime) FROM FISFlight i where i.movementType in ('A') AND i.sequenceId=?1 AND i.scheduledTime<?2 AND i.current=1 AND i.deleted=0) AND o.movementType in ('A')) or (o.plannedTime in (SELECT max(i.plannedTime) FROM FISFlight i where i.movementType in ('N') AND i.sequenceId=?1 AND i.plannedTime<?2 AND i.current=1 AND i.deleted=0) AND o.movementType in ('N'))) AND o.sequenceId=?1 AND o.current=1 AND o.deleted=0 ORDER BY o.receiveTime DESC"), @NamedQuery(name="findInboundByPKey", query="SELECT o from FISFlight o where o.movementType in ('A','N') AND pairKey=?1 AND o.current=1 AND o.deleted=0 ORDER BY o.receiveTime DESC"), @NamedQuery(name="findOutboundByPKey", query="SELECT o from FISFlight o where o.movementType in ('D','F') AND pairKey=?1 AND o.current=1 AND o.deleted=0 ORDER BY o.receiveTime DESC"), @NamedQuery(name="findLinkedFlights", query="SELECT o from FISFlight o where o.linkedFlightNumber=?1 AND o.linkedScheduledTime=?2 AND o.current=1 AND o.deleted=0")})
public class FISFlight
extends EntityBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Column(name="ID")
    private long id;
    @Column(name="UFN")
    private String uniqueFlightNumber;
    @Column(name="FLN")
    private String flightNumber;
    @Column(name="ST")
    private long scheduledTime;
    @Column(name="LINKED_FLN")
    private String linkedFlightNumber;
    @Column(name="LINKED_ST")
    private long linkedScheduledTime;
    @Column(name="SEQ_ID")
    private Long sequenceId;
    @Column(name="PKEY")
    private String pairKey;
    @Column(name="MOV_TYPE")
    private String movementType;
    @Column(name="CUST_CRT")
    private long customerCreateTime;
    @Column(name="CUST_UPDT")
    private long customerUpdateTime;
    @Column(name="RCVT")
    private long receiveTime;
    @Column(name="ET")
    private long estimatedTime;
    @Column(name="OT")
    private long onOffBlockTime;
    @Column(name="PLANT")
    private long plannedTime;
    @Column(name="BT")
    private long bestTime;
    @Column(name="TAT")
    private long touchdownAirborneTime;
    @Column(name="TMO")
    private long tenMilesOut;
    @Column(name="IATA_AC")
    private String iataAirlineCode;
    @Column(name="ICAO_AC")
    private String icaoAirlineCode;
    @Column(name="STAND")
    private String parkingStand;
    @Column(name="GATE")
    private String gate;
    @Column(name="CAROUSEL")
    private String carousel;
    @Column(name="AC_TYPE")
    private String aircraftType;
    @Column(name="REG")
    private String registration;
    @Column(name="ORIG")
    private String origin;
    @Column(name="DEST")
    private String destination;
    @Column(name="FL_STATUS")
    private String flightStatus;
    @Column(name="FL_CATEGORY")
    private String flightCategory;
    @Column(name="FL_NATURE")
    private String flightNature;
    @Column(name="TERMINAL")
    private String terminal;
    @Column(name="REMARK")
    private String remark;
    @Column(name="CURR")
    private boolean current = true;
    @Column(name="DELETED")
    private boolean deleted = false;
    @Transient
    private HashMap<Long, StandStateCacheValue> previousStandStates = new HashMap();
    @Transient
    private HashMap<Long, StandStateCacheValue> currentStandStates = new HashMap();

    public String toString() {
        String TAB = "    ";
        String retValue = "";
        retValue = "FisFlight ( " + super.toString() + "    " + "id = " + this.id + "    " + "uniqueFlightNumber = " + this.uniqueFlightNumber + "    " + "flightNumber = " + this.flightNumber + "    " + "scheduledTime = " + this.scheduledTime + "    " + "linkedFlightNumber = " + this.linkedFlightNumber + "    " + "linkedScheduledTime = " + this.linkedScheduledTime + "    " + "sequenceId = " + this.sequenceId + "    " + "pairKey = " + this.pairKey + "    " + "movementType = " + this.movementType + "    " + "customerCreateTime = " + this.customerCreateTime + "    " + "customerUpdateTime = " + this.customerUpdateTime + "    " + "receiveTime = " + this.receiveTime + "    " + "estimatedTime = " + this.estimatedTime + "    " + "onOffBlockTime = " + this.onOffBlockTime + "    " + "plannedTime = " + this.plannedTime + "    " + "bestTime = " + this.bestTime + "    " + "touchdownAirborneTime = " + this.touchdownAirborneTime + "    " + "tenMilesOut = " + this.tenMilesOut + "    " + "iataAirlineCode = " + this.iataAirlineCode + "    " + "icaoAirlineCode = " + this.icaoAirlineCode + "    " + "parkingStand = " + this.parkingStand + "    " + "gate = " + this.gate + "    " + "carousel = " + this.carousel + "    " + "aircraftType = " + this.aircraftType + "    " + "registration = " + this.registration + "    " + "origin = " + this.origin + "    " + "destination = " + this.destination + "    " + "flightStatus = " + this.flightStatus + "    " + "flightCategory = " + this.flightCategory + "    " + "flightNature = " + this.flightNature + "    " + "terminal = " + this.terminal + "    " + "remark = " + this.remark + "    " + "current = " + this.current + "    " + "deleted = " + this.deleted + "    " + " )";
        return retValue;
    }

    private void calcBestTime() {
        long bt = 0L;
        if (this.scheduledTime != 0L) {
            bt = this.scheduledTime;
        }
        if (this.plannedTime != 0L) {
            bt = this.plannedTime;
        }
        if (this.estimatedTime != 0L) {
            bt = this.estimatedTime;
        }
        if (this.onOffBlockTime != 0L) {
            bt = this.onOffBlockTime;
        }
        this.bestTime = bt;
    }

    private void buildUniqueFlightNumber() {
        if (this.uniqueFlightNumber == null && this.movementType != null) {
            if ((this.movementType.equals("A") || this.movementType.equals("D")) && this.flightNumber != null && this.scheduledTime != 0L) {
                this.uniqueFlightNumber = this.flightNumber + "-" + this.scheduledTime;
            }
            if ((this.movementType.equals("N") || this.movementType.equals("F")) && this.linkedFlightNumber != null && this.linkedScheduledTime != 0L && this.plannedTime != 0L) {
                this.uniqueFlightNumber = this.linkedFlightNumber + "-" + this.linkedScheduledTime + "-" + this.plannedTime;
            }
        }
    }

    private String nullifyEmptyString(String text) {
        if (text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUniqueFlightNumber() {
        return this.uniqueFlightNumber;
    }

    public void setUniqueFlightNumber(String uniqueFlightNumber) {
        this.uniqueFlightNumber = this.nullifyEmptyString(uniqueFlightNumber);
    }

    public String getFlightNumber() {
        return this.flightNumber;
    }

    public void setFlightNumber(String flightNumber) {
        this.flightNumber = this.nullifyEmptyString(flightNumber);
        this.buildUniqueFlightNumber();
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
        this.calcBestTime();
        this.buildUniqueFlightNumber();
    }

    public String getLinkedFlightNumber() {
        return this.linkedFlightNumber;
    }

    public void setLinkedFlightNumber(String linkedFlightNumber) {
        this.linkedFlightNumber = this.nullifyEmptyString(linkedFlightNumber);
        this.buildUniqueFlightNumber();
    }

    public long getLinkedScheduledTime() {
        return this.linkedScheduledTime;
    }

    public void setLinkedScheduledTime(long linkedScheduledTime) {
        this.linkedScheduledTime = linkedScheduledTime;
        this.buildUniqueFlightNumber();
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(Long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public String getPairKey() {
        return this.pairKey;
    }

    public void setPairKey(String pairKey) {
        this.pairKey = pairKey;
    }

    public String getMovementType() {
        return this.movementType;
    }

    public void setMovementType(String movementType) {
        this.movementType = this.nullifyEmptyString(movementType);
        this.buildUniqueFlightNumber();
    }

    public long getCustomerCreateTime() {
        return this.customerCreateTime;
    }

    public void setCustomerCreateTime(long customerCreateTime) {
        this.customerCreateTime = customerCreateTime;
    }

    public long getCustomerUpdateTime() {
        return this.customerUpdateTime;
    }

    public void setCustomerUpdateTime(long customerUpdateTime) {
        this.customerUpdateTime = customerUpdateTime;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setReceiveTime(long receiveTime) {
        this.receiveTime = receiveTime;
    }

    public long getEstimatedTime() {
        return this.estimatedTime;
    }

    public void setEstimatedTime(long estimatedTime) {
        this.estimatedTime = estimatedTime;
        this.calcBestTime();
    }

    public long getOnOffBlockTime() {
        return this.onOffBlockTime;
    }

    public void setOnOffBlockTime(long onOffBlockTime) {
        this.onOffBlockTime = onOffBlockTime;
        this.calcBestTime();
    }

    public long getPlannedTime() {
        return this.plannedTime;
    }

    public void setPlannedTime(long plannedTime) {
        this.plannedTime = plannedTime;
        this.calcBestTime();
        this.buildUniqueFlightNumber();
    }

    public long getBestTime() {
        return this.bestTime;
    }

    public void setBestTime(long bestTime) {
        this.bestTime = bestTime;
    }

    public long getTouchdownAirborneTime() {
        return this.touchdownAirborneTime;
    }

    public void setTouchdownAirborneTime(long touchdownAirborneTime) {
        this.touchdownAirborneTime = touchdownAirborneTime;
    }

    public long getTenMilesOut() {
        return this.tenMilesOut;
    }

    public void setTenMilesOut(long tenMilesOut) {
        this.tenMilesOut = tenMilesOut;
    }

    public String getIataAirlineCode() {
        return this.iataAirlineCode;
    }

    public void setIataAirlineCode(String iataAirlineCode) {
        this.iataAirlineCode = this.nullifyEmptyString(iataAirlineCode);
    }

    public String getIcaoAirlineCode() {
        return this.icaoAirlineCode;
    }

    public void setIcaoAirlineCode(String icaoAirlineCode) {
        this.icaoAirlineCode = this.nullifyEmptyString(icaoAirlineCode);
    }

    public String getParkingStand() {
        return this.parkingStand;
    }

    public void setParkingStand(String parkingStand) {
        this.parkingStand = this.nullifyEmptyString(parkingStand);
    }

    public String getGate() {
        return this.gate;
    }

    public void setGate(String gate) {
        this.gate = this.nullifyEmptyString(gate);
    }

    public String getCarousel() {
        return this.carousel;
    }

    public void setCarousel(String carousel) {
        this.carousel = this.nullifyEmptyString(carousel);
    }

    public String getAircraftType() {
        return this.aircraftType;
    }

    public void setAircraftType(String aircraftType) {
        this.aircraftType = this.nullifyEmptyString(aircraftType);
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = this.nullifyEmptyString(registration);
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = this.nullifyEmptyString(origin);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = this.nullifyEmptyString(destination);
    }

    public String getFlightStatus() {
        return this.flightStatus;
    }

    public void setFlightStatus(String flightStatus) {
        this.flightStatus = this.nullifyEmptyString(flightStatus);
    }

    public String getFlightCategory() {
        return this.flightCategory;
    }

    public void setFlightCategory(String flightCategory) {
        this.flightCategory = this.nullifyEmptyString(flightCategory);
    }

    public String getFlightNature() {
        return this.flightNature;
    }

    public void setFlightNature(String flightNature) {
        this.flightNature = this.nullifyEmptyString(flightNature);
    }

    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = this.nullifyEmptyString(terminal);
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public HashMap<Long, StandStateCacheValue> getPreviousStandStates() {
        return this.previousStandStates;
    }

    public void setPreviousStandStates(HashMap<Long, StandStateCacheValue> previousStandStates) {
        this.previousStandStates = previousStandStates;
    }

    public HashMap<Long, StandStateCacheValue> getCurrentStandStates() {
        return this.currentStandStates;
    }

    public void setCurrentStandStates(HashMap<Long, StandStateCacheValue> currentStandStates) {
        this.currentStandStates = currentStandStates;
    }

    public StandStateCacheValue getPreviousStandState(Long stateModelId) {
        return this.previousStandStates.get(stateModelId);
    }

    public void setPreviousStandStatesList(List<StandStateCacheValue> previousStandStateList) {
        for (StandStateCacheValue c : previousStandStateList) {
            this.previousStandStates.put(c.getPk().getStateModelId(), c);
        }
    }

    public StandStateCacheValue getCurrentStandState(Long stateModelId) {
        return this.currentStandStates.get(stateModelId);
    }

    public void setCurrentStandStatesList(List<StandStateCacheValue> currentStandStateList) {
        for (StandStateCacheValue c : currentStandStateList) {
            this.currentStandStates.put(c.getPk().getStateModelId(), c);
        }
    }

    public boolean isInbound() {
        return "A".equals(this.movementType) || "N".equals(this.movementType);
    }

    public boolean isOutbound() {
        return "D".equals(this.movementType) || "F".equals(this.movementType);
    }

    public boolean equalsWithoutIdAndRecvTime(FISFlight other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (this.aircraftType == null ? other.aircraftType != null : !this.aircraftType.equals(other.aircraftType)) {
            return false;
        }
        if (this.bestTime != other.bestTime) {
            return false;
        }
        if (this.carousel == null ? other.carousel != null : !this.carousel.equals(other.carousel)) {
            return false;
        }
        if (this.customerCreateTime != other.customerCreateTime) {
            return false;
        }
        if (this.customerUpdateTime != other.customerUpdateTime) {
            return false;
        }
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        if (this.estimatedTime != other.estimatedTime) {
            return false;
        }
        if (this.flightCategory == null ? other.flightCategory != null : !this.flightCategory.equals(other.flightCategory)) {
            return false;
        }
        if (this.flightNature == null ? other.flightNature != null : !this.flightNature.equals(other.flightNature)) {
            return false;
        }
        if (this.flightNumber == null ? other.flightNumber != null : !this.flightNumber.equals(other.flightNumber)) {
            return false;
        }
        if (this.flightStatus == null ? other.flightStatus != null : !this.flightStatus.equals(other.flightStatus)) {
            return false;
        }
        if (this.gate == null ? other.gate != null : !this.gate.equals(other.gate)) {
            return false;
        }
        if (this.iataAirlineCode == null ? other.iataAirlineCode != null : !this.iataAirlineCode.equals(other.iataAirlineCode)) {
            return false;
        }
        if (this.icaoAirlineCode == null ? other.icaoAirlineCode != null : !this.icaoAirlineCode.equals(other.icaoAirlineCode)) {
            return false;
        }
        if (this.linkedFlightNumber == null ? other.linkedFlightNumber != null : !this.linkedFlightNumber.equals(other.linkedFlightNumber)) {
            return false;
        }
        if (this.linkedScheduledTime != other.linkedScheduledTime) {
            return false;
        }
        if (this.movementType == null ? other.movementType != null : !this.movementType.equals(other.movementType)) {
            return false;
        }
        if (this.onOffBlockTime != other.onOffBlockTime) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.pairKey == null ? other.pairKey != null : !this.pairKey.equals(other.pairKey)) {
            return false;
        }
        if (this.parkingStand == null ? other.parkingStand != null : !this.parkingStand.equals(other.parkingStand)) {
            return false;
        }
        if (this.plannedTime != other.plannedTime) {
            return false;
        }
        if (this.registration == null ? other.registration != null : !this.registration.equals(other.registration)) {
            return false;
        }
        if (this.scheduledTime != other.scheduledTime) {
            return false;
        }
        if (this.sequenceId == null ? other.sequenceId != null : !this.sequenceId.equals(other.sequenceId)) {
            return false;
        }
        if (this.tenMilesOut != other.tenMilesOut) {
            return false;
        }
        if (this.terminal == null ? other.terminal != null : !this.terminal.equals(other.terminal)) {
            return false;
        }
        if (this.remark == null ? other.remark != null : !this.remark.equals(other.remark)) {
            return false;
        }
        if (this.touchdownAirborneTime != other.touchdownAirborneTime) {
            return false;
        }
        if (this.uniqueFlightNumber == null ? other.uniqueFlightNumber != null : !this.uniqueFlightNumber.equals(other.uniqueFlightNumber)) {
            return false;
        }
        return this.deleted == other.deleted;
    }

    public String getName() {
        return this.getPrimaryKey().toString();
    }

    public Object getPrimaryKey() {
        return this.id;
    }
}

