/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.file;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.util.jpa.entity.EntityBase;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.file.FileDirectory;
import de.proveo.wwt.datamodel.module.Module;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class FileBase
extends EntityBase {
    private static final long serialVersionUID = 4877691264112530153L;
    @Equals
    @Id
    @Column(name="id")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @ToString
    private int id;
    @Equals
    @Column(name="name", length=255, nullable=false)
    @ToString
    private String name;
    @Equals
    @Column(name="description", length=2048)
    @ToString
    private String description;
    @Equals
    @Column(name="create_time", nullable=false)
    @ToString
    private long createTime;
    @Equals
    @Column(name="update_time", nullable=false)
    @ToString
    private long updateTime;
    @Equals
    @Column(name="user_id")
    @ToString
    private Long userId;
    @ManyToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(name="user_id", updatable=false, insertable=false)
    private Account user;
    @Equals
    @Column(name="parent_id")
    @ToString
    private Integer parentId;
    @ManyToOne(targetEntity=FileDirectory.class, fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id", updatable=false, insertable=false)
    private FileDirectory parentDirectory;
    @Equals
    @Column(name="module_id", nullable=false)
    @ToString
    private int moduleId;
    @ManyToOne(targetEntity=Module.class, fetch=FetchType.LAZY)
    @JoinColumn(name="module_id", updatable=false, insertable=false)
    private Module module;

    public Object getPrimaryKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Account getUser() {
        return this.user;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentDirectoryId) {
        this.parentId = parentDirectoryId;
    }

    public FileDirectory getParentDirectory() {
        return this.parentDirectory;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    @PreUpdate
    private void preUpdate() {
        this.updateTime = System.currentTimeMillis();
    }

    @PrePersist
    private void prePersist() {
        long currentTime;
        this.createTime = currentTime = System.currentTimeMillis();
        this.updateTime = currentTime;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FileBase");
        stringBuilder.append(" (");
        stringBuilder.append("id = ");
        stringBuilder.append(this.id);
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("createTime = ");
        stringBuilder.append(this.createTime);
        stringBuilder.append(", ");
        stringBuilder.append("updateTime = ");
        stringBuilder.append(this.updateTime);
        stringBuilder.append(", ");
        stringBuilder.append("userId = ");
        stringBuilder.append(this.userId == null ? "[null]" : this.userId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("parentId = ");
        stringBuilder.append(this.parentId == null ? "[null]" : this.parentId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("moduleId = ");
        stringBuilder.append(this.moduleId);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        FileBase fileBase = (FileBase)((Object)object);
        if (this.id != fileBase.id) {
            return false;
        }
        if (this.name == null ? fileBase.name != null : !this.name.equals(fileBase.name)) {
            return false;
        }
        if (this.description == null ? fileBase.description != null : !this.description.equals(fileBase.description)) {
            return false;
        }
        if (this.createTime != fileBase.createTime) {
            return false;
        }
        if (this.updateTime != fileBase.updateTime) {
            return false;
        }
        if (this.userId == null ? fileBase.userId != null : !this.userId.equals(fileBase.userId)) {
            return false;
        }
        if (this.parentId == null ? fileBase.parentId != null : !this.parentId.equals(fileBase.parentId)) {
            return false;
        }
        return this.moduleId == fileBase.moduleId;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + this.id;
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + (int)(this.createTime ^ this.createTime >>> 32);
        n2 = n * n2 + (int)(this.updateTime ^ this.updateTime >>> 32);
        n2 = n * n2 + (this.userId == null ? 0 : this.userId.hashCode());
        n2 = n * n2 + (this.parentId == null ? 0 : this.parentId.hashCode());
        n2 = n * n2 + this.moduleId;
        return n2;
    }
}

