/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.datamodel.custom;

import de.proveo.maven.plugins.extendedObject.annotations.Equals;
import de.proveo.maven.plugins.extendedObject.annotations.ToString;
import de.proveo.wwt.datamodel.AuditEntityBase;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditRelevant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="custom_script")
@NamedQueries(value={@NamedQuery(name="findCustomScriptsByName", query="SELECT s FROM CustomScript s WHERE s.name=?1 ORDER BY s.scriptOrder"), @NamedQuery(name="CustomScript.findAll", query="SELECT s FROM CustomScript s ORDER BY s.scriptOrder"), @NamedQuery(name="findScriptsByEntryPointForAllUnits", query="SELECT s FROM CustomScript s WHERE s.entryPoint=?1 AND s.units IS EMPTY ORDER BY s.scriptOrder"), @NamedQuery(name="findActiveScriptsByEntryPointForAllUnits", query="SELECT s FROM CustomScript s WHERE s.enabled=true AND s.entryPoint=?1 AND s.units IS EMPTY ORDER BY s.scriptOrder"), @NamedQuery(name="findScriptsByEntryPointAndUnit", query="SELECT s FROM CustomScript s, IN (s.units) u WHERE s.entryPoint=?1 AND u.unitId = ?2 ORDER BY s.scriptOrder"), @NamedQuery(name="findActiveScriptsByEntryPointAndUnit", query="SELECT s FROM CustomScript s, IN (s.units) u WHERE s.enabled=true AND s.entryPoint=?1 AND u.unitId = ?2 ORDER BY s.scriptOrder")})
public class CustomScript
extends AuditEntityBase
implements Serializable {
    private static final int MAX_BLOB_SIZE = Integer.MAX_VALUE;
    public static final String LANG_GROOVY = "Groovy";
    @Id
    @Column(name="SCRIPT_ID")
    @GenericGenerator(name="incrementer", strategy="increment")
    @GeneratedValue(generator="incrementer")
    @Equals
    @AuditRelevant
    @ToString
    private Integer scriptId;
    @Column(name="SCRIPT_ORDER")
    @Equals
    @AuditRelevant
    @ToString
    private Integer scriptOrder;
    @Column(name="ENTRY_POINT")
    @Equals
    @AuditRelevant
    @ToString
    private String entryPoint;
    @Equals
    @AuditRelevant
    @ManyToMany(targetEntity=UnitModel.class, fetch=FetchType.EAGER)
    @JoinTable(name="custom_script_x_unitmodel", joinColumns={@JoinColumn(name="ID_SCRIPT")}, inverseJoinColumns={@JoinColumn(name="ID_UNIT")})
    @ToString
    private List<UnitModel> units = new ArrayList<UnitModel>();
    @Column(name="CHILD_UNIT_ENABLED")
    @Equals
    @AuditRelevant
    @ToString
    private Boolean childUnitEnabled;
    @Column(name="SCRIPT_NAME")
    @Equals
    @AuditRelevant
    @ToString
    private String name;
    @Column(name="CATEGORY_NAME")
    @Equals
    @AuditRelevant
    @ToString
    private String categoryName;
    @Column(name="DESCRIPTION")
    @Equals
    @AuditRelevant
    @ToString
    private String description;
    @Column(name="SCRIPT_LANGUAGE")
    @Equals
    @AuditRelevant
    @ToString
    private String language;
    @Column(length=0x7FFFFFFF, name="SOURCE")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Equals
    @AuditRelevant
    private byte[] source;
    @Column(name="ENABLED")
    @Equals
    @AuditRelevant
    @ToString
    private Boolean enabled;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public byte[] getSource() {
        return this.source;
    }

    public void setSource(byte[] source) {
        this.source = source;
    }

    public List<UnitModel> getUnits() {
        return this.units;
    }

    public void setUnits(List<UnitModel> units) {
        this.units = units;
    }

    public Integer getScriptOrder() {
        return this.scriptOrder;
    }

    public void setScriptOrder(Integer scriptOrder) {
        this.scriptOrder = scriptOrder;
    }

    public boolean isChildUnitEnabled() {
        if (this.childUnitEnabled == null) {
            return false;
        }
        return this.childUnitEnabled;
    }

    public void setChildUnitEnabled(boolean childUnitEnabled) {
        this.childUnitEnabled = childUnitEnabled;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public Integer getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(Integer scriptId) {
        this.scriptId = scriptId;
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Object getPrimaryKey() {
        return this.scriptId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CustomScript");
        stringBuilder.append(" (");
        stringBuilder.append("scriptId = ");
        stringBuilder.append(this.scriptId == null ? "[null]" : this.scriptId.toString());
        stringBuilder.append(", ");
        stringBuilder.append("scriptOrder = ");
        stringBuilder.append(this.scriptOrder == null ? "[null]" : this.scriptOrder.toString());
        stringBuilder.append(", ");
        stringBuilder.append("entryPoint = ");
        stringBuilder.append(this.entryPoint == null ? "[null]" : this.entryPoint.toString());
        stringBuilder.append(", ");
        stringBuilder.append("units = ");
        stringBuilder.append(this.units == null ? "[null]" : this.units.toString());
        stringBuilder.append(", ");
        stringBuilder.append("childUnitEnabled = ");
        stringBuilder.append(this.childUnitEnabled == null ? "[null]" : this.childUnitEnabled.toString());
        stringBuilder.append(", ");
        stringBuilder.append("name = ");
        stringBuilder.append(this.name == null ? "[null]" : this.name.toString());
        stringBuilder.append(", ");
        stringBuilder.append("categoryName = ");
        stringBuilder.append(this.categoryName == null ? "[null]" : this.categoryName.toString());
        stringBuilder.append(", ");
        stringBuilder.append("description = ");
        stringBuilder.append(this.description == null ? "[null]" : this.description.toString());
        stringBuilder.append(", ");
        stringBuilder.append("language = ");
        stringBuilder.append(this.language == null ? "[null]" : this.language.toString());
        stringBuilder.append(", ");
        stringBuilder.append("enabled = ");
        stringBuilder.append(this.enabled == null ? "[null]" : this.enabled.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CustomScript customScript = (CustomScript)object;
        if (this.scriptId == null ? customScript.scriptId != null : !this.scriptId.equals(customScript.scriptId)) {
            return false;
        }
        if (this.scriptOrder == null ? customScript.scriptOrder != null : !this.scriptOrder.equals(customScript.scriptOrder)) {
            return false;
        }
        if (this.entryPoint == null ? customScript.entryPoint != null : !this.entryPoint.equals(customScript.entryPoint)) {
            return false;
        }
        if (this.units == null ? customScript.units != null : !this.units.equals(customScript.units)) {
            return false;
        }
        if (this.childUnitEnabled == null ? customScript.childUnitEnabled != null : !this.childUnitEnabled.equals(customScript.childUnitEnabled)) {
            return false;
        }
        if (this.name == null ? customScript.name != null : !this.name.equals(customScript.name)) {
            return false;
        }
        if (this.categoryName == null ? customScript.categoryName != null : !this.categoryName.equals(customScript.categoryName)) {
            return false;
        }
        if (this.description == null ? customScript.description != null : !this.description.equals(customScript.description)) {
            return false;
        }
        if (this.language == null ? customScript.language != null : !this.language.equals(customScript.language)) {
            return false;
        }
        if (!Arrays.equals(this.source, customScript.source)) {
            return false;
        }
        return !(this.enabled == null ? customScript.enabled != null : !this.enabled.equals(customScript.enabled));
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (this.scriptId == null ? 0 : this.scriptId.hashCode());
        n2 = n * n2 + (this.scriptOrder == null ? 0 : this.scriptOrder.hashCode());
        n2 = n * n2 + (this.entryPoint == null ? 0 : this.entryPoint.hashCode());
        n2 = n * n2 + (this.units == null ? 0 : this.units.hashCode());
        n2 = n * n2 + (this.childUnitEnabled == null ? 0 : this.childUnitEnabled.hashCode());
        n2 = n * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = n * n2 + (this.categoryName == null ? 0 : this.categoryName.hashCode());
        n2 = n * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = n * n2 + (this.language == null ? 0 : this.language.hashCode());
        n2 = n * n2 + Arrays.hashCode(this.source);
        n2 = n * n2 + (this.enabled == null ? 0 : this.enabled.hashCode());
        return n2;
    }
}

